/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.entity.AdEntity;
import weixin.cms.entity.CmsArticleEntity;
import weixin.cms.entity.CmsMenuEntity;
import weixin.cms.service.CmsArticleServiceI;
import weixin.cms.service.CmsMenuServiceI;
import weixin.guanjia.account.service.WeixinAccountServiceI;

@Controller
@RequestMapping(value={"/cmsMenuController"})
public class CmsMenuController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CmsMenuController.class);
    @Autowired
    private CmsMenuServiceI cmsMenuService;
    @Autowired
    private CmsArticleServiceI cmsArticleService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"index"})
    public ModelAndView index(HttpServletRequest request, String accountid, String userid) {
        List columnList = this.cmsMenuService.findByProperty(CmsMenuEntity.class, "accountid", accountid);
        List adList = this.systemService.findByProperty(AdEntity.class, "accountid", (Object)accountid);
        request.setAttribute("columnList", (Object)columnList);
        request.setAttribute("adList", (Object)adList);
        request.setAttribute("accountid", (Object)accountid);
        request.setAttribute("userid", (Object)userid);
        return new ModelAndView("weixin/cms/index");
    }

    @RequestMapping(params={"menu"})
    public ModelAndView menu(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)(request.getParameter("lang") == null ? "ZH" : request.getParameter("lang")));
        mv.setViewName("weixin/cms/cmsMenuList");
        return mv;
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public List<TreeGrid> datagrid(TreeGrid treegrid, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CmsMenuEntity.class);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)request.getParameterMap());
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("lang", (Object)(request.getParameter("lang") == null ? "ZH" : request.getParameter("lang")));
        if (treegrid.getId() != null) {
            cq.eq("pmenu.id", (Object)treegrid.getId());
        } else {
            cq.isNull("pmenu");
        }
        cq.addOrder("orders", SortDirection.asc);
        cq.add();
        List menuList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        List<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("name");
        treeGridModel.setIcon("showFlag");
        treeGridModel.setOrder("orders");
        treeGridModel.setSrc("type");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("menuList");
        treeGrids = this.systemService.treegrid(menuList, treeGridModel);
        block0: for (TreeGrid obj : treeGrids) {
            for (CmsMenuEntity menu : menuList) {
                if (!obj.getId().equals(menu.getId())) continue;
                HashMap<String, String> attr = new HashMap<String, String>();
                attr.put("linkUrl", menu.getLinkUrl());
                attr.put("cusTemplate", menu.getCusTemplate());
                List typeList = (List)TSTypegroup.allTypes.get("visittype");
                for (TSType type : typeList) {
                    if (!type.getTypecode().equals(menu.getVisitType())) continue;
                    attr.put("visitType", type.getTypename());
                }
                obj.setAttributes(attr);
                continue block0;
            }
        }
        return treeGrids;
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(CmsMenuEntity menu, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        menu = (CmsMenuEntity)this.systemService.getEntity(CmsMenuEntity.class, (Serializable)((Object)menu.getId()));
        this.message = "\u680f\u76ee\u7ba1\u7406\u5220\u9664\u6210\u529f";
        this.cmsMenuService.delete(menu);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(CmsMenuEntity menu, HttpServletRequest request) {
        String accountId;
        AjaxJson j = new AjaxJson();
        String pid = request.getParameter("parentId");
        if (StringUtil.isEmpty((String)pid)) {
            menu.setPmenu(null);
        }
        if (StringUtil.isEmpty((String)(accountId = ResourceUtil.getShangJiaAccountId())) || "-1".equals(accountId)) {
            j.setSuccess(false);
            this.message = "\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002";
        } else {
            CmsArticleEntity article;
            List articles;
            if (menu.getType().equals("02") && (articles = this.cmsMenuService.findByProperty(CmsArticleEntity.class, "columnId", menu.getId())) != null && articles.size() > 0) {
                article = (CmsArticleEntity)articles.get(0);
                article.setColumnId(null);
            }
            String articleId = request.getParameter("articleId");
            article = null;
            if (StringUtil.isNotEmpty((Object)articleId)) {
                article = (CmsArticleEntity)this.cmsMenuService.get(CmsArticleEntity.class, (Serializable)((Object)articleId));
            }
            if (StringUtil.isNotEmpty((Object)menu.getId())) {
                this.message = "\u680f\u76ee\u7ba1\u7406\u66f4\u65b0\u6210\u529f";
                CmsMenuEntity t = (CmsMenuEntity)this.cmsMenuService.get(CmsMenuEntity.class, (Serializable)((Object)menu.getId()));
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)menu, (Object)t);
                    t.setOrders(menu.getOrders());
                    if (!StringUtil.isEmpty((String)pid)) {
                        CmsMenuEntity pmenu = new CmsMenuEntity();
                        pmenu = (CmsMenuEntity)this.cmsMenuService.getEntity(CmsMenuEntity.class, (Serializable)((Object)pid));
                        t.setPmenu(pmenu);
                    }
                    if ("01".equals(menu.getType())) {
                        if (menu.getCusTemplate() != null && menu.getCusTemplate() != "") {
                            t.setLinkUrl("cmsController.do?goPage&page=" + menu.getCusTemplate() + "&id=" + menu.getId());
                        } else {
                            t.setLinkUrl("cmsController.do?goPage&page=newsList&id=" + menu.getId());
                        }
                    } else if ("02".equals(menu.getType())) {
                        if (menu.getCusTemplate() != null && menu.getCusTemplate() != "") {
                            t.setLinkUrl("cmsController.do?goPage&page=" + menu.getCusTemplate() + "&articleid=" + articleId);
                        } else {
                            t.setLinkUrl("cmsController.do?goPage&page=article&articleid=" + articleId);
                        }
                    }
                    this.cmsMenuService.saveOrUpdate(t);
                    if (article != null) {
                        article.setColumnId(t.getId());
                    }
                    this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.message = "\u680f\u76ee\u7ba1\u7406\u66f4\u65b0\u5931\u8d25";
                }
            } else {
                this.message = "\u680f\u76ee\u7ba1\u7406\u6dfb\u52a0\u6210\u529f";
                menu.setAccountid(accountId);
                if (!StringUtil.isEmpty((String)pid)) {
                    CmsMenuEntity pmenu = new CmsMenuEntity();
                    pmenu = (CmsMenuEntity)this.cmsMenuService.getEntity(CmsMenuEntity.class, (Serializable)((Object)pid));
                    menu.setPmenu(pmenu);
                }
                String id = (String)((Object)this.cmsMenuService.save(menu));
                CmsMenuEntity menuNew = new CmsMenuEntity();
                menuNew = (CmsMenuEntity)this.cmsMenuService.getEntity(CmsMenuEntity.class, (Serializable)((Object)id));
                if ("01".equals(menu.getType())) {
                    if (menu.getCusTemplate() != null && menu.getCusTemplate() != "") {
                        menuNew.setLinkUrl("cmsController.do?goPage&page=" + menu.getCusTemplate() + "&id=" + id);
                    } else {
                        menuNew.setLinkUrl("cmsController.do?goPage&page=newsList&id=" + id);
                    }
                } else if ("02".equals(menu.getType())) {
                    if (menu.getCusTemplate() != null && menu.getCusTemplate() != "") {
                        menuNew.setLinkUrl("cmsController.do?goPage&page=" + menu.getCusTemplate() + "&articleid=" + id);
                    } else {
                        menuNew.setLinkUrl("cmsController.do?goPage&page=article&articleid=" + id);
                    }
                }
                if (article != null) {
                    article.setColumnId(menu.getId());
                }
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(CmsMenuEntity menu, HttpServletRequest req) {
        List articles;
        String visitType;
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)req.getParameter("lang"));
        if (StringUtil.isNotEmpty((Object)menu.getId())) {
            menu = (CmsMenuEntity)this.cmsMenuService.getEntity(CmsMenuEntity.class, (Serializable)((Object)menu.getId()));
            req.setAttribute("columnPage", (Object)menu);
            if (menu.getPmenu() != null) {
                req.setAttribute("parentId", (Object)menu.getPmenu().getId());
            }
        }
        if (StringUtil.isEmpty((String)(visitType = menu.getVisitType()))) {
            req.setAttribute("visitType", (Object)"1");
        } else {
            req.setAttribute("visitType", (Object)visitType);
        }
        String parentId = req.getParameter("parentId");
        if (StringUtil.isNotEmpty((Object)parentId)) {
            CmsMenuEntity tmenu = (CmsMenuEntity)this.cmsMenuService.getEntity(CmsMenuEntity.class, (Serializable)((Object)parentId));
            CmsMenuEntity pmenu = new CmsMenuEntity();
            pmenu.setId(tmenu.getId());
            pmenu.setName(tmenu.getName());
            req.setAttribute("pmenu", (Object)pmenu);
            req.setAttribute("parentId", (Object)parentId);
        }
        if (menu.getType() != null && menu.getType().equals("02") && (articles = this.cmsMenuService.findByProperty(CmsArticleEntity.class, "columnId", menu.getId())) != null && articles.size() > 0) {
            CmsArticleEntity article = (CmsArticleEntity)articles.get(0);
            req.setAttribute("articleId", (Object)article.getId());
            req.setAttribute("articleTitle", (Object)article.getTitle());
        }
        mv.setViewName("weixin/cms/cmsMenu");
        return mv;
    }

    @RequestMapping(params={"treeMenu"})
    @ResponseBody
    public List<TreeGrid> treeMenu(HttpServletRequest request, ComboTree comboTree) {
        String lang = request.getParameter("lang");
        CriteriaQuery cq = new CriteriaQuery(CmsMenuEntity.class);
        if (StringUtil.isNotEmpty((Object)comboTree.getId())) {
            cq.eq("pmenu.id", (Object)comboTree.getId());
        }
        if (StringUtil.isEmpty((String)comboTree.getId())) {
            cq.isNull("pmenu.id");
        }
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("lang", (Object)lang);
        cq.add();
        List menuList = this.cmsMenuService.getListByCriteriaQuery(cq, false);
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("name");
        treeGridModel.setParentText("pmenu_name");
        treeGridModel.setParentId("pmenu_id");
        treeGridModel.setSrc("imageHref");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("menuList");
        treeGrids = this.systemService.treegrid(menuList, treeGridModel);
        return treeGrids;
    }
}

