/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import meishu.cmsdata.MsActivityDataCollect;
import meishu.cmsdata.MsCollectionDataCollect;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import weixin.cms.cmsdata.impl.CmsAdviceDataCollect;
import weixin.cms.cmsdata.impl.CmsArticleDataCollect;
import weixin.cms.cmsdata.impl.CmsCommentsCollect;
import weixin.cms.cmsdata.impl.CmsFullTextSearchCollect;
import weixin.cms.cmsdata.impl.CmsIndexDataCollect;
import weixin.cms.cmsdata.impl.CmsLeaveMsgDataCollect;
import weixin.cms.cmsdata.impl.CmsMemberScoreCollect;
import weixin.cms.cmsdata.impl.CmsMemberUpdateDataCollect;
import weixin.cms.cmsdata.impl.CmsMenuDataCollect;
import weixin.cms.cmsdata.impl.CmsOrderTicketCollect;
import weixin.cms.cmsdata.impl.CmsOrderTicketDataCollect;
import weixin.cms.cmsdata.impl.CmsPhotoAlbumDataCollect;
import weixin.cms.cmsdata.impl.CmsPhotoDataCollect;
import weixin.cms.cmsdata.impl.CmsPhotoSohuDataCollect;
import weixin.cms.cmsdata.impl.CmsRegisterDataCollect;
import weixin.cms.common.CmsDataContent;
import weixin.cms.common.LocaleUtil;
import weixin.cms.entity.CmsArticleEntity;
import weixin.cms.entity.WeixinCmsSiteEntity;
import weixin.cms.service.CmsArticleServiceI;
import weixin.cms.service.CmsMenuServiceI;
import weixin.cms.service.WeixinCmsSiteServiceI;
import weixin.cms.service.WeixinCmsStyleServiceI;
import weixin.cms.util.CmsCollectExcutor;
import weixin.cms.util.CmsFreemarkerHelper;
import weixin.shop.base.entity.WeixinShopTempletEntity;
import weixin.vip.entity.WeixinVipMemberEntity;

@Controller
@RequestMapping(value={"/cmsController"})
public class CmsController
extends BaseController {
    @Autowired
    private CmsArticleServiceI cmsArticleService;
    @Autowired
    private WeixinCmsSiteServiceI weixinCmsSiteService;
    @Autowired
    private WeixinCmsStyleServiceI weixinCmsStyleService;
    @Autowired
    private CmsMenuServiceI cmsMenuService;
    private static Map<String, Object> dataCollectContent = new HashMap<String, Object>();

    static {
        dataCollectContent.put("index", new CmsIndexDataCollect());
        dataCollectContent.put("menu", new CmsMenuDataCollect());
        dataCollectContent.put("article", new CmsArticleDataCollect());
        dataCollectContent.put("photoAlbum", new CmsPhotoAlbumDataCollect());
        dataCollectContent.put("photo", new CmsPhotoDataCollect());
        dataCollectContent.put("photoSohu", new CmsPhotoSohuDataCollect());
        dataCollectContent.put("leaveMsg", new CmsLeaveMsgDataCollect());
        dataCollectContent.put("msActivityArticle", new MsActivityDataCollect());
        dataCollectContent.put("newsList", new CmsMenuDataCollect());
        dataCollectContent.put("collectionDetail", new MsCollectionDataCollect());
        dataCollectContent.put("memberCenter", new CmsMemberUpdateDataCollect());
        dataCollectContent.put("memberCenterUpdate", new CmsMemberUpdateDataCollect());
        dataCollectContent.put("register", new CmsRegisterDataCollect());
        dataCollectContent.put("applyOnline", new CmsRegisterDataCollect());
        dataCollectContent.put("adDetail", new CmsAdviceDataCollect());
        dataCollectContent.put("orderTicketInfo", new CmsOrderTicketDataCollect());
        dataCollectContent.put("orderTicket", new CmsOrderTicketCollect());
        dataCollectContent.put("memberScore", new CmsMemberScoreCollect());
        dataCollectContent.put("fullTextSearch", new CmsFullTextSearchCollect());
        dataCollectContent.put("comments", new CmsCommentsCollect());
    }

    @RequestMapping(value={"/page/{parameId}"})
    public String pageRest(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="parameId") String parameId) {
        String parentId;
        Map<String, String> params = this.paramsToMap(request);
        String lang = LocaleUtil.getLocaleLang();
        params.put("lang", lang);
        CmsDataContent.put("lang", lang);
        CmsDataContent.put("domain", ResourceUtil.getDomainByConfig());
        String accountId = request.getParameter("accountid");
        if (oConvertUtils.isEmpty((Object)accountId)) {
            accountId = ResourceUtil.getDomanAccountId();
            params.put("accountid", accountId);
        }
        LogUtil.info((Object)("cms AccountId == " + accountId + " goPage == " + parameId));
        String styleUrl = this.getUseTemplateUrl(request, parameId, accountId, params);
        String styleUrlSystemURL = this.getUseTemplateUrlSystemURL(request, parameId, accountId, params);
        if ("fullTextSearch".equals(parameId)) {
            params.put("fullText", styleUrlSystemURL);
        }
        String templateName = params.get("styleName");
        String staticFile = this.getStaticFile(request, styleUrlSystemURL, parameId);
        String res = "template/cms/" + params.get("styleName");
        CmsDataContent.put("base", res);
        if (this.isStatic(parameId) && staticFile == null) {
            return this.accessStaticPage(request, templateName, parameId);
        }
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        WeixinVipMemberEntity mem = (WeixinVipMemberEntity)request.getSession().getAttribute("memberSession");
        CmsDataContent.put("memberSession", mem);
        if (mem != null) {
            params.put("memberId", mem.getId());
        }
        if (CmsDataContent.get("menuList") == null) {
            CmsCollectExcutor.collect("cms", "index", params);
        }
        if (CmsCollectExcutor.get("cms", parameId) != null) {
            CmsCollectExcutor.collect("cms", parameId, params);
        }
        if ((parentId = request.getParameter("menuParentId")) != null) {
            CmsDataContent.put("menuSecList", this.cmsMenuService.listMapSecond(parentId));
            Map<String, Object> map = this.cmsMenuService.getById(parentId);
            CmsDataContent.put("menuFirstName", map != null ? map.get("NAME") : "");
        } else {
            CmsDataContent.put("menuSecList", new ArrayList());
            CmsDataContent.put("menuFirstName", "");
        }
        CmsDataContent.put("rootUrl", this.getWebRootUrl(request));
        CmsDataContent.put("lang", lang);
        String tplPath = String.valueOf(parameId) + ".html";
        if (this.isStatic(parameId)) {
            cmsFreemarkerHelper.genStaticPage(String.valueOf(styleUrl) + tplPath, staticFile, CmsDataContent.loadContent());
            return this.accessStaticPage(request, templateName, parameId);
        }
        String pageUrl = String.valueOf(styleUrl) + parameId + ".html";
        String html = cmsFreemarkerHelper.parseTemplate(pageUrl, CmsDataContent.loadContent());
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @RequestMapping(params={"goPage"})
    public void goPage(HttpServletRequest request, HttpServletResponse response, @RequestParam String page) {
        String parentId;
        Map<String, String> params = this.paramsToMap(request);
        String lang = LocaleUtil.getLocaleLang();
        params.put("lang", lang);
        CmsDataContent.put("domain", ResourceUtil.getDomainByConfig());
        String accountId = request.getParameter("accountid");
        if (oConvertUtils.isEmpty((Object)accountId)) {
            accountId = ResourceUtil.getDomanAccountId();
            params.put("accountid", accountId);
        }
        LogUtil.info((Object)("cms AccountId == " + accountId + " goPage == " + page));
        String styleUrl = this.getUseTemplateUrl(request, page, accountId, params);
        WeixinVipMemberEntity mem = (WeixinVipMemberEntity)request.getSession().getAttribute("memberSession");
        CmsDataContent.put("lang", lang);
        CmsDataContent.put("memberSession", mem);
        if (mem != null) {
            params.put("memberId", mem.getId());
        }
        String res = "template/cms/" + params.get("styleName");
        CmsDataContent.put("base", res);
        if (CmsDataContent.get("menuList") == null) {
            CmsCollectExcutor.collect("cms", "index", params);
        }
        if (CmsCollectExcutor.get("cms", page) != null) {
            CmsCollectExcutor.collect("cms", page, params);
        }
        if ((parentId = request.getParameter("menuParentId")) != null) {
            CmsDataContent.put("menuSecList", this.cmsMenuService.listMapSecond(parentId));
            Map<String, Object> map = this.cmsMenuService.getById(parentId);
            CmsDataContent.put("menuFirstName", map != null ? map.get("NAME") : null);
        } else {
            CmsDataContent.put("menuSecList", new ArrayList());
            CmsDataContent.put("menuFirstName", "");
        }
        CmsDataContent.put("rootUrl", this.getWebRootUrl(request));
        String pageUrl = String.valueOf(styleUrl) + page + ".html";
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        String html = cmsFreemarkerHelper.parseTemplate(pageUrl, CmsDataContent.loadContent());
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getUseTemplateUrl(HttpServletRequest request, String page, String accountId, Map<String, String> params) {
        String rootUrl = this.getRootUrl(request, page);
        String styleUrl = null;
        String templateName = null;
        if ("leaveMsg".equals(page) || "photoAlbum".equals(page) || "photo".equals(page) || "photoSohu".equals(page)) {
            if ("photo".equals(page)) {
                params.put("styleName", "photoAlbum");
            } else {
                params.put("styleName", page);
            }
            styleUrl = String.valueOf(rootUrl) + "/html/";
            return styleUrl;
        }
        WeixinCmsSiteEntity weixinCmsSiteEntity = null;
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.getLanguage();
        List list = this.weixinCmsSiteService.findByQueryString("from WeixinCmsSiteEntity where lang ='" + lang + "' and accountid = '" + accountId + "'");
        if (list != null && list.size() > 0) {
            weixinCmsSiteEntity = (WeixinCmsSiteEntity)list.get(0);
        }
        WeixinShopTempletEntity weixinShopTempletEntity = null;
        if (weixinCmsSiteEntity != null) {
            CmsDataContent.put("title", weixinCmsSiteEntity.getSiteName());
            CmsDataContent.put("logo", weixinCmsSiteEntity.getSiteLogo());
            CmsDataContent.put("content", weixinCmsSiteEntity.getContent());
            if (weixinCmsSiteEntity.getSiteTemplateStyle() != null) {
                weixinShopTempletEntity = (WeixinShopTempletEntity)this.weixinCmsStyleService.get(WeixinShopTempletEntity.class, (Serializable)((Object)weixinCmsSiteEntity.getSiteTemplateStyle()));
            }
            if (weixinShopTempletEntity != null) {
                templateName = weixinShopTempletEntity.getTplpath();
                styleUrl = String.valueOf(rootUrl) + "/" + weixinShopTempletEntity.getTplpath() + "/html/";
            } else {
                templateName = "meishu";
                styleUrl = String.valueOf(rootUrl) + "/meishu/html/";
            }
        } else {
            templateName = "meishu";
            styleUrl = String.valueOf(rootUrl) + "/meishu/html/";
        }
        params.put("styleName", templateName);
        return styleUrl;
    }

    private String getUseTemplateUrlSystemURL(HttpServletRequest request, String page, String accountId, Map<String, String> params) {
        String rootUrl = this.getRootUrlSystemUrl(request, page);
        String styleUrl = null;
        String templateName = null;
        if ("leaveMsg".equals(page) || "photoAlbum".equals(page) || "photo".equals(page) || "photoSohu".equals(page)) {
            if ("photo".equals(page)) {
                params.put("styleName", "photoAlbum");
            } else {
                params.put("styleName", page);
            }
            styleUrl = String.valueOf(rootUrl) + "/html/";
            return styleUrl;
        }
        WeixinCmsSiteEntity weixinCmsSiteEntity = null;
        Locale locale = LocaleContextHolder.getLocale();
        String lang = locale.getLanguage();
        List list = this.weixinCmsSiteService.findByQueryString("from WeixinCmsSiteEntity where lang ='" + lang + "' and accountid = '" + accountId + "'");
        if (list != null && list.size() > 0) {
            weixinCmsSiteEntity = (WeixinCmsSiteEntity)list.get(0);
        }
        WeixinShopTempletEntity weixinShopTempletEntity = null;
        if (weixinCmsSiteEntity != null) {
            CmsDataContent.put("title", weixinCmsSiteEntity.getSiteName());
            CmsDataContent.put("logo", weixinCmsSiteEntity.getSiteLogo());
            CmsDataContent.put("content", weixinCmsSiteEntity.getContent());
            if (weixinCmsSiteEntity.getSiteTemplateStyle() != null) {
                weixinShopTempletEntity = (WeixinShopTempletEntity)this.weixinCmsStyleService.get(WeixinShopTempletEntity.class, (Serializable)((Object)weixinCmsSiteEntity.getSiteTemplateStyle()));
            }
            if (weixinShopTempletEntity != null) {
                templateName = weixinShopTempletEntity.getTplpath();
                styleUrl = String.valueOf(rootUrl) + "/" + weixinShopTempletEntity.getTplpath() + "/html/";
            } else {
                templateName = "meishu";
                styleUrl = String.valueOf(rootUrl) + "/meishu/html/";
            }
        } else {
            templateName = "meishu";
            styleUrl = String.valueOf(rootUrl) + "/meishu/html/";
        }
        params.put("styleName", templateName);
        return styleUrl;
    }

    private String getRootUrlSystemUrl(HttpServletRequest request, String page) {
        String rootUrl = null;
        rootUrl = "leaveMsg".equals(page) || "photoAlbum".equals(page) || "photo".equals(page) || "photoSohu".equals(page) ? String.valueOf(request.getSession().getServletContext().getRealPath("/template/common")) + "\\" + page : request.getSession().getServletContext().getRealPath("/template/cms");
        return rootUrl;
    }

    private String getRootUrl(HttpServletRequest request, String page) {
        String rootUrl = null;
        rootUrl = "leaveMsg".equals(page) || "photoSohu".equals(page) ? "/template/common/" + page : ("photoAlbum".equals(page) || "photo".equals(page) ? "/template/common/photoAlbum" : "/template/cms");
        return rootUrl;
    }

    @RequestMapping(params={"getMenuList"})
    public void getMenuList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        Map<String, String> params = this.paramsToMap(request);
        List<CmsArticleEntity> list = this.cmsArticleService.listByMap(params, dataGrid.getPage(), dataGrid.getRows());
        int count = this.cmsArticleService.getCount(params);
        dataGrid.setTotal(count);
        dataGrid.setResults(list);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    private String getWebRootUrl(HttpServletRequest request) {
        String basePath = ResourceUtil.getConfigByName((String)"domain");
        return basePath;
    }

    private Map<String, String> paramsToMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String paramName = (String)em.nextElement();
            String paramValue = request.getParameter(paramName);
            params.put(paramName, paramValue);
        }
        return params;
    }

    private String accessStaticPage(HttpServletRequest request, String templateName, String page) {
        String lang = LocaleUtil.getLocaleLang();
        StringBuffer str = new StringBuffer();
        String htmlname = null;
        htmlname = oConvertUtils.isNotEmpty((Object)request.getQueryString()) ? String.valueOf(request.getRequestURI().substring(request.getRequestURI().indexOf("page/") + 5)) + "&" + oConvertUtils.getString((String)request.getQueryString()) : request.getRequestURI().substring(request.getRequestURI().indexOf("page/") + 5);
        str.append("cms/").append(templateName).append("/").append("static").append("/").append(lang).append("/").append(htmlname);
        return str.toString();
    }

    private String getStaticFile(HttpServletRequest request, String styleUrl, String page) {
        String staticFile;
        File file;
        String htmlname = null;
        htmlname = oConvertUtils.isNotEmpty((Object)request.getQueryString()) ? String.valueOf(request.getRequestURI().substring(request.getRequestURI().indexOf("page/") + 5)) + "&" + oConvertUtils.getString((String)request.getQueryString()) : request.getRequestURI().substring(request.getRequestURI().indexOf("page/") + 5);
        String lang = LocaleUtil.getLocaleLang();
        String staticDir = String.valueOf(styleUrl) + "static" + "/" + lang + "/";
        File staticDirFile = new File(staticDir);
        if (!staticDirFile.exists()) {
            staticDirFile.mkdirs();
        }
        if ((file = new File(staticFile = String.valueOf(staticDir) + htmlname + ".html")).exists()) {
            return null;
        }
        return staticFile;
    }

    public boolean isStatic(String parameId) {
        return "true".equals(ResourceUtil.getConfigByName((String)"site.static.flag").toLowerCase()) && !oConvertUtils.isInString((String)parameId, (String)ResourceUtil.getConfigByName((String)"site.static.no.page"));
    }
}

