/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.ComboTree;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.ComboTreeModel;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.entity.CmsArticleEntity;
import weixin.cms.entity.CmsMenuEntity;
import weixin.cms.service.CmsArticleServiceI;
import weixin.cms.service.CmsMenuServiceI;
import weixin.guanjia.account.service.WeixinAccountServiceI;

@Controller
@RequestMapping(value={"/cmsArticleController"})
public class CmsArticleController
extends BaseController {
    private static final Logger logger = Logger.getLogger(CmsArticleController.class);
    @Autowired
    private CmsArticleServiceI cmsArticleService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private CmsMenuServiceI cmsMenuService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"cmsArticle"})
    public ModelAndView cmsArticle(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView();
        request.setAttribute("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        mv.addObject("lang", (Object)request.getParameter("lang"));
        mv.setViewName("weixin/cms/cmsArticleList");
        return mv;
    }

    @RequestMapping(params={"selArticle"})
    public ModelAndView selArticle(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView();
        request.setAttribute("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        mv.addObject("lang", (Object)request.getParameter("lang"));
        mv.setViewName("weixin/cms/selArticle");
        return mv;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(CmsArticleEntity cmsArticle, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CmsArticleEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)cmsArticle, (Map)request.getParameterMap());
        this.cmsArticleService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"datagridwx"})
    public void datagridwx(CmsArticleEntity cmsArticle, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(CmsArticleEntity.class, dataGrid);
        cq.eq("columnId", (Object)cmsArticle.getColumnId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)cmsArticle, (Map)request.getParameterMap());
        this.cmsArticleService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(CmsArticleEntity cmsArticle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        cmsArticle = (CmsArticleEntity)this.systemService.getEntity(CmsArticleEntity.class, (Serializable)((Object)cmsArticle.getId()));
        this.message = "\u4fe1\u606f\u5220\u9664\u6210\u529f";
        this.cmsArticleService.delete(cmsArticle);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4fe1\u606f\u6279\u91cf\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                CmsArticleEntity cmsArticle = (CmsArticleEntity)this.systemService.getEntity(CmsArticleEntity.class, (Serializable)((Object)id));
                this.cmsArticleService.delete(cmsArticle);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4fe1\u606f\u6279\u91cf\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(CmsArticleEntity cmsArticle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String accountId = ResourceUtil.getShangJiaAccountId();
        String columnName = request.getParameter("columnName");
        if (StringUtil.isEmpty((String)accountId) || "-1".equals(accountId)) {
            j.setSuccess(false);
            this.message = "\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002";
        } else if (StringUtil.isNotEmpty((Object)cmsArticle.getId())) {
            this.message = "\u4fe1\u606f\u66f4\u65b0\u6210\u529f";
            CmsArticleEntity t = (CmsArticleEntity)this.cmsArticleService.get(CmsArticleEntity.class, (Serializable)((Object)cmsArticle.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)cmsArticle, (Object)t);
                t.setColumnId(columnName);
                this.cmsArticleService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u4fe1\u606f\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u4fe1\u606f\u6dfb\u52a0\u6210\u529f";
            cmsArticle.setAccountid(accountId);
            cmsArticle.setColumnId(columnName);
            this.cmsArticleService.save(cmsArticle);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(CmsArticleEntity cmsArticle, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)cmsArticle.getId())) {
            cmsArticle = (CmsArticleEntity)this.cmsArticleService.getEntity(CmsArticleEntity.class, (Serializable)((Object)cmsArticle.getId()));
            req.setAttribute("cmsArticlePage", (Object)cmsArticle);
            req.setAttribute("columnId", (Object)cmsArticle.getColumnId());
            CmsMenuEntity menu = (CmsMenuEntity)this.cmsArticleService.getEntity(CmsMenuEntity.class, (Serializable)((Object)cmsArticle.getColumnId()));
            if (menu != null) {
                req.setAttribute("columnName", (Object)menu.getName());
            }
        }
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)req.getParameter("lang"));
        req.setAttribute("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        mv.setViewName("weixin/cms/cmsArticle");
        return mv;
    }

    @RequestMapping(params={"cmsArticleListShow"})
    public ModelAndView cmsArticleListShow(HttpServletRequest request) {
        if (StringUtil.isNotEmpty((Object)request.getParameter("columnId"))) {
            request.setAttribute("column", this.cmsArticleService.getEntity(CmsMenuEntity.class, (Serializable)((Object)request.getParameter("columnId"))));
        }
        return new ModelAndView("weixin/cms/cmsArticleListShow");
    }

    @RequestMapping(params={"cmsArticleShow"})
    public ModelAndView cmsArticleShow(HttpServletRequest request) {
        if (StringUtil.isNotEmpty((Object)request.getParameter("articleId"))) {
            CmsArticleEntity cmsArticle = (CmsArticleEntity)this.cmsArticleService.getEntity(CmsArticleEntity.class, (Serializable)((Object)request.getParameter("articleId")));
            request.setAttribute("cmsArticlePage", (Object)cmsArticle);
        }
        return new ModelAndView("weixin/cms/cmsArticleShow");
    }

    @RequestMapping(params={"treeMenu"})
    @ResponseBody
    public List<ComboTree> treeMenu(HttpServletRequest request, ComboTree comboTree) {
        CriteriaQuery cq = new CriteriaQuery(CmsMenuEntity.class);
        String lang = request.getParameter("lang");
        if (StringUtil.isNotEmpty((Object)comboTree.getId())) {
            cq.eq("pmenu.id", (Object)comboTree.getId());
        }
        if (StringUtil.isEmpty((String)comboTree.getId())) {
            cq.isNull("pmenu.id");
        }
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("lang", (Object)lang);
        cq.add();
        List menuList = this.cmsMenuService.getListByCriteriaQuery(cq, false);
        ArrayList<ComboTree> comboTrees = new ArrayList();
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "name", "menuList");
        comboTrees = this.systemService.ComboTree(menuList, comboTreeModel, null);
        return comboTrees;
    }
}

