/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.entity.AdEntity;
import weixin.cms.service.AdServiceI;
import weixin.guanjia.account.service.WeixinAccountServiceI;

@Controller
@RequestMapping(value={"/adController"})
public class AdController
extends BaseController {
    private static final Logger logger = Logger.getLogger(AdController.class);
    @Autowired
    private AdServiceI adService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"ad"})
    public ModelAndView ad(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)(request.getParameter("lang") == null ? "ZH" : request.getParameter("lang")));
        mv.setViewName("weixin/cms/adList");
        return mv;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(AdEntity ad, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(AdEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)ad, (Map)request.getParameterMap());
        this.adService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(AdEntity ad, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        ad = (AdEntity)this.systemService.getEntity(AdEntity.class, (Serializable)((Object)ad.getId()));
        this.message = "\u9996\u9875\u5e7f\u544a\u5220\u9664\u6210\u529f";
        this.adService.delete(ad);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(AdEntity ad, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String accountId = ResourceUtil.getShangJiaAccountId();
        if (StringUtil.isEmpty((String)accountId) || "-1".equals(accountId)) {
            j.setSuccess(false);
            this.message = "\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002";
        } else if (StringUtil.isNotEmpty((Object)ad.getId())) {
            this.message = "\u9996\u9875\u5e7f\u544a\u66f4\u65b0\u6210\u529f";
            AdEntity t = (AdEntity)this.adService.get(AdEntity.class, (Serializable)((Object)ad.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)ad, (Object)t);
                t.setOrders(ad.getOrders());
                this.adService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u9996\u9875\u5e7f\u544a\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u9996\u9875\u5e7f\u544a\u6dfb\u52a0\u6210\u529f";
            ad.setAccountid(accountId);
            this.adService.save(ad);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(AdEntity ad, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)ad.getId())) {
            ad = (AdEntity)this.adService.getEntity(AdEntity.class, (Serializable)((Object)ad.getId()));
            req.setAttribute("adPage", (Object)ad);
        }
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)req.getParameter("lang"));
        mv.setViewName("weixin/cms/ad");
        return mv;
    }
}

