/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.cmsdata.impl;

import java.util.Date;
import java.util.Map;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.ContextHolderUtils;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import weixin.cms.cmsdata.CmsPageDataCollectI;
import weixin.cms.common.CmsDataContent;
import weixin.cms.common.LocaleUtil;
import weixin.cms.entity.WeixinCmsArticleCommentEntity;
import weixin.cms.service.WeixinCmsArticleCommentServiceI;
import weixin.vip.entity.WeixinVipMemberEntity;

public class CmsCommentsCollect
implements CmsPageDataCollectI {
    @Override
    public void collect(Map<String, String> params) {
        WeixinCmsArticleCommentServiceI weixinCmsArticleCommentService = (WeixinCmsArticleCommentServiceI)ApplicationContextUtil.getContext().getBean("weixinCmsArticleCommentService");
        WeixinVipMemberEntity t = (WeixinVipMemberEntity)ContextHolderUtils.getSession().getAttribute("memberSession");
        if (t != null) {
            CmsDataContent.put("memberId", t.getMemberName());
            CmsDataContent.put("memberName", t.getMemberName());
        } else {
            CmsDataContent.put("memberId", "GT00000001");
            String lang = LocaleUtil.getLocaleLang();
            if ("EN".equals(lang)) {
                CmsDataContent.put("memberName", "Guest");
            } else if ("ZH".equals(lang)) {
                CmsDataContent.put("memberName", "\u533f\u540d\u7528\u6237");
            } else {
                CmsDataContent.put("memberName", "Guest");
            }
        }
        WeixinCmsArticleCommentEntity weixinCmsArticleComment = new WeixinCmsArticleCommentEntity();
        DataGrid dataGrid = new DataGrid();
        String pageNo = params.get("pageNo") == null ? "1" : params.get("pageNo");
        String rows = params.get("rows") == null ? "1" : params.get("rows");
        String category = params.get("category");
        String articleid = params.get("articleid");
        if (category != null && articleid != null) {
            CmsDataContent.put("category", category);
            CmsDataContent.put("articleid", articleid);
            dataGrid.setPage(Integer.valueOf(pageNo).intValue());
            dataGrid.setRows(Integer.valueOf(rows).intValue());
            dataGrid.setSort("commentTime");
            dataGrid.setOrder(SortDirection.desc);
            weixinCmsArticleComment.setCommentCategory(category);
            weixinCmsArticleComment.setArticleId(articleid);
            weixinCmsArticleComment.setStatus(2);
            CriteriaQuery cq = new CriteriaQuery(WeixinCmsArticleCommentEntity.class, dataGrid);
            HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsArticleComment);
            weixinCmsArticleCommentService.getDataGridReturn(cq, true);
        }
        String res = "template/cms/" + params.get("styleName");
        CmsDataContent.put("base", res);
        CmsDataContent.put("dataGrid", dataGrid);
        CmsDataContent.put("sysDate", new Date());
    }
}

