/*
 * Decompiled with CFR 0.152.
 */
package weixin.bbs.service.impl;

import java.util.List;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.wxuser.user.JwUserAPI;
import org.jeewx.api.wxuser.user.model.Wxuser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.bbs.service.WeixinBbsServiceI;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;

@Service(value="weixinBbsService")
@Transactional
public class WeixinBbsServiceImpl
extends CommonServiceImpl
implements WeixinBbsServiceI {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @Override
    public GzUserInfoYw getNickname(String openid, String accountId) {
        GzUserInfoYw user = new GzUserInfoYw();
        List data = this.findByProperty(GzUserInfoYw.class, "openid", openid);
        if (data != null && data.size() > 0) {
            GzUserInfoYw u = (GzUserInfoYw)((Object)data.get(0));
            user.setNickname(new String(WeixinUtil.decode(u.getNickname())));
            user.setHeadimgurl(u.getHeadimgurl());
            user.setOpenid(u.getOpenid());
        } else {
            String accesstoken = this.weixinAccountService.getAccessToken(accountId);
            try {
                Wxuser u = JwUserAPI.getWxuser((String)accesstoken, (String)openid);
                user.setNickname(u.getNickname());
                user.setHeadimgurl(u.getHeadimgurl());
                user.setOpenid(u.getOpenid());
            }
            catch (WexinReqException e) {
                e.printStackTrace();
            }
        }
        return user;
    }
}

