/*
 * Decompiled with CFR 0.152.
 */
package weixin.bbs.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.bbs.entity.WeixinBbsEntity;
import weixin.bbs.entity.WeixinBbsPostCommentEntity;
import weixin.bbs.entity.WeixinBbsPostEntity;
import weixin.bbs.entity.WeixinBbsPostImgEntity;
import weixin.bbs.entity.WeixinBbsTrendEntity;
import weixin.bbs.service.WeixinBbsPostServiceI;
import weixin.idea.photo.service.WeixinPhotoAlbumServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinBbsPostController"})
public class WeixinBbsPostController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinBbsPostController.class);
    @Autowired
    private WeixinPhotoAlbumServiceI weixinPhotoAlbumService;
    @Autowired
    private WeixinBbsPostServiceI weixinBbsPostService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinBbsPost"})
    public ModelAndView weixinBbsPost(HttpServletRequest request) {
        return new ModelAndView("weixin/bbs/weixinBbsPostList");
    }

    @RequestMapping(params={"uploadPhotoInit"})
    public ModelAndView uploadPhotoInit(HttpServletRequest request) {
        String uuid = request.getParameter("uuid");
        request.setAttribute("uuid", (Object)uuid);
        return new ModelAndView("weixin/bbs/uploadPostPhoto");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinBbsPostEntity weixinBbsPost, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinBbsPostEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinBbsPost, (Map)request.getParameterMap());
        this.weixinBbsPostService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"datagridwx"})
    public void datagridwx(WeixinBbsPostEntity weixinBbsPost, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String openid = request.getParameter("openid");
        CriteriaQuery cq = new CriteriaQuery(WeixinBbsPostEntity.class, dataGrid);
        cq.eq("status", (Object)"1");
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinBbsPost, (Map)request.getParameterMap());
        this.weixinBbsPostService.getDataGridReturn(cq, true);
        List postList = dataGrid.getResults();
        if (postList != null) {
            int i = 0;
            while (i < postList.size()) {
                WeixinBbsPostEntity pe = (WeixinBbsPostEntity)postList.get(i);
                List<WeixinBbsTrendEntity> postTrends = pe.getPostTrend();
                if (postTrends == null) break;
                ArrayList<WeixinBbsTrendEntity> trendList = new ArrayList<WeixinBbsTrendEntity>();
                int j = 0;
                while (j < postTrends.size()) {
                    if (postTrends.get(j).getCreateBy().equals(openid)) {
                        trendList.add(postTrends.get(j));
                        break;
                    }
                    ++j;
                }
                pe.setPostTrend(trendList);
                ++i;
            }
        }
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinBbsPostEntity weixinBbsPost, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinBbsPost = (WeixinBbsPostEntity)this.systemService.getEntity(WeixinBbsPostEntity.class, (Serializable)((Object)weixinBbsPost.getId()));
        this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u5220\u9664\u6210\u529f";
        this.weixinBbsPostService.delete(weixinBbsPost);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinBbsPostEntity weixinBbsPost, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String postId = null;
        if (StringUtil.isNotEmpty((Object)weixinBbsPost.getId())) {
            this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u66f4\u65b0\u6210\u529f";
            WeixinBbsPostEntity t = (WeixinBbsPostEntity)this.weixinBbsPostService.get(WeixinBbsPostEntity.class, (Serializable)((Object)weixinBbsPost.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinBbsPost, (Object)t);
                postId = weixinBbsPost.getId();
                this.weixinBbsPostService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u6dfb\u52a0\u6210\u529f";
            List bbs = this.weixinBbsPostService.findByProperty(WeixinBbsEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
            if (bbs == null || bbs.size() == 0) {
                this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u65b0\u589e\u5931\u8d25";
            } else {
                weixinBbsPost.setPostPerson(((WeixinBbsEntity)bbs.get(0)).getNickName());
                weixinBbsPost.setStatus("1");
                weixinBbsPost.setCommentCount(0);
                weixinBbsPost.setPraiseCount(0);
                postId = (String)((Object)this.weixinBbsPostService.save(weixinBbsPost));
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("postId", postId);
        j.setAttributes(attr);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinBbsPostEntity weixinBbsPost, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinBbsPost.getId())) {
            weixinBbsPost = (WeixinBbsPostEntity)this.weixinBbsPostService.getEntity(WeixinBbsPostEntity.class, (Serializable)((Object)weixinBbsPost.getId()));
            req.setAttribute("weixinBbsPostPage", (Object)weixinBbsPost);
        }
        return new ModelAndView("weixin/bbs/weixinBbsPost");
    }

    @RequestMapping(params={"uploadPostImg"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson uploadPostImg(HttpServletRequest request, HttpServletResponse response, WeixinBbsPostImgEntity postImg) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            postImg.setId(fileKey);
            postImg = (WeixinBbsPostImgEntity)this.systemService.getEntity(WeixinBbsPostImgEntity.class, (Serializable)((Object)fileKey));
        }
        String postId = request.getParameter("postId");
        WeixinBbsPostEntity post = (WeixinBbsPostEntity)this.weixinBbsPostService.get(WeixinBbsPostEntity.class, (Serializable)((Object)postId));
        postImg.setPost(post);
        UploadFile uploadFile = new UploadFile(request, (Object)postImg);
        uploadFile.setCusPath("files");
        uploadFile.setByteField(null);
        postImg = (WeixinBbsPostImgEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", postImg.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + postImg.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + postImg.getId());
        return j;
    }

    @RequestMapping(params={"delImg"})
    @ResponseBody
    public AjaxJson delImg(WeixinBbsPostImgEntity postImg, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        postImg = (WeixinBbsPostImgEntity)this.systemService.getEntity(WeixinBbsPostImgEntity.class, (Serializable)((Object)id));
        String postId = postImg.getPost().getId();
        this.weixinPhotoAlbumService.deleteFile(postImg);
        this.message = "\u56fe\u7247\u5220\u9664\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("postId", postId);
        j.setAttributes(attr);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goComment"})
    public ModelAndView goComment(WeixinBbsPostEntity bbsPost, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((Object)bbsPost.getId())) {
            bbsPost = (WeixinBbsPostEntity)this.weixinBbsPostService.getEntity(WeixinBbsPostEntity.class, (Serializable)((Object)bbsPost.getId()));
            request.setAttribute("bbsPost", (Object)bbsPost);
            request.setAttribute("id", (Object)bbsPost.getId());
        }
        return new ModelAndView("weixin/bbs/postComment");
    }

    @RequestMapping(params={"postComment"})
    @ResponseBody
    public AjaxJson postComment(WeixinBbsPostCommentEntity weixinBbsPostCommentEntity, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5e16\u5b50\u8bc4\u8bba\u6210\u529f";
        String postId = request.getParameter("postId");
        List bbs = this.weixinBbsPostService.findByProperty(WeixinBbsEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        weixinBbsPostCommentEntity.setCommentPerson(((WeixinBbsEntity)bbs.get(0)).getNickName());
        this.weixinBbsPostService.postComment(weixinBbsPostCommentEntity, postId);
        this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"datagridComment"})
    public void datagridComment(WeixinBbsPostCommentEntity weixinBbsPostCommentEntity, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinBbsPostCommentEntity.class, dataGrid);
        String postId = request.getParameter("postId");
        WeixinBbsPostEntity bbsPost = (WeixinBbsPostEntity)this.weixinBbsPostService.getEntity(WeixinBbsPostEntity.class, (Serializable)((Object)postId));
        cq.eq("post", (Object)bbsPost);
        cq.addOrder("createDate", SortDirection.desc);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinBbsPostCommentEntity, (Map)request.getParameterMap());
        this.weixinBbsPostService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"delComment"})
    @ResponseBody
    public AjaxJson delComment(WeixinBbsPostCommentEntity weixinBbsPostCommentEntity, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinBbsPostCommentEntity = (WeixinBbsPostCommentEntity)this.systemService.getEntity(WeixinBbsPostCommentEntity.class, (Serializable)((Object)weixinBbsPostCommentEntity.getId()));
        this.message = "\u8bc4\u8bba\u5220\u9664\u6210\u529f";
        this.weixinBbsPostService.delete(weixinBbsPostCommentEntity);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"postTop"})
    @ResponseBody
    public AjaxJson postTop(WeixinBbsPostEntity weixinBbsPostEntity, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinBbsPostEntity = (WeixinBbsPostEntity)this.weixinBbsPostService.getEntity(WeixinBbsPostEntity.class, (Serializable)((Object)weixinBbsPostEntity.getId()));
        this.message = "\u5e16\u5b50\u7f6e\u9876\u6210\u529f";
        this.weixinBbsPostService.postTop(weixinBbsPostEntity);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }
}

