/*
 * Decompiled with CFR 0.152.
 */
package weixin.bbs.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.bbs.entity.WeixinBbsEntity;
import weixin.bbs.entity.WeixinBbsImgEntity;
import weixin.bbs.service.WeixinBbsServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinBbsController"})
public class WeixinBbsController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinBbsController.class);
    @Autowired
    private WeixinBbsServiceI weixinBbsService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinBbs"})
    public ModelAndView weixinBbs(HttpServletRequest request) {
        return new ModelAndView("weixin/bbs/weixinBbsList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinBbsEntity weixinBbs, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinBbsEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinBbs, (Map)request.getParameterMap());
        this.weixinBbsService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinBbsEntity weixinCommunity, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinCommunity = (WeixinBbsEntity)this.systemService.getEntity(WeixinBbsEntity.class, (Serializable)((Object)weixinCommunity.getId()));
        this.message = "\u5fae\u793e\u533a\u5220\u9664\u6210\u529f";
        this.weixinBbsService.delete(weixinCommunity);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinBbsEntity weixinBbs, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String imgid = oConvertUtils.getString((String)request.getParameter("imgid"));
        WeixinBbsImgEntity bbsImg = null;
        if (StringUtil.isNotEmpty((Object)imgid)) {
            bbsImg = (WeixinBbsImgEntity)this.systemService.getEntity(WeixinBbsImgEntity.class, (Serializable)((Object)imgid));
        }
        if (StringUtil.isNotEmpty((Object)weixinBbs.getId())) {
            this.message = "\u5fae\u793e\u533a\u66f4\u65b0\u6210\u529f";
            WeixinBbsEntity t = (WeixinBbsEntity)this.weixinBbsService.get(WeixinBbsEntity.class, (Serializable)((Object)weixinBbs.getId()));
            try {
                t.setBbsImg(bbsImg);
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinBbs, (Object)t);
                this.weixinBbsService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u793e\u533a\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5fae\u793e\u533a\u6dfb\u52a0\u6210\u529f";
            String accountId = ResourceUtil.getShangJiaAccountId();
            weixinBbs.setAccountid(accountId);
            weixinBbs.setBbsImg(bbsImg);
            this.weixinBbsService.save(weixinBbs);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        bbsImg.setBbs(weixinBbs);
        this.systemService.saveOrUpdate((Object)bbsImg);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinBbsEntity weixinBbs, HttpServletRequest req) {
        String accountid = ResourceUtil.getShangJiaAccountId();
        weixinBbs = (WeixinBbsEntity)this.weixinBbsService.findUniqueByProperty(WeixinBbsEntity.class, "accountid", accountid);
        req.setAttribute("weixinBbsPage", (Object)weixinBbs);
        return new ModelAndView("weixin/bbs/weixinBbs");
    }

    @RequestMapping(params={"saveImg"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveImg(HttpServletRequest request, HttpServletResponse response, WeixinBbsImgEntity bbsImg) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String imgid = oConvertUtils.getString((String)request.getParameter("imgid"));
        if (StringUtil.isNotEmpty((Object)imgid)) {
            bbsImg.setId(imgid);
            bbsImg = (WeixinBbsImgEntity)this.systemService.getEntity(WeixinBbsImgEntity.class, (Serializable)((Object)imgid));
        }
        UploadFile uploadFile = new UploadFile(request, (Object)bbsImg);
        uploadFile.setCusPath("files");
        uploadFile.setByteField(null);
        bbsImg = (WeixinBbsImgEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", bbsImg.getId());
        attributes.put("realPath", bbsImg.getRealpath());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + bbsImg.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + bbsImg.getId());
        j.setMsg("\u8bba\u575b\u56fe\u6807\u6dfb\u52a0\u6210\u529f\uff01");
        j.setAttributes(attributes);
        return j;
    }
}

