/*
 * Decompiled with CFR 0.152.
 */
package weixin.bbs.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import weixin.bbs.bbsdata.impl.BbsAddPostDataCollect;
import weixin.bbs.bbsdata.impl.BbsIndexDataCollect;
import weixin.bbs.bbsdata.impl.BbsMyPostCollect;
import weixin.bbs.bbsdata.impl.BbsMyTrendCollect;
import weixin.bbs.bbsdata.impl.BbsPostCommentCollect;
import weixin.bbs.bbsdata.impl.BbsPostDataCollect;
import weixin.bbs.common.BbsConstant;
import weixin.bbs.common.BbsDataContent;
import weixin.bbs.entity.WeixinBbsEntity;
import weixin.bbs.entity.WeixinBbsPostCommentEntity;
import weixin.bbs.entity.WeixinBbsPostEntity;
import weixin.bbs.entity.WeixinBbsPostImgEntity;
import weixin.bbs.service.WeixinBbsPostServiceI;
import weixin.cms.entity.CmsArticleEntity;
import weixin.cms.entity.WeixinCmsStyleEntity;
import weixin.cms.service.CmsArticleServiceI;
import weixin.cms.service.WeixinCmsSiteServiceI;
import weixin.cms.service.WeixinCmsStyleServiceI;
import weixin.cms.util.CmsCollectExcutor;
import weixin.cms.util.CmsFreemarkerHelper;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.idea.photo.service.WeixinPhotoAlbumServiceI;

@Controller
@RequestMapping(value={"/bbsController"})
public class BbsController
extends BaseController
implements BbsConstant {
    @Autowired
    private CmsArticleServiceI cmsArticleService;
    @Autowired
    private WeixinCmsSiteServiceI weixinCmsSiteService;
    @Autowired
    private WeixinCmsStyleServiceI weixinCmsStyleService;
    @Autowired
    private WeixinBbsPostServiceI weixinBbsPostService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinPhotoAlbumServiceI weixinPhotoAlbumService;
    private String message;
    private static Map<String, Object> dataCollectContent = new HashMap<String, Object>();

    static {
        dataCollectContent.put("index", new BbsIndexDataCollect());
        dataCollectContent.put("post", new BbsPostDataCollect());
        dataCollectContent.put("addpost", new BbsAddPostDataCollect());
        dataCollectContent.put("addcomment", new BbsPostCommentCollect());
        dataCollectContent.put("mypost", new BbsMyPostCollect());
        dataCollectContent.put("mytrend", new BbsMyTrendCollect());
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private String getRootUrl(HttpServletRequest request, String page) {
        String rootUrl = null;
        rootUrl = request.getSession().getServletContext().getRealPath("/template/bbs");
        return rootUrl;
    }

    @RequestMapping(params={"goPage"})
    public void goPage(HttpServletRequest request, HttpServletResponse response, @RequestParam String page) {
        Map<String, String> params = this.paramsToMap(request);
        String accountid = request.getParameter("accountid");
        if (oConvertUtils.isNotEmpty((Object)accountid)) {
            WeixinAccountEntity weixinAccountEntity = (WeixinAccountEntity)this.systemService.findUniqueByProperty(WeixinAccountEntity.class, "id", (Object)accountid);
            request.getSession().setAttribute("WEIXIN_ACCOUNT", (Object)weixinAccountEntity);
            params.put("accountid", accountid);
        }
        ResourceUtil.initQianTaiRequestAccountId((HttpServletRequest)request);
        String rootUrl = "/template/bbs";
        String styleUrl = null;
        WeixinBbsEntity weixinBbsEntity = (WeixinBbsEntity)this.weixinCmsSiteService.findUniqueByProperty(WeixinBbsEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        WeixinCmsStyleEntity weixinCmsStyleEntity = null;
        String templateName = null;
        if (weixinBbsEntity != null) {
            if (weixinBbsEntity.getTemplateStyle() != null) {
                weixinCmsStyleEntity = (WeixinCmsStyleEntity)this.weixinCmsStyleService.get(WeixinCmsStyleEntity.class, (Serializable)((Object)weixinBbsEntity.getTemplateStyle()));
            }
            if (weixinCmsStyleEntity != null) {
                templateName = String.valueOf(ResourceUtil.getShangJiaAccountId()) + "/" + weixinCmsStyleEntity.getTemplateUrl();
                styleUrl = String.valueOf(rootUrl) + "/" + ResourceUtil.getShangJiaAccountId() + "/" + weixinCmsStyleEntity.getTemplateUrl() + "/html/";
            } else {
                templateName = "default";
                styleUrl = String.valueOf(rootUrl) + "/default/html/";
            }
            params.put("bbsId", weixinBbsEntity.getId());
        } else {
            templateName = "default";
            styleUrl = String.valueOf(rootUrl) + "/default/html/";
        }
        params.put("styleName", templateName);
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        if (CmsCollectExcutor.get("bbs", page) != null) {
            CmsCollectExcutor.collect("bbs", page, params);
        }
        String pageUrl = String.valueOf(styleUrl) + page + ".html";
        String html = cmsFreemarkerHelper.parseTemplate(pageUrl, BbsDataContent.loadContent());
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        PrintWriter writer = null;
        try {
            try {
                writer = response.getWriter();
                writer.println(html);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @RequestMapping(params={"getMenuList"})
    public void getMenuList(HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        Map<String, String> params = this.paramsToMap(request);
        List<CmsArticleEntity> list = this.cmsArticleService.listByMap(params, dataGrid.getPage(), dataGrid.getRows());
        int count = this.cmsArticleService.getCount(params);
        dataGrid.setTotal(count);
        dataGrid.setResults(list);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinBbsPostEntity weixinBbsPost, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String postId = null;
        String fileId = request.getParameter("fileId");
        if (StringUtil.isNotEmpty((Object)weixinBbsPost.getId())) {
            this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u66f4\u65b0\u6210\u529f";
            WeixinBbsPostEntity t = (WeixinBbsPostEntity)this.weixinBbsPostService.get(WeixinBbsPostEntity.class, (Serializable)((Object)weixinBbsPost.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinBbsPost, (Object)t);
                postId = weixinBbsPost.getId();
                this.weixinBbsPostService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u6dfb\u52a0\u6210\u529f";
            List bbs = this.weixinBbsPostService.findByProperty(WeixinBbsEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
            if (bbs == null || bbs.size() == 0) {
                this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u65b0\u589e\u5931\u8d25";
            } else {
                weixinBbsPost.setStatus("1");
                weixinBbsPost.setCommentCount(0);
                weixinBbsPost.setPraiseCount(0);
                postId = this.weixinBbsPostService.savePost(weixinBbsPost, fileId);
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
        }
        return j;
    }

    private Map<String, String> paramsToMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String paramName = (String)em.nextElement();
            String paramValue = request.getParameter(paramName);
            params.put(paramName, paramValue);
        }
        if (!params.containsKey("accountid")) {
            params.put("accountid", ResourceUtil.getShangJiaAccountId());
        }
        return params;
    }

    @RequestMapping(params={"addPostComment"})
    @ResponseBody
    public AjaxJson addPostComment(WeixinBbsPostCommentEntity postComment, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u793e\u533a\u5e16\u5b50\u6dfb\u52a0\u6210\u529f";
        String postId = request.getParameter("postId");
        this.weixinBbsPostService.postComment(postComment, postId);
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("postId", postId);
        j.setAttributes(attr);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"uploadPostImg"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson uploadPostImg(HttpServletRequest request, HttpServletResponse response, WeixinBbsPostImgEntity postImg) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            postImg.setId(fileKey);
            postImg = (WeixinBbsPostImgEntity)this.systemService.getEntity(WeixinBbsPostImgEntity.class, (Serializable)((Object)fileKey));
        }
        UploadFile uploadFile = new UploadFile(request, (Object)postImg);
        uploadFile.setCusPath("files");
        uploadFile.setByteField(null);
        postImg = (WeixinBbsPostImgEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", postImg.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + postImg.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + postImg.getId());
        attributes.put("realPath", postImg.getRealpath());
        attributes.put("fileId", postImg.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"delPhoto"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson delPhoto(HttpServletRequest request, HttpServletResponse response, WeixinBbsPostImgEntity postImg) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        postImg = (WeixinBbsPostImgEntity)this.systemService.getEntity(WeixinBbsPostImgEntity.class, (Serializable)((Object)id));
        this.weixinPhotoAlbumService.deleteFile(postImg);
        return j;
    }
}

