/*
 * Decompiled with CFR 0.152.
 */
package weixin.bbs.bbsdata.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import weixin.bbs.bbsdata.DataCollectI;
import weixin.bbs.common.BbsConstant;
import weixin.bbs.common.BbsDataContent;
import weixin.bbs.entity.WeixinBbsEntity;
import weixin.bbs.entity.WeixinBbsPostEntity;
import weixin.bbs.entity.WeixinBbsTrendEntity;
import weixin.bbs.service.WeixinBbsPostServiceI;
import weixin.bbs.service.WeixinBbsServiceI;

public class BbsIndexDataCollect
implements DataCollectI,
BbsConstant {
    @Override
    public void collect(Map<String, String> params) {
        WeixinBbsPostServiceI bbsPostService = (WeixinBbsPostServiceI)ApplicationContextUtil.getContext().getBean("weixinBbsPostService");
        WeixinBbsServiceI bbsService = (WeixinBbsServiceI)ApplicationContextUtil.getContext().getBean("weixinBbsService");
        CriteriaQuery cq = new CriteriaQuery(WeixinBbsPostEntity.class);
        cq.eq("status", (Object)"1");
        cq.addOrder("createDate", SortDirection.desc);
        List bbsPosts = bbsPostService.getListByCriteriaQuery(cq, false);
        BbsDataContent.put("postCount", bbsPosts == null ? 0 : bbsPosts.size());
        String bbsid = params.get("bbsId");
        WeixinBbsEntity weixinBbsEntity = new WeixinBbsEntity();
        if (StringUtil.isNotEmpty((Object)bbsid)) {
            weixinBbsEntity = (WeixinBbsEntity)bbsService.findUniqueByProperty(WeixinBbsEntity.class, "id", bbsid);
        }
        BbsDataContent.put("bbs", weixinBbsEntity);
        String openid = params.get("openid");
        String accountid = params.get("accountid");
        BbsDataContent.put("accountid", accountid);
        if (bbsPosts != null) {
            int i = 0;
            while (i < bbsPosts.size()) {
                WeixinBbsPostEntity pe = (WeixinBbsPostEntity)bbsPosts.get(i);
                List<WeixinBbsTrendEntity> postTrends = pe.getPostTrend();
                if (postTrends == null) break;
                ArrayList<WeixinBbsTrendEntity> trendList = new ArrayList<WeixinBbsTrendEntity>();
                int j = 0;
                while (j < postTrends.size()) {
                    if (postTrends.get(j).getCreateBy().equals(openid)) {
                        trendList.add(postTrends.get(j));
                        break;
                    }
                    ++j;
                }
                pe.setPostTrend(trendList);
                ++i;
            }
        }
        BbsDataContent.put("postList", bbsPosts);
        BbsDataContent.put("openid", openid);
        String res = "template/bbs/" + params.get("styleName");
        BbsDataContent.put("base", res);
    }
}

