/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j.model;

import java.util.ArrayList;
import java.util.List;
import weibo.weibo4j.http.Response;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.model.WeiboResponse;
import weibo.weibo4j.org.json.JSONArray;
import weibo.weibo4j.org.json.JSONException;
import weibo.weibo4j.org.json.JSONObject;

public class UserTrend
extends WeiboResponse {
    private String num;
    private String hotword = null;
    private String trendId = null;
    private static final long serialVersionUID = 1925956704460743946L;

    public UserTrend() {
    }

    public UserTrend(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.num = json.getString("num");
            this.hotword = json.getString("hotword");
            this.trendId = json.getString("trend_id");
            if (json.getString("topicid") != null) {
                this.trendId = json.getString("topicid");
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public UserTrend(JSONObject json) throws WeiboException {
        try {
            this.num = json.getString("num");
            this.hotword = json.getString("hotword");
            this.trendId = json.getString("trend_id");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    public static List<UserTrend> constructTrendList(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<UserTrend> trends = new ArrayList<UserTrend>(size);
            int i = 0;
            while (i < size) {
                trends.add(new UserTrend(list.getJSONObject(i)));
                ++i;
            }
            return trends;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public String getNum() {
        return this.num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getHotword() {
        return this.hotword;
    }

    public void setHotword(String hotword) {
        this.hotword = hotword;
    }

    public String gettrendId() {
        return this.trendId;
    }

    public void settrendId(String trendId) {
        this.trendId = trendId;
    }

    public String toString() {
        return "Trend [num=" + this.num + ", hotword=" + this.hotword + ", trendId=" + this.trendId + "]";
    }
}

