/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo.weibo4j.http.Response;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.model.WeiboResponse;
import weibo.weibo4j.org.json.JSONArray;
import weibo.weibo4j.org.json.JSONException;
import weibo.weibo4j.org.json.JSONObject;

public class Places
extends WeiboResponse {
    private static final long serialVersionUID = -1423136187811594673L;
    private String poiid;
    private String title;
    private String address;
    private double lon;
    private double lat;
    private String category;
    private String city;
    private String province;
    private String country;
    private String url;
    private String phone;
    private String postcode;
    private long weiboId;
    private String categorys;
    private String categoryName;
    private String icon;
    private long checkinNum;
    private long checkinUserNum;
    private Date checkinTime;
    private long tipNum;
    private long photoNum;
    private long todoNum;
    private long distance;
    private static long totalNumber;

    public Places(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.poiid = json.getString("poiid");
            this.title = json.getString("title");
            this.address = json.getString("address");
            this.lon = json.getDouble("lon");
            this.lat = json.getDouble("lat");
            this.category = json.getString("category");
            this.city = json.getString("city");
            this.province = json.getString("privince");
            this.country = json.getString("country");
            this.url = json.getString("url");
            this.phone = json.getString("url");
            this.postcode = json.getString("postcode");
            this.weiboId = json.getLong("weibo_id");
            this.categorys = json.getString("categorys");
            this.categoryName = json.getString("category_name");
            this.icon = json.getString("icon");
            this.checkinUserNum = json.getLong("checkin_user_num");
            this.checkinTime = Places.parseDate(json.getString("checkin_time"), "yyyy-MM-dd hh:mm:ss");
            this.checkinNum = json.getLong("checkin_num");
            this.tipNum = json.getLong("tip_num");
            this.photoNum = json.getLong("photo_num");
            this.todoNum = json.getLong("todo_num");
            this.distance = json.getLong("distance");
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public Places(JSONObject json) throws WeiboException {
        try {
            this.poiid = json.getString("poiid");
            this.title = json.getString("title");
            this.address = json.getString("address");
            this.lon = json.getDouble("lon");
            this.lat = json.getDouble("lat");
            this.category = json.getString("category");
            this.city = json.getString("city");
            this.province = json.getString("privince");
            this.country = json.getString("country");
            this.url = json.getString("url");
            this.phone = json.getString("url");
            this.postcode = json.getString("postcode");
            this.weiboId = json.getLong("weibo_id");
            this.categorys = json.getString("categorys");
            this.categoryName = json.getString("category_name");
            this.icon = json.getString("icon");
            this.checkinUserNum = json.getLong("checkin_user_num");
            this.checkinTime = Places.parseDate(json.getString("checkin_time"), "yyyy-MM-dd hh:mm:ss");
            this.checkinNum = json.getLong("checkin_num");
            this.tipNum = json.getLong("tip_num");
            this.photoNum = json.getLong("photo_num");
            this.todoNum = json.getLong("todo_num");
            this.distance = json.getLong("distance");
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public static List<Places> constructPlace(Response res) throws WeiboException {
        try {
            JSONObject jsonObj = res.asJSONObject();
            totalNumber = jsonObj.getLong("total_number");
            JSONArray json = jsonObj.getJSONArray("pois");
            int size = json.length();
            ArrayList<Places> list = new ArrayList<Places>(size);
            int i = 0;
            while (i < size) {
                list.add(new Places(json.getJSONObject(i)));
                ++i;
            }
            return list;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public String getPoiid() {
        return this.poiid;
    }

    public void setPoiid(String poiid) {
        this.poiid = poiid;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPostcode() {
        return this.postcode;
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public long getWeiboId() {
        return this.weiboId;
    }

    public void setWeiboId(long weiboId) {
        this.weiboId = weiboId;
    }

    public String getCategorys() {
        return this.categorys;
    }

    public void setCategorys(String categorys) {
        this.categorys = categorys;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public long getCheckinUserNum() {
        return this.checkinUserNum;
    }

    public void setCheckinUserNum(long checkinUserNum) {
        this.checkinUserNum = checkinUserNum;
    }

    public Date getCheckinTime() {
        return this.checkinTime;
    }

    public void setCheckinTime(Date checkinTime) {
        this.checkinTime = checkinTime;
    }

    public long getCheckinNum() {
        return this.checkinNum;
    }

    public void setCheckinNum(long checkinNum) {
        this.checkinNum = checkinNum;
    }

    public long getTipNum() {
        return this.tipNum;
    }

    public void setTipNum(long tipNum) {
        this.tipNum = tipNum;
    }

    public long getPhotoNum() {
        return this.photoNum;
    }

    public void setPhotoNum(long photoNum) {
        this.photoNum = photoNum;
    }

    public long getTodoNum() {
        return this.todoNum;
    }

    public void setTodoNum(long todoNum) {
        this.todoNum = todoNum;
    }

    public long getDistance() {
        return this.distance;
    }

    public void setDistance(long distance) {
        this.distance = distance;
    }

    public String toString() {
        return "Place [poiid=" + this.poiid + ",title=" + this.title + ",address=" + this.address + ",lon=" + this.lon + ",lat=" + this.lat + ",category=" + this.category + ",city=" + this.city + ",province=" + this.province + ",country=" + this.country + ",url=" + this.url + ",phone=" + this.phone + ",postcode=" + this.postcode + ",weiboId=" + this.weiboId + ",categorys=" + this.categorys + ",categoryName=" + this.categoryName + ",icon=" + this.icon + ",checkinUserNum=" + this.checkinUserNum + ",checkinTime=" + this.checkinTime + ",tip_num=" + this.tipNum + ",photo_num=" + this.photoNum + ",todo_num=" + this.todoNum + ",distance=" + this.distance + ",total_number=" + totalNumber + "]";
    }
}

