/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j.model;

import java.util.ArrayList;
import java.util.List;
import weibo.weibo4j.http.Response;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.model.WeiboResponse;
import weibo.weibo4j.org.json.JSONArray;
import weibo.weibo4j.org.json.JSONException;
import weibo.weibo4j.org.json.JSONObject;

public class FavoritesTag
extends WeiboResponse {
    private static final long serialVersionUID = 2177657076940291492L;
    private String id;
    private String tag;
    private int count;

    public FavoritesTag(JSONObject json) throws WeiboException, JSONException {
        this.id = json.getString("id");
        this.tag = json.getString("tag");
        if (!json.isNull("count")) {
            this.count = json.getInt("count");
        }
    }

    public static List<FavoritesTag> constructTags(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ArrayList<FavoritesTag> tags = new ArrayList<FavoritesTag>(size);
            int i = 0;
            while (i < size) {
                tags.add(new FavoritesTag(list.getJSONObject(i)));
                ++i;
            }
            return tags;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public static List<FavoritesTag> constructTag(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONObject().getJSONArray("tags");
            int size = list.length();
            ArrayList<FavoritesTag> tags = new ArrayList<FavoritesTag>(size);
            int i = 0;
            while (i < size) {
                tags.add(new FavoritesTag(list.getJSONObject(i)));
                ++i;
            }
            return tags;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
        catch (WeiboException te) {
            throw te;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FavoritesTag other = (FavoritesTag)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String toString() {
        return "FavoritesTag [id=" + this.id + ", tag=" + this.tag + ", count=" + this.count + "]";
    }
}

