/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import weibo.weibo4j.http.Response;
import weibo.weibo4j.model.FavoritesTag;
import weibo.weibo4j.model.Status;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.model.WeiboResponse;
import weibo.weibo4j.org.json.JSONArray;
import weibo.weibo4j.org.json.JSONException;
import weibo.weibo4j.org.json.JSONObject;

public class Favorites
extends WeiboResponse {
    private static final long serialVersionUID = 3355536191107298448L;
    private Date favoritedTime;
    private Status status;
    private List<FavoritesTag> tags;
    private static int totalNumber;

    public Favorites(Response res) throws WeiboException {
        super(res);
        JSONObject json = null;
        try {
            json = res.asJSONObject();
            this.favoritedTime = Favorites.parseDate(json.getString("favorited_time"), "EEE MMM dd HH:mm:ss z yyyy");
            if (!json.isNull("status")) {
                this.status = new Status(json.getJSONObject("status"));
            }
            if (!json.isNull("tags")) {
                JSONArray list = json.getJSONArray("tags");
                int size = list.length();
                this.tags = new ArrayList<FavoritesTag>(size);
                int i = 0;
                while (i < size) {
                    this.tags.add(new FavoritesTag(list.getJSONObject(i)));
                    ++i;
                }
            }
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    Favorites(JSONObject json) throws WeiboException, JSONException {
        this.favoritedTime = Favorites.parseDate(json.getString("favorited_time"), "EEE MMM dd HH:mm:ss z yyyy");
        if (!json.isNull("status")) {
            this.status = new Status(json.getJSONObject("status"));
        }
        if (!json.isNull("tags")) {
            JSONArray list = json.getJSONArray("tags");
            int size = list.length();
            this.tags = new ArrayList<FavoritesTag>(size);
            int i = 0;
            while (i < size) {
                this.tags.add(new FavoritesTag(list.getJSONObject(i)));
                ++i;
            }
        }
    }

    public static List<Favorites> constructFavorites(Response res) throws WeiboException {
        try {
            JSONArray list = res.asJSONObject().getJSONArray("favorites");
            int size = list.length();
            ArrayList<Favorites> favorites = new ArrayList<Favorites>(size);
            int i = 0;
            while (i < size) {
                favorites.add(new Favorites(list.getJSONObject(i)));
                ++i;
            }
            totalNumber = res.asJSONObject().getInt("total_number");
            return favorites;
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<FavoritesTag> getTags() {
        return this.tags;
    }

    public void setTags(List<FavoritesTag> tags) {
        this.tags = tags;
    }

    public Date getFavoritedTime() {
        return this.favoritedTime;
    }

    public void setFavoritedTime(Date favoritedTime) {
        this.favoritedTime = favoritedTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.favoritedTime == null ? 0 : this.favoritedTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Favorites other = (Favorites)obj;
        return !(this.favoritedTime == null ? other.favoritedTime != null : !this.favoritedTime.equals(other.favoritedTime));
    }

    public String toString() {
        return "Favorites [favorited_time=" + this.favoritedTime + ", status=" + this.status.toString() + ", FavoritesTag=" + (this.tags == null ? "null" : this.tags.toString()) + ", total_number = " + totalNumber + "]";
    }
}

