/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j.http;

import java.io.Serializable;
import weibo.weibo4j.http.Response;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.model.WeiboResponse;
import weibo.weibo4j.org.json.JSONException;
import weibo.weibo4j.org.json.JSONObject;

public class AccessToken
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 6986530164134648944L;
    private String accessToken;
    private String expireIn;
    private String refreshToken;
    private String uid;

    public AccessToken(Response res) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.accessToken = json.getString("access_token");
            this.expireIn = json.getString("expires_in");
            this.refreshToken = json.getString("refresh_token");
            this.uid = json.getString("uid");
        }
        catch (JSONException je) {
            throw new WeiboException(String.valueOf(je.getMessage()) + ":" + json.toString(), je);
        }
    }

    AccessToken(String res) throws WeiboException, JSONException {
        JSONObject json = new JSONObject(res);
        this.accessToken = json.getString("access_token");
        this.expireIn = json.getString("expires_in");
        this.refreshToken = json.getString("refresh_token");
        this.uid = json.getString("uid");
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getExpireIn() {
        return this.expireIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        result = 31 * result + (this.expireIn == null ? 0 : this.expireIn.hashCode());
        result = 31 * result + (this.refreshToken == null ? 0 : this.refreshToken.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessToken other = (AccessToken)obj;
        if (this.accessToken == null ? other.accessToken != null : !this.accessToken.equals(other.accessToken)) {
            return false;
        }
        if (this.expireIn == null ? other.expireIn != null : !this.expireIn.equals(other.expireIn)) {
            return false;
        }
        return !(this.refreshToken == null ? other.refreshToken != null : !this.refreshToken.equals(other.refreshToken));
    }

    public String toString() {
        return "AccessToken [accessToken=" + this.accessToken + ", expireIn=" + this.expireIn + ", refreshToken=" + this.refreshToken + ",uid=" + this.uid + "]";
    }
}

