/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j;

import java.util.List;
import weibo.weibo4j.Weibo;
import weibo.weibo4j.model.Paging;
import weibo.weibo4j.model.PostParameter;
import weibo.weibo4j.model.Trends;
import weibo.weibo4j.model.UserTrend;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.org.json.JSONObject;
import weibo.weibo4j.util.WeiboConfig;

public class Trend
extends Weibo {
    private static final long serialVersionUID = 903299515334415487L;

    public Trend(String access_token) {
        this.access_token = access_token;
    }

    public List<UserTrend> getTrends(String uid) throws WeiboException {
        return UserTrend.constructTrendList(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public List<UserTrend> getTrends(String uid, Paging page) throws WeiboException {
        return UserTrend.constructTrendList(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends.json", new PostParameter[]{new PostParameter("uid", uid)}, page, this.access_token));
    }

    public JSONObject isFollow(String trend_name) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/is_follow.json", new PostParameter[]{new PostParameter("trend_name", trend_name)}, this.access_token).asJSONObject();
    }

    public List<Trends> getTrendsHourly() throws WeiboException {
        return Trends.constructTrendsList(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/hourly.json", this.access_token));
    }

    public List<Trends> getTrendsHourly(Integer base_app) throws WeiboException {
        return Trends.constructTrendsList(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/hourly.json", new PostParameter[]{new PostParameter("base_app", base_app.toString())}, this.access_token));
    }

    public List<Trends> getTrendsDaily() throws WeiboException {
        return Trends.constructTrendsList(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/daily.json", this.access_token));
    }

    public List<Trends> getTrendsDaily(Integer base_app) throws WeiboException {
        return Trends.constructTrendsList(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/daily.json", new PostParameter[]{new PostParameter("base_app", base_app.toString())}, this.access_token));
    }

    public List<Trends> getTrendsWeekly() throws WeiboException {
        return Trends.constructTrendsList(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/weekly.json", this.access_token));
    }

    public List<Trends> getTrendsWeekly(Integer base_app) throws WeiboException {
        return Trends.constructTrendsList(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/weekly.json", new PostParameter[]{new PostParameter("base_app", base_app.toString())}, this.access_token));
    }

    public UserTrend trendsFollow(String trend_name) throws WeiboException {
        return new UserTrend(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/follow.json", new PostParameter[]{new PostParameter("trend_name", trend_name)}, this.access_token));
    }

    public JSONObject trendsDestroy(Integer trend_id) throws WeiboException {
        return client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "trends/destroy.json", new PostParameter[]{new PostParameter("trend_id", trend_id.toString())}, this.access_token).asJSONObject();
    }
}

