/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j;

import java.util.List;
import weibo.weibo4j.Weibo;
import weibo.weibo4j.model.Paging;
import weibo.weibo4j.model.PostParameter;
import weibo.weibo4j.model.Tag;
import weibo.weibo4j.model.TagWapper;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.org.json.JSONArray;
import weibo.weibo4j.org.json.JSONObject;
import weibo.weibo4j.util.WeiboConfig;

public class Tags
extends Weibo {
    private static final long serialVersionUID = 7047254100483792467L;

    public Tags(String access_token) {
        this.access_token = access_token;
    }

    public List<Tag> getTags(String uid) throws WeiboException {
        return Tag.constructTags(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public List<Tag> getTags(String uid, int count, Paging page) throws WeiboException {
        return Tag.constructTags(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count)}, page, this.access_token));
    }

    public TagWapper getTagsBatch(String uids) throws WeiboException {
        return Tag.constructTagWapper(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/tags_batch.json", new PostParameter[]{new PostParameter("uids", uids)}, this.access_token));
    }

    public List<Tag> getTagsSuggestions() throws WeiboException {
        return Tag.constructTags(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/suggestions.json", this.access_token));
    }

    public List<Tag> getTagsSuggestions(int count) throws WeiboException {
        return Tag.constructTags(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/suggestions.json", new PostParameter[]{new PostParameter("count", count)}, this.access_token));
    }

    public JSONArray createTags(String tags) throws WeiboException {
        return client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/create.json", new PostParameter[]{new PostParameter("tags", tags)}, this.access_token).asJSONArray();
    }

    public JSONObject destoryTag(Integer tag_id) throws WeiboException {
        return client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/destroy.json", new PostParameter[]{new PostParameter("tag_id", tag_id.toString())}, this.access_token).asJSONObject();
    }

    public List<Tag> destroyTagsBatch(String ids) throws WeiboException {
        return Tag.constructTags(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "tags/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, this.access_token));
    }
}

