/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j;

import weibo.weibo4j.Weibo;
import weibo.weibo4j.model.Paging;
import weibo.weibo4j.model.PostParameter;
import weibo.weibo4j.model.Status;
import weibo.weibo4j.model.StatusWapper;
import weibo.weibo4j.model.User;
import weibo.weibo4j.model.UserWapper;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.org.json.JSONArray;
import weibo.weibo4j.org.json.JSONObject;
import weibo.weibo4j.util.WeiboConfig;

public class Suggestion
extends Weibo {
    private static final long serialVersionUID = 1861364044145921824L;

    public Suggestion(String access_token) {
        this.access_token = access_token;
    }

    public JSONArray suggestionsUsersHot() throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/users/hot.json", this.access_token).asJSONArray();
    }

    public JSONArray suggestionsUsersHot(String category) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/users/hot.json", new PostParameter[]{new PostParameter("category", category)}, this.access_token).asJSONArray();
    }

    public JSONArray suggestionsUsersMayInterested() throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/users/may_interested.json", this.access_token).asJSONArray();
    }

    public JSONArray suggestionsUsersMayInterested(int count, int page) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/users/may_interested.json", new PostParameter[]{new PostParameter("count", count), new PostParameter("page", page)}, this.access_token).asJSONArray();
    }

    public UserWapper suggestionsUsersByStatus(String content) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/users/by_status.json", new PostParameter[]{new PostParameter("content", content)}, this.access_token));
    }

    public UserWapper suggestionsUsersByStatus(String content, int num) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/users/by_status.json", new PostParameter[]{new PostParameter("content", content), new PostParameter("num", num)}, this.access_token));
    }

    public StatusWapper suggestionsStatusesReorder(int section) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/statuses/reorder.json", new PostParameter[]{new PostParameter("section", section)}, this.access_token));
    }

    public StatusWapper suggestionsStatusesReorder(int section, int count, Paging page) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/statuses/reorder.json", new PostParameter[]{new PostParameter("section", section), new PostParameter("count", count)}, page, this.access_token));
    }

    public JSONObject suggestionStatusesReorderIds(int section) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/statuses/reorder/ids.json", new PostParameter[]{new PostParameter("section", section)}, this.access_token).asJSONObject();
    }

    public JSONObject suggestionStatusesReorderIds(int section, int count, Paging page) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/statuses/reorder/ids.json", new PostParameter[]{new PostParameter("section", section), new PostParameter("count", count)}, page, this.access_token).asJSONObject();
    }

    public JSONArray suggestionsFavoritesHot() throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/favorites/hot.json", this.access_token).asJSONArray();
    }

    public JSONArray suggestionsFavoritesHot(int page, int count) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/favorites/hot.json", new PostParameter[]{new PostParameter("page", page), new PostParameter("count", count)}, this.access_token).asJSONArray();
    }

    public User suggestionsUsersNotInterested(String uid) throws WeiboException {
        return new User(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "suggestions/users/not_interested.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token).asJSONObject());
    }
}

