/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j;

import java.util.List;
import java.util.Map;
import weibo.weibo4j.Weibo;
import weibo.weibo4j.http.ImageItem;
import weibo.weibo4j.model.Places;
import weibo.weibo4j.model.PoisitionCategory;
import weibo.weibo4j.model.PostParameter;
import weibo.weibo4j.model.Status;
import weibo.weibo4j.model.StatusWapper;
import weibo.weibo4j.model.User;
import weibo.weibo4j.model.UserWapper;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.org.json.JSONObject;
import weibo.weibo4j.util.ArrayUtils;
import weibo.weibo4j.util.WeiboConfig;

public class Place
extends Weibo {
    private static final long serialVersionUID = 7603310952641351531L;

    public Place(String access_token) {
        this.access_token = access_token;
    }

    public StatusWapper friendsTimeLine() throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/friends_timeline.json", this.access_token));
    }

    public StatusWapper friendsTimeLine(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/friends_timeline.json", parList, this.access_token));
    }

    public StatusWapper userTimeLine(String uid) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/user_timeline.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public StatusWapper userTimeLine(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/user_timeline.json", parList, this.access_token));
    }

    public StatusWapper poisTimeLine(String poiid) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/poi_timeline.json", new PostParameter[]{new PostParameter("poiid", poiid)}, this.access_token));
    }

    public StatusWapper poisTimeLine(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/poi_timeline.json", parList, this.access_token));
    }

    public StatusWapper nearbyTimeLine(String lat, String lon) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/nearby_timeline.json", new PostParameter[]{new PostParameter("lat", lat), new PostParameter("long", lon)}, this.access_token));
    }

    public StatusWapper nearbyTimeLine(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/nearby_timeline.json", parList, this.access_token));
    }

    public Status statusesShow(String id) throws WeiboException {
        return new Status(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/statuses/show.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public JSONObject userInfoInLBS(String uid) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/users/show.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token).asJSONObject();
    }

    public JSONObject userInfoInLBS(String uid, int base_app) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/users/show.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("base_app", base_app)}, this.access_token).asJSONObject();
    }

    public List<Places> checkinsList(String uid) throws WeiboException {
        return Places.constructPlace(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/users/checkins.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public List<Places> checkinsList(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Places.constructPlace(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/users/checkins.json", parList, this.access_token));
    }

    public StatusWapper userPhotoList(String uid) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/users/photos.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public StatusWapper userPhotoList(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/users/photos.json", parList, this.access_token));
    }

    public JSONObject tipsList(String uid) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/users/tips.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token).asJSONObject();
    }

    public Places poisShow(String poiid) throws WeiboException {
        return new Places(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/show.json", new PostParameter[]{new PostParameter("poiid", poiid)}, this.access_token));
    }

    public List<Places> poisShow(String poiid, int base_app) throws WeiboException {
        return Places.constructPlace(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/show.json", new PostParameter[]{new PostParameter("poiid", poiid), new PostParameter("base_app", base_app)}, this.access_token));
    }

    public UserWapper poisUsersList(String poiid) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/users.json", new PostParameter[]{new PostParameter("poiid", poiid)}, this.access_token));
    }

    public UserWapper poisUsersList(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/users.json", parList, this.access_token));
    }

    public User poisTipsList(String poiid) throws WeiboException {
        return new User(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/tips.json", new PostParameter[]{new PostParameter("poiid", poiid)}, this.access_token).asJSONObject());
    }

    public StatusWapper poisPhotoList(String poiid) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/photos.json", new PostParameter[]{new PostParameter("poiid", poiid)}, this.access_token));
    }

    public StatusWapper poisPhotoList(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/photos.json", parList, this.access_token));
    }

    public List<Places> poisSearch(String keyword) throws WeiboException {
        return Places.constructPlace(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/search.json", new PostParameter[]{new PostParameter("keyword", keyword)}, this.access_token));
    }

    public List<Places> poisSearch(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Places.constructPlace(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/search.json", parList, this.access_token));
    }

    public List<PoisitionCategory> poisCategory() throws WeiboException {
        return PoisitionCategory.constructPoisCategory(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/category.json", this.access_token));
    }

    public List<PoisitionCategory> poisCategory(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return PoisitionCategory.constructPoisCategory(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/category.json", parList, this.access_token));
    }

    public List<Places> nearbyPois(String lat, String lon) throws WeiboException {
        return Places.constructPlace(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/nearby/pois.json", new PostParameter[]{new PostParameter("lat", lat), new PostParameter("long", lon)}, this.access_token));
    }

    public List<Places> nearbyPois(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Places.constructPlace(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/nearby/pois.json", parList, this.access_token));
    }

    public UserWapper nearbyUsers(String lat, String lon) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/nearby/users.json", new PostParameter[]{new PostParameter("lat", lat), new PostParameter("long", lon)}, this.access_token));
    }

    public UserWapper nearbyUsers(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/nearby/users.json", parList, this.access_token));
    }

    public StatusWapper nearbyPhoto(String lat, String lon) throws WeiboException {
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/nearby/photos.json", new PostParameter[]{new PostParameter("lat", lat), new PostParameter("long", lon)}, this.access_token));
    }

    public StatusWapper nearbyPhoto(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Status.constructWapperStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/nearby/photos.json", parList, this.access_token));
    }

    public Status addCheckin(String poiid, String status) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/add_checkin.json", new PostParameter[]{new PostParameter("poiid", poiid), new PostParameter("status", status)}, this.access_token));
    }

    public Status addCheckin(String poiid, String status, ImageItem item) throws WeiboException {
        return new Status(client.multPartURL(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/add_checkin.json", new PostParameter[]{new PostParameter("poiid", poiid), new PostParameter("status", status)}, item, this.access_token));
    }

    public Status addCheckin(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/add_checkin.json", parList, this.access_token));
    }

    public Status addPhoto(String poiid, String status) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/add_photo.json", new PostParameter[]{new PostParameter("poiid", poiid), new PostParameter("status", status)}, this.access_token));
    }

    public Status addPhoto(String poiid, String status, ImageItem item) throws WeiboException {
        return new Status(client.multPartURL(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/add_checkin.json", new PostParameter[]{new PostParameter("poiid", poiid), new PostParameter("status", status)}, item, this.access_token));
    }

    public Status addPhoto(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/add_checkin.json", parList, this.access_token));
    }

    public Status addTip(String poiid, String status) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/add_tip.json", new PostParameter[]{new PostParameter("poiid", poiid), new PostParameter("status", status)}, this.access_token));
    }

    public Status addTip(String poiid, String status, String pub) throws WeiboException {
        return new Status(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "place/pois/add_tip.json", new PostParameter[]{new PostParameter("poiid", poiid), new PostParameter("status", status), new PostParameter("pub", pub)}, this.access_token));
    }
}

