/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j;

import java.util.Map;
import weibo.weibo4j.Weibo;
import weibo.weibo4j.model.Paging;
import weibo.weibo4j.model.PostParameter;
import weibo.weibo4j.model.User;
import weibo.weibo4j.model.UserWapper;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.org.json.JSONArray;
import weibo.weibo4j.org.json.JSONObject;
import weibo.weibo4j.util.ArrayUtils;
import weibo.weibo4j.util.WeiboConfig;

public class Friendships
extends Weibo {
    private static final long serialVersionUID = 3603512821159421447L;

    public Friendships(String access_token) {
        this.access_token = access_token;
    }

    public UserWapper getFriendsByID(String id) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends.json", new PostParameter[]{new PostParameter("uid", id)}, this.access_token));
    }

    public UserWapper getFriendsByScreenName(String screen_name) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}, this.access_token));
    }

    public UserWapper getFriends(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends.json", parList, this.access_token));
    }

    public UserWapper getFriendsInCommon(String uid) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/in_common.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public UserWapper getFriendsInCommon(String uid, String suid, Paging page) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/in_common.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("suid", suid)}, page, this.access_token));
    }

    public UserWapper getFriendsInCommon(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/in_common.json", parList, this.access_token));
    }

    public UserWapper getFriendsBilateral(String uid) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public UserWapper getFriendsBilateral(String uid, Integer sort, Paging page) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("sort", sort.toString())}, page, this.access_token));
    }

    public UserWapper getFriendsBilateral(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral.json", parList, this.access_token));
    }

    public String[] getFriendsBilateralIds(String uid) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral/ids.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public String[] getFriendsBilateralIds(String uid, Integer sort, Paging page) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral/ids.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("sort", sort.toString())}, page, this.access_token));
    }

    public String[] getFriendsBilateralIds(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/bilateral/ids.json", parList, this.access_token));
    }

    public String[] getFriendsIdsByUid(String uid) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public String[] getFriendsIdsByName(String screen_name) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}, this.access_token));
    }

    public String[] getFriendsIdsByUid(String uid, Integer count, Integer cursor) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}, this.access_token));
    }

    public String[] getFriendsIdsByName(String screen_name, Integer count, Integer cursor) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}, this.access_token));
    }

    public String[] getFriendsIds(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/ids.json", parList, this.access_token));
    }

    public JSONArray getRemark(String uids) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends/remark_batch.json", new PostParameter[]{new PostParameter("uids", uids)}, this.access_token).asJSONArray();
    }

    public UserWapper getFollowersByName(String screen_name) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}, this.access_token));
    }

    public UserWapper getFollowersByName(String screen_name, Integer count, Integer cursor) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("screen_name", screen_name), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}, this.access_token));
    }

    public UserWapper getFollowersById(String uid) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public UserWapper getFollowersById(String uid, Integer count, Integer cursor) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}, this.access_token));
    }

    public UserWapper getFollowers(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers.json", parList, this.access_token));
    }

    public String[] getFollowersIdsById(String uid) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public String[] getFollowersIdsById(String uid, Integer count, Integer cursor) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}, this.access_token));
    }

    public String[] getFollowersIdsByName(String screen_name) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}, this.access_token));
    }

    public String[] getFollowersIdsByName(String screen_name, Integer count, Integer cursor) throws WeiboException {
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", new PostParameter[]{new PostParameter("screen_name", screen_name), new PostParameter("count", count.toString()), new PostParameter("cursor", cursor.toString())}, this.access_token));
    }

    public String[] getFollowersIdsByName(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/ids.json", parList, this.access_token));
    }

    public UserWapper getFollowersActive(String uid) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/active.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public UserWapper getFollowersActive(String uid, Integer count) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/followers/active.json", new PostParameter[]{new PostParameter("uid", uid), new PostParameter("count", count.toString())}, this.access_token));
    }

    public UserWapper getFriendsChainFollowers(String uid) throws WeiboException {
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends_chain/followers.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token));
    }

    public UserWapper getFriendsChainFollowers(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return User.constructWapperUsers(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/friends_chain/followers.json", parList, this.access_token));
    }

    public JSONObject getFriendshipsById(long source, long target) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/show.json", new PostParameter[]{new PostParameter("source_id", source), new PostParameter("target_id", target)}, this.access_token).asJSONObject();
    }

    public JSONObject getFriendshipsByName(String source, String target) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/show.json", new PostParameter[]{new PostParameter("source_screen_name", source), new PostParameter("target_screen_name", target)}, this.access_token).asJSONObject();
    }

    public JSONObject getFriendships(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/show.json", parList, this.access_token).asJSONObject();
    }

    public User createFriendshipsById(String uid) throws WeiboException {
        return new User(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/create.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token).asJSONObject());
    }

    public User createFriendshipsByName(String screen_name) throws WeiboException {
        return new User(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/create.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}, this.access_token).asJSONObject());
    }

    public User createFriendships(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new User(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/create.json", parList, this.access_token).asJSONObject());
    }

    public User destroyFriendshipsById(String uid) throws WeiboException {
        return new User(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/destroy.json", new PostParameter[]{new PostParameter("uid", uid)}, this.access_token).asJSONObject());
    }

    public User destroyFriendshipsByName(String screen_name) throws WeiboException {
        return new User(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "friendships/destroy.json", new PostParameter[]{new PostParameter("screen_name", screen_name)}, this.access_token).asJSONObject());
    }
}

