/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j;

import java.util.List;
import java.util.Map;
import weibo.weibo4j.Weibo;
import weibo.weibo4j.model.Favorites;
import weibo.weibo4j.model.FavoritesIds;
import weibo.weibo4j.model.FavoritesTag;
import weibo.weibo4j.model.Paging;
import weibo.weibo4j.model.PostParameter;
import weibo.weibo4j.model.Tag;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.org.json.JSONException;
import weibo.weibo4j.org.json.JSONObject;
import weibo.weibo4j.util.ArrayUtils;
import weibo.weibo4j.util.WeiboConfig;

public class Favorite
extends Weibo {
    private static final long serialVersionUID = 2298934944028795652L;

    public Favorite(String access_token) {
        this.access_token = access_token;
    }

    public List<Favorites> getFavorites() throws WeiboException {
        return Favorites.constructFavorites(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites.json", this.access_token));
    }

    public List<Favorites> getFavorites(Paging page) throws WeiboException {
        return Favorites.constructFavorites(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites.json", null, page, this.access_token));
    }

    public List<Favorites> getFavorites(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Favorites.constructFavorites(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites.json", parList, this.access_token));
    }

    public List<FavoritesIds> getFavoritesIds() throws WeiboException {
        return FavoritesIds.constructFavoritesIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/ids.json", this.access_token));
    }

    public JSONObject getFavoritesIds(Paging page) throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/ids.json", null, page, this.access_token).asJSONObject();
    }

    public JSONObject getFavoritesIds(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/ids.json", parList, this.access_token).asJSONObject();
    }

    public Favorites showFavorites(String id) throws WeiboException {
        return new Favorites(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/show.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public List<Favorites> getFavoritesByTags(String tid) throws WeiboException {
        return Favorites.constructFavorites(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/by_tags.json", new PostParameter[]{new PostParameter("tid", tid)}, this.access_token));
    }

    public List<Favorites> getFavoritesByTags(String tid, Paging page) throws WeiboException {
        return Favorites.constructFavorites(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/by_tags.json", new PostParameter[]{new PostParameter("tid", tid)}, page, this.access_token));
    }

    public List<Favorites> getFavoritesByTags(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Favorites.constructFavorites(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/by_tags.json", parList, this.access_token));
    }

    public List<FavoritesTag> getFavoritesTags() throws WeiboException {
        return Tag.constructTag(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/tags.json", this.access_token));
    }

    public List<FavoritesTag> getFavoritesTags(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Tag.constructTag(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/tags.json", parList, this.access_token));
    }

    public List<FavoritesIds> getFavoritesIdsByTags(String tid) throws WeiboException {
        return FavoritesIds.constructFavoritesIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/by_tags/ids.json", new PostParameter[]{new PostParameter("tid", tid)}, this.access_token));
    }

    public List<FavoritesIds> getFavoritesIdsByTags(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return FavoritesIds.constructFavoritesIds(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/by_tags/ids.json", parList, this.access_token));
    }

    public Favorites createFavorites(String id) throws WeiboException {
        return new Favorites(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/create.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public Favorites destroyFavorites(String id) throws WeiboException {
        return new Favorites(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/destroy.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public Boolean destroyFavoritesBatch(String ids) throws WeiboException {
        try {
            return client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, this.access_token).asJSONObject().getBoolean("result");
        }
        catch (JSONException e) {
            throw new WeiboException(e);
        }
    }

    public Favorites updateFavoritesTags(String id) throws WeiboException {
        return new Favorites(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/tags/update.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public Favorites updateFavoritesTags(String id, String tags) throws WeiboException {
        return new Favorites(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/tags/update.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("tags", tags)}, this.access_token));
    }

    public JSONObject updateFavoritesTagsBatch(String tid, String tag) throws WeiboException {
        return client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/tags/update_batch.json", new PostParameter[]{new PostParameter("tid", tid), new PostParameter("tag", tag)}, this.access_token).asJSONObject();
    }

    public Boolean destroyFavoritesTagsBatch(String ids) throws WeiboException {
        try {
            return client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "favorites/destroy_batch.json", new PostParameter[]{new PostParameter("ids", ids)}, this.access_token).asJSONObject().getBoolean("result");
        }
        catch (JSONException e) {
            throw new WeiboException(e);
        }
    }
}

