/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j;

import java.util.List;
import java.util.Map;
import weibo.weibo4j.Weibo;
import weibo.weibo4j.model.Comment;
import weibo.weibo4j.model.CommentWapper;
import weibo.weibo4j.model.Paging;
import weibo.weibo4j.model.PostParameter;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.util.ArrayUtils;
import weibo.weibo4j.util.WeiboConfig;

public class Comments
extends Weibo {
    private static final long serialVersionUID = 3321231200237418256L;

    public Comments(String access_token) {
        this.access_token = access_token;
    }

    public CommentWapper getCommentById(String id) throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/show.json", new PostParameter[]{new PostParameter("id", id)}, this.access_token));
    }

    public CommentWapper getCommentById(String id, Paging page, Integer filter_by_author) throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/show.json", new PostParameter[]{new PostParameter("id", id), new PostParameter("filter_by_author", filter_by_author.toString())}, page, this.access_token));
    }

    public CommentWapper getCommentById(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/show.json", parList, this.access_token));
    }

    public CommentWapper getCommentByMe() throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/by_me.json", this.access_token));
    }

    public CommentWapper getCommentByMe(Paging page, Integer filter_by_source) throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/by_me.json", new PostParameter[]{new PostParameter("filter_by_author", filter_by_source.toString())}, page, this.access_token));
    }

    public CommentWapper getCommentByMe(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/by_me.json", parList, this.access_token));
    }

    public CommentWapper getCommentToMe() throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/to_me.json", this.access_token));
    }

    public CommentWapper getCommentToMe(Paging page, Integer filter_by_source, Integer filter_by_author) throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/to_me.json", new PostParameter[]{new PostParameter("filter_by_source", filter_by_source.toString()), new PostParameter("filter_by_author", filter_by_author.toString())}, page, this.access_token));
    }

    public CommentWapper getCommentToMe(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/to_me.json", parList, this.access_token));
    }

    public CommentWapper getCommentTimeline() throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/timeline.json", this.access_token));
    }

    public CommentWapper getCommentTimeline(Paging page) throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/timeline.json", null, page, this.access_token));
    }

    public CommentWapper getCommentTimeline(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/timeline.json", parList, this.access_token));
    }

    public CommentWapper getCommentMentions() throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/mentions.json", this.access_token));
    }

    public CommentWapper getCommentMentions(Paging page, Integer filter_by_source, Integer filter_by_author) throws WeiboException {
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/mentions.json", new PostParameter[]{new PostParameter("filter_by_source", filter_by_source.toString()), new PostParameter("filter_by_author", filter_by_author.toString())}, page, this.access_token));
    }

    public CommentWapper getCommentMentions(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return Comment.constructWapperComments(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/mentions.json", parList, this.access_token));
    }

    public List<Comment> getCommentShowBatch(String cids) throws WeiboException {
        return Comment.constructComment(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/show_batch.json", new PostParameter[]{new PostParameter("cids", cids)}, this.access_token));
    }

    public Comment createComment(String comment, String id) throws WeiboException {
        return new Comment(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/create.json", new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id)}, this.access_token));
    }

    public Comment createComment(String comment, String id, Integer comment_ori) throws WeiboException {
        return new Comment(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/create.json", new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id), new PostParameter("comment_ori", comment_ori.toString())}, this.access_token));
    }

    public Comment createComment(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new Comment(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/create.json", parList, this.access_token));
    }

    public Comment replyComment(String cid, String id, String comment) throws WeiboException {
        return new Comment(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/reply.json", new PostParameter[]{new PostParameter("cid", cid), new PostParameter("id", id), new PostParameter("comment", comment)}, this.access_token));
    }

    public Comment replyComment(String cid, String id, String comment, Integer without_mention, Integer comment_ori) throws WeiboException {
        return new Comment(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/reply.json", new PostParameter[]{new PostParameter("comment", comment), new PostParameter("id", id), new PostParameter("cid", cid), new PostParameter("without_mention", without_mention.toString()), new PostParameter("comment_ori", comment_ori.toString())}, this.access_token));
    }

    public Comment replyComment(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return new Comment(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/reply.json", parList, this.access_token));
    }

    public Comment destroyComment(String cid) throws WeiboException {
        return new Comment(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/destroy.json", new PostParameter[]{new PostParameter("cid", cid)}, this.access_token));
    }

    public List<Comment> destoryCommentBatch(String cids) throws WeiboException {
        return Comment.constructComment(client.post(String.valueOf(WeiboConfig.getValue("baseURL")) + "comments/destroy_batch.json", new PostParameter[]{new PostParameter("cids", cids)}, this.access_token));
    }
}

