/*
 * Decompiled with CFR 0.152.
 */
package weibo.weibo4j;

import java.util.List;
import java.util.Map;
import weibo.weibo4j.Weibo;
import weibo.weibo4j.model.PostParameter;
import weibo.weibo4j.model.Privacy;
import weibo.weibo4j.model.RateLimitStatus;
import weibo.weibo4j.model.School;
import weibo.weibo4j.model.User;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.org.json.JSONObject;
import weibo.weibo4j.util.ArrayUtils;
import weibo.weibo4j.util.WeiboConfig;

public class Account
extends Weibo {
    private static final long serialVersionUID = 3816005087976772682L;

    public Account(String access_token) {
        this.access_token = access_token;
    }

    public JSONObject getUid() throws WeiboException {
        return client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "account/get_uid.json", this.access_token).asJSONObject();
    }

    public Privacy getAccountPrivacy() throws WeiboException {
        return new Privacy(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "account/get_privacy.json", this.access_token));
    }

    public List<School> getAccountProfileSchoolList(String keyword) throws WeiboException {
        return School.constructSchool(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "account/profile/school_list.json", new PostParameter[]{new PostParameter("keyword", keyword)}, this.access_token));
    }

    public List<School> getAccountProfileSchoolList(String province, String capital) throws WeiboException {
        return School.constructSchool(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "account/profile/school_list.json", new PostParameter[]{new PostParameter("province", province), new PostParameter("capital", capital)}, this.access_token));
    }

    public List<School> getAccountProfileSchoolList(Map<String, String> map) throws WeiboException {
        PostParameter[] parList = ArrayUtils.mapToArray(map);
        return School.constructSchool(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "account/profile/school_list.json", parList, this.access_token));
    }

    public RateLimitStatus getAccountRateLimitStatus() throws WeiboException {
        return new RateLimitStatus(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "account/rate_limit_status.json", this.access_token));
    }

    public User endSession() throws WeiboException {
        return new User(client.get(String.valueOf(WeiboConfig.getValue("baseURL")) + "account/end_session.json", this.access_token));
    }
}

