/*
 * Decompiled with CFR 0.152.
 */
package weibo.account.controller;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weibo.account.entity.WeiboAccount;
import weibo.account.service.WeiboAccountService;
import weibo.weibo4j.Account;
import weibo.weibo4j.Oauth4Jeewx;
import weibo.weibo4j.Timeline;
import weibo.weibo4j.Users;
import weibo.weibo4j.http.AccessToken;
import weibo.weibo4j.http.ImageItem;
import weibo.weibo4j.model.User;
import weibo.weibo4j.model.WeiboException;
import weibo.weibo4j.util.WeiboConfig;
import weixin.util.DateUtils;

@Controller
@RequestMapping(value={"/weiboAccountController"})
public class WeiboAccountController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeiboAccountController.class);
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeiboAccountService weiboAccountService;

    @RequestMapping(params={"setAccountCode"})
    public ModelAndView setAccountCode(HttpServletRequest request, String code) {
        if (!StringUtil.isEmpty((String)code)) {
            Oauth4Jeewx oj = new Oauth4Jeewx();
            WeiboAccount weiboAccount = null;
            try {
                AccessToken accesstoken = oj.getAccessTokenByCode(code, WeiboConfig.getValue("appkey").trim(), WeiboConfig.getValue("appSecret").trim());
                Account accountService = new Account(accesstoken.getAccessToken());
                Users usersService = new Users(accesstoken.getAccessToken());
                User weiboUser = usersService.showUserById(accountService.getUid().getString("uid"));
                List weiboAccountList = this.weiboAccountService.findByProperty(WeiboAccount.class, "weiboid", weiboUser.getId());
                if (weiboAccountList == null || weiboAccountList.size() < 1) {
                    weiboAccount = new WeiboAccount();
                    weiboAccount.setAccessToken(accesstoken.getAccessToken());
                    weiboAccount.setAccountid(ResourceUtil.getShangJiaAccountId());
                    weiboAccount.setExpiresin(Long.valueOf(accesstoken.getExpireIn()));
                    weiboAccount.setTokenEndTime(new Date(new Date().getTime() + Long.valueOf(accesstoken.getExpireIn())));
                    weiboAccount.setTokenGetTime(new Date());
                    weiboAccount.setTokenStatus("2");
                    weiboAccount.setWeiboid(weiboUser.getId());
                    weiboAccount.setWeiboName(weiboUser.getScreenName());
                    this.weiboAccountService.save((Object)weiboAccount);
                } else {
                    weiboAccount = (WeiboAccount)((Object)weiboAccountList.get(0));
                    weiboAccount.setAccessToken(accesstoken.getAccessToken());
                    weiboAccount.setAccountid(ResourceUtil.getShangJiaAccountId());
                    weiboAccount.setExpiresin(Long.valueOf(accesstoken.getExpireIn()));
                    weiboAccount.setTokenEndTime(new Date(new Date().getTime() + Long.valueOf(accesstoken.getExpireIn())));
                    weiboAccount.setTokenGetTime(new Date());
                    weiboAccount.setTokenStatus("2");
                    weiboAccount.setWeiboid(weiboUser.getId());
                    weiboAccount.setWeiboName(weiboUser.getScreenName());
                    this.weiboAccountService.saveOrUpdate((Object)weiboAccount);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                request.setAttribute("errno", (Object)-1);
            }
            request.setAttribute("errno", (Object)1);
        }
        return new ModelAndView("weibo/account/setcode");
    }

    @RequestMapping(params={"doAuthor"})
    @ResponseBody
    public void doAuthor(HttpServletRequest request, HttpServletResponse response) {
        try {
            Oauth4Jeewx oj = new Oauth4Jeewx();
            String weibourl = oj.authorize("code", WeiboConfig.getValue("appkey").trim());
            response.sendRedirect(String.valueOf(weibourl) + "&forcelogin=true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"goSendTextMessage"})
    public ModelAndView goSendTextMessage(HttpServletRequest request, String ids) {
        request.setAttribute("ids", (Object)ids);
        return new ModelAndView("weibo/account/sendtextmessage");
    }

    @RequestMapping(params={"goSendImgMessage"})
    public ModelAndView goSendImgMessage(HttpServletRequest request, String ids) {
        request.setAttribute("ids", (Object)ids);
        return new ModelAndView("weibo/account/sendimgmessage");
    }

    @ResponseBody
    @RequestMapping(params={"doSendTextMessage"})
    public AjaxJson doSendTextMessage(HttpServletRequest request, String ids, String content) {
        AjaxJson json = new AjaxJson();
        String[] idarray = ids.split(",");
        String message = "\u6267\u884c\u6210\u529f";
        String[] stringArray = idarray;
        int n = idarray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            WeiboAccount account = (WeiboAccount)((Object)this.weiboAccountService.get(WeiboAccount.class, (Serializable)((Object)id)));
            Long endtime = account.getTokenEndTime().getTime();
            Long nowtime = new Date().getTime();
            if (nowtime >= endtime) {
                account.setTokenStatus("3");
                this.weiboAccountService.updateEntitie((Object)account);
                message = String.valueOf(message) + "\u5fae\u535a\u540d\u79f0\uff1a" + account.getWeiboName() + "token\u5df2\u7ecf\u8fc7\u671f\uff0c\u672c\u6b21\u53d1\u5e03\u5c06\u5931\u8d25\u3002</br>";
            } else {
                Timeline timeline = new Timeline(account.getAccessToken());
                try {
                    timeline.updateStatus(content);
                }
                catch (WeiboException e) {
                    message = String.valueOf(message) + ",[" + account.getWeiboName() + "]\u8fde\u63a5\u5fae\u535a\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002";
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        json.setSuccess(true);
        json.setMsg(message);
        return json;
    }

    @ResponseBody
    @RequestMapping(params={"doSendTextMessageWithImg"})
    public AjaxJson doSendTextMessageWithImg(HttpServletRequest request, String ids, String content, String imgdesc, String imgurl) {
        AjaxJson json = new AjaxJson();
        String[] idarray = ids.split(",");
        String message = "\u6267\u884c\u6210\u529f";
        String[] stringArray = idarray;
        int n = idarray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            WeiboAccount account = (WeiboAccount)((Object)this.weiboAccountService.get(WeiboAccount.class, (Serializable)((Object)id)));
            Long endtime = account.getTokenEndTime().getTime();
            Long nowtime = new Date().getTime();
            if (nowtime >= endtime) {
                account.setTokenStatus("3");
                this.weiboAccountService.updateEntitie((Object)account);
                message = String.valueOf(message) + "\u5fae\u535a\u540d\u79f0\uff1a" + account.getWeiboName() + "token\u5df2\u7ecf\u8fc7\u671f\uff0c\u672c\u6b21\u53d1\u5e03\u5c06\u5931\u8d25\u3002</br>";
            } else {
                Timeline timeline = new Timeline(account.getAccessToken());
                try {
                    ImageItem imageitem = new ImageItem("pic", WeiboAccountController.readFileImage(request.getSession().getServletContext().getRealPath(imgurl)));
                    timeline.uploadStatus(URLEncoder.encode(content, "utf-8"), imageitem);
                }
                catch (WeiboException e) {
                    message = "\u5fae\u535a\u670d\u52a1\u5668\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002";
                    e.printStackTrace();
                }
                catch (IOException e) {
                    message = e.getMessage();
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        json.setSuccess(true);
        json.setMsg(message);
        return json;
    }

    private static byte[] readFileImage(String filename) throws IOException {
        byte[] bytes;
        int r;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(filename));
        int len = bufferedInputStream.available();
        if (len != (r = bufferedInputStream.read(bytes = new byte[len]))) {
            bytes = null;
            throw new IOException("\u8bfb\u53d6\u6587\u4ef6\u4e0d\u6b63\u786e");
        }
        bufferedInputStream.close();
        return bytes;
    }

    @RequestMapping(params={"weiboAccount"})
    public ModelAndView weiboAccount(HttpServletRequest request) {
        return new ModelAndView("weibo/account/weiboAccountList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeiboAccount weiboAccount, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeiboAccount.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)weiboAccount), (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List accountlist = this.weiboAccountService.getListByCriteriaQuery(cq, true);
        for (WeiboAccount a : accountlist) {
            if (!"2".equals(a.getTokenStatus())) continue;
            Long endtime = a.getTokenEndTime().getTime();
            Long nowtime = new Date().getTime();
            if (nowtime < endtime) continue;
            a.setTokenStatus("3");
            this.weiboAccountService.updateEntitie((Object)a);
        }
        this.weiboAccountService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeiboAccount weiboAccount, HttpServletRequest req) {
        return new ModelAndView("weibo/account/weiboAccount-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeiboAccount weiboAccount, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weiboAccount.getId())) {
            weiboAccount = (WeiboAccount)((Object)this.weiboAccountService.getEntity(WeiboAccount.class, (Serializable)((Object)weiboAccount.getId())));
            req.setAttribute("weiboAccountPage", (Object)weiboAccount);
        }
        return new ModelAndView("weibo/account/weiboAccount-add");
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeiboAccount weiboAccount, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String message = "\u65b0\u589e\u5fae\u535a\u5e10\u53f7\u6210\u529f";
        try {
            if (StringUtil.isEmpty((String)weiboAccount.getId())) {
                weiboAccount.setTokenStatus("0");
                this.weiboAccountService.save((Object)weiboAccount);
            } else {
                WeiboAccount updateAccount = (WeiboAccount)((Object)this.weiboAccountService.get(WeiboAccount.class, (Serializable)((Object)weiboAccount.getId())));
                MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)weiboAccount), (Object)((Object)updateAccount));
                this.weiboAccountService.updateEntitie((Object)updateAccount);
            }
            this.systemService.addLog(message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u65b0\u589e\u5fae\u535a\u5e10\u53f7\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(message);
        return j;
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DateUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("sina");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(WeiboAccount weiboAccount, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String ids = request.getParameter("ids");
        String[] entitys = ids.split(",");
        ArrayList<WeiboAccount> list = new ArrayList<WeiboAccount>();
        int i = 0;
        while (i < entitys.length) {
            weiboAccount = (WeiboAccount)((Object)this.systemService.getEntity(WeiboAccount.class, (Serializable)((Object)entitys[i])));
            list.add(weiboAccount);
            ++i;
        }
        String message = "\u5220\u9664\u6210\u529f";
        this.weiboAccountService.deleteAllEntitie(list);
        this.systemService.addLog(message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(message);
        return j;
    }
}

