/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.p3.cg.factory;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.p3.cg.ColumnData;
import org.jeecgframework.p3.cg.CreateBean;
import org.jeecgframework.p3.cg.database.JeecgReadTable;
import org.jeecgframework.p3.cg.def.CodeResourceUtil;
import org.jeecgframework.p3.cg.def.FreemarkerEngine;
import org.jeecgframework.p3.cg.pojo.onetomany.CodeParamEntity;
import org.jeecgframework.p3.cg.pojo.onetomany.SubTableEntity;

public class CodeGenerateFactoryOneToMany {
    private static final Log log = LogFactory.getLog(CodeGenerateFactoryOneToMany.class);
    private static String url = CodeResourceUtil.URL;
    private static String username = CodeResourceUtil.USERNAME;
    private static String passWord = CodeResourceUtil.PASSWORD;
    private static Configuration cfg = new Configuration();
    private static Map<String, Object> root = new HashMap<String, Object>();
    private static CreateBean createBean = new CreateBean();
    private static String pathSrc = "";
    private static String author = "";

    static {
        pathSrc = CodeResourceUtil.getConfigInfo("path_src");
        String source_root_package = CodeResourceUtil.getConfigInfo("source_root_package");
        pathSrc = String.valueOf(pathSrc) + File.separator + source_root_package.replace(".", File.separator);
        author = CodeResourceUtil.getConfigInfo("author");
    }

    public static void oneToManyCreate(CodeParamEntity codeParamEntityIn, List<SubTableEntity> subTabParamIn) {
        try {
            String projectName = CodeResourceUtil.getConfigInfo("project_name");
            codeParamEntityIn.setProjectName(projectName);
            String bussiPackage = CodeResourceUtil.getConfigInfo("bussi_package");
            codeParamEntityIn.setEntityPackage(bussiPackage);
            createBean.setMysqlInfo(url, username, passWord);
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2 E ");
            String nowDate = dateformat.format(new Date());
            System.out.println("\u65f6\u95f4:" + nowDate);
            root.put("author", author);
            root.put("nowDate", nowDate);
            String templateBasePath = String.valueOf(CodeGenerateFactoryOneToMany.getClassPath()) + CodeResourceUtil.getConfigInfo("templatepath_ftl") + "/onetomany";
            cfg.setDirectoryForTemplateLoading(new File(templateBasePath));
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            CodeGenerateFactoryOneToMany.createEntity(codeParamEntityIn, subTabParamIn);
            CodeGenerateFactoryOneToMany.createDao(codeParamEntityIn, subTabParamIn);
            CodeGenerateFactoryOneToMany.createSql(codeParamEntityIn, subTabParamIn);
            CodeGenerateFactoryOneToMany.createService(codeParamEntityIn, subTabParamIn);
            CodeGenerateFactoryOneToMany.createServiceImpl(codeParamEntityIn, subTabParamIn);
            CodeGenerateFactoryOneToMany.createController(codeParamEntityIn, subTabParamIn);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private static void createController(CodeParamEntity codeParamEntityIn, List<SubTableEntity> subTabParamIn) {
        CodeGenerateFactoryOneToMany.initControllerParam(codeParamEntityIn, subTabParamIn);
        String basePackage = CodeResourceUtil.getConfigInfo("base_package");
        String className = codeParamEntityIn.getEntityName();
        String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
        String projectName = codeParamEntityIn.getProjectName();
        String bussiPackage = codeParamEntityIn.getEntityPackage();
        basePackage = String.valueOf(basePackage) + "." + projectName;
        String pagePackage = String.valueOf(basePackage) + "." + bussiPackage + ".page";
        String pagePath = String.valueOf(pagePackage.replace(".", File.separator)) + File.separator + className + "Page.java";
        FreemarkerEngine.createFileByFTL(cfg, root, "pageClass.ftl", pathSrc, pagePath);
        String controllerPackage = String.valueOf(basePackage) + "." + bussiPackage + ".web";
        String controllerPath = String.valueOf(controllerPackage.replace(".", File.separator)) + File.separator + className + "Controller.java";
        FreemarkerEngine.createFileByFTL(cfg, root, "controllerClass.ftl", pathSrc, controllerPath);
        String pageVmPackage = "content." + projectName + "." + bussiPackage;
        String pageIndexPath = String.valueOf(pageVmPackage.replace(".", File.separator)) + File.separator + lowerName + "-list.vm";
        String pageAddPath = String.valueOf(pageVmPackage.replace(".", File.separator)) + File.separator + lowerName + "-add.vm";
        String pageAddJsPath = String.valueOf(pageVmPackage.replace(".", File.separator)) + File.separator + lowerName + "-add.js";
        String pageEditPath = String.valueOf(pageVmPackage.replace(".", File.separator)) + File.separator + lowerName + "-edit.vm";
        String pageDetailPath = String.valueOf(pageVmPackage.replace(".", File.separator)) + File.separator + lowerName + "-detail.vm";
        FreemarkerEngine.createFileByFTL(cfg, root, "pageIndex.ftl", pathSrc, pageIndexPath);
        FreemarkerEngine.createFileByFTL(cfg, root, "pageAdd.ftl", pathSrc, pageAddPath);
        FreemarkerEngine.createFileByFTL(cfg, root, "pageAddJs.ftl", pathSrc, pageAddJsPath);
        FreemarkerEngine.createFileByFTL(cfg, root, "pageDetail.ftl", pathSrc, pageDetailPath);
        FreemarkerEngine.createFileByFTL(cfg, root, "pageEdit.ftl", pathSrc, pageEditPath);
    }

    private static void initControllerParam(CodeParamEntity codeParamEntityIn, List<SubTableEntity> subTabParamIn) {
        CodeGenerateFactoryOneToMany.initControllerMainParam(codeParamEntityIn);
        CodeGenerateFactoryOneToMany.initControllerSubParam(codeParamEntityIn.getProjectName(), subTabParamIn);
    }

    private static void initControllerMainParam(CodeParamEntity codeParamEntityIn) {
        try {
            String tableName = codeParamEntityIn.getTableName();
            String className = codeParamEntityIn.getEntityName();
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            String codeName = codeParamEntityIn.getFtlDescription();
            String bussiPackage = codeParamEntityIn.getEntityPackage();
            String projectName = codeParamEntityIn.getProjectName();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String servicePackage = String.valueOf(basePackage) + "." + bussiPackage + ".service";
            String pagePackage = String.valueOf(basePackage) + "." + bussiPackage + ".page";
            String pageVmPackage = "content." + projectName + "." + bussiPackage;
            String pageAddJsPath = String.valueOf(pageVmPackage.replace(".", "/")) + "/" + lowerName + "-add.js";
            String controllerPackage = String.valueOf(basePackage) + "." + bussiPackage + ".web";
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("projectName", projectName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("lowerName", lowerName);
            root.put("bussPackage", bussiPackage);
            root.put("servicePackage", servicePackage);
            root.put("pagePackage", pagePackage);
            root.put("pageAddJsPath", pageAddJsPath);
            root.put("controllerPackage", controllerPackage);
            root.put("mainEntity", codeParamEntityIn);
            List<ColumnData> columnDatas = JeecgReadTable.readTableColumn(tableName);
            root.put("columnDatas", columnDatas);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initControllerSubParam(String projectName, List<SubTableEntity> subTabParamIn) {
        try {
            for (SubTableEntity sub : subTabParamIn) {
                HashMap<String, Object> paramData = new HashMap<String, Object>();
                String tableName = sub.getTableName();
                String className = sub.getEntityName();
                String codeName = sub.getFtlDescription();
                String bussiPackage = sub.getEntityPackage();
                String basePackage = CodeResourceUtil.getConfigInfo("base_package");
                basePackage = String.valueOf(basePackage) + "." + projectName;
                String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
                String daoPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao";
                String servicePackage = String.valueOf(basePackage) + "." + bussiPackage + ".service";
                String serviceImplPackage = String.valueOf(basePackage) + "." + bussiPackage + ".service.impl";
                String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
                paramData.put("className", className);
                paramData.put("codeName", codeName);
                paramData.put("tableName", tableName);
                paramData.put("domainPackage", domainPackage);
                paramData.put("lowerName", lowerName);
                paramData.put("daoPackage", daoPackage);
                paramData.put("servicePackage", servicePackage);
                paramData.put("serviceImplPackage", serviceImplPackage);
                String foreignKeyTable = sub.getForeignKey().toUpperCase();
                String foreignKeyUpper = createBean.getTablesNameToClassName(foreignKeyTable);
                paramData.put("foreignKeyTable", foreignKeyTable);
                paramData.put("foreignKeyUpper", foreignKeyUpper);
                String foreignKey = String.valueOf(foreignKeyUpper.substring(0, 1).toLowerCase()) + foreignKeyUpper.substring(1, foreignKeyUpper.length());
                paramData.put("foreignKey", foreignKey);
                String mainForeignKeyTable = sub.getMainForeignKey().toUpperCase();
                String mainForeignKeyUpper = createBean.getTablesNameToClassName(mainForeignKeyTable);
                paramData.put("mainForeignKeyTable", mainForeignKeyTable);
                paramData.put("mainForeignKeyUpper", mainForeignKeyUpper);
                String mainForeignKey = String.valueOf(mainForeignKeyUpper.substring(0, 1).toLowerCase()) + mainForeignKeyUpper.substring(1, mainForeignKeyUpper.length());
                paramData.put("mainForeignKey", mainForeignKey);
                List<ColumnData> columnDatas = JeecgReadTable.readTableColumn(tableName);
                paramData.put("columnDatas", columnDatas);
                sub.setParamData(paramData);
            }
            root.put("subEntityList", subTabParamIn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createServiceImpl(CodeParamEntity codeParamEntityIn, List<SubTableEntity> subTabParamIn) {
        CodeGenerateFactoryOneToMany.createServiceImplMain(codeParamEntityIn);
        for (SubTableEntity sub : subTabParamIn) {
            CodeGenerateFactoryOneToMany.createServiceImplSub(codeParamEntityIn.getProjectName(), sub);
        }
    }

    private static void createServiceImplMain(CodeParamEntity codeParamEntityIn) {
        try {
            String tableName = codeParamEntityIn.getTableName();
            String className = codeParamEntityIn.getEntityName();
            String codeName = codeParamEntityIn.getFtlDescription();
            String bussiPackage = codeParamEntityIn.getEntityPackage();
            String projectName = codeParamEntityIn.getProjectName();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String daoPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao";
            String servicePackage = String.valueOf(basePackage) + "." + bussiPackage + ".service";
            String serviceImplPackage = String.valueOf(basePackage) + "." + bussiPackage + ".service.impl";
            String serviceImplPath = String.valueOf(serviceImplPackage.replace(".", File.separator)) + File.separator + className + "ServiceImpl.java";
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("lowerName", lowerName);
            root.put("daoPackage", daoPackage);
            root.put("servicePackage", servicePackage);
            root.put("serviceImplPackage", serviceImplPackage);
            FreemarkerEngine.createFileByFTL(cfg, root, "serviceImplMainClass.ftl", pathSrc, serviceImplPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createServiceImplSub(String projectName, SubTableEntity subTabParamIn) {
        try {
            String tableName = subTabParamIn.getTableName();
            String className = subTabParamIn.getEntityName();
            String codeName = subTabParamIn.getFtlDescription();
            String bussiPackage = subTabParamIn.getEntityPackage();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String daoPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao";
            String servicePackage = String.valueOf(basePackage) + "." + bussiPackage + ".service";
            String serviceImplPackage = String.valueOf(basePackage) + "." + bussiPackage + ".service.impl";
            String serviceImplPath = String.valueOf(serviceImplPackage.replace(".", File.separator)) + File.separator + className + "ServiceImpl.java";
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("lowerName", lowerName);
            root.put("daoPackage", daoPackage);
            root.put("servicePackage", servicePackage);
            root.put("serviceImplPackage", serviceImplPackage);
            String foreignKeyTable = subTabParamIn.getForeignKey().toUpperCase();
            String foreignKeyUpper = createBean.getTablesNameToClassName(foreignKeyTable);
            root.put("foreignKeyTable", foreignKeyTable);
            root.put("foreignKeyUpper", foreignKeyUpper);
            String foreignKey = String.valueOf(foreignKeyUpper.substring(0, 1).toLowerCase()) + foreignKeyUpper.substring(1, foreignKeyUpper.length());
            root.put("foreignKey", foreignKey);
            FreemarkerEngine.createFileByFTL(cfg, root, "serviceImplSubClass.ftl", pathSrc, serviceImplPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createService(CodeParamEntity codeParamEntityIn, List<SubTableEntity> subTabParamIn) {
        CodeGenerateFactoryOneToMany.createServiceMain(codeParamEntityIn);
        for (SubTableEntity sub : subTabParamIn) {
            CodeGenerateFactoryOneToMany.createServiceSub(codeParamEntityIn.getProjectName(), sub);
        }
    }

    private static void createServiceMain(CodeParamEntity codeParamEntityIn) {
        try {
            String tableName = codeParamEntityIn.getTableName();
            String className = codeParamEntityIn.getEntityName();
            String codeName = codeParamEntityIn.getFtlDescription();
            String bussiPackage = codeParamEntityIn.getEntityPackage();
            String projectName = codeParamEntityIn.getProjectName();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String daoPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao";
            String servicePackage = String.valueOf(basePackage) + "." + bussiPackage + ".service";
            String servicePath = String.valueOf(servicePackage.replace(".", File.separator)) + File.separator + className + "Service.java";
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("lowerName", lowerName);
            root.put("daoPackage", daoPackage);
            root.put("servicePackage", servicePackage);
            FreemarkerEngine.createFileByFTL(cfg, root, "serviceMainClass.ftl", pathSrc, servicePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createServiceSub(String projectName, SubTableEntity subTabParamIn) {
        try {
            String tableName = subTabParamIn.getTableName();
            String className = subTabParamIn.getEntityName();
            String codeName = subTabParamIn.getFtlDescription();
            String bussiPackage = subTabParamIn.getEntityPackage();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String daoPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao";
            String servicePackage = String.valueOf(basePackage) + "." + bussiPackage + ".service";
            String servicePath = String.valueOf(servicePackage.replace(".", File.separator)) + File.separator + className + "Service.java";
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("lowerName", lowerName);
            root.put("daoPackage", daoPackage);
            root.put("servicePackage", servicePackage);
            String foreignKeyTable = subTabParamIn.getForeignKey().toUpperCase();
            String foreignKeyUpper = createBean.getTablesNameToClassName(foreignKeyTable);
            root.put("foreignKeyTable", foreignKeyTable);
            root.put("foreignKeyUpper", foreignKeyUpper);
            String foreignKey = String.valueOf(foreignKeyUpper.substring(0, 1).toLowerCase()) + foreignKeyUpper.substring(1, foreignKeyUpper.length());
            root.put("foreignKey", foreignKey);
            FreemarkerEngine.createFileByFTL(cfg, root, "serviceSubClass.ftl", pathSrc, servicePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createSql(CodeParamEntity codeParamEntityIn, List<SubTableEntity> subTabParamIn) {
        CodeGenerateFactoryOneToMany.createSqlMain(codeParamEntityIn);
        for (SubTableEntity sub : subTabParamIn) {
            CodeGenerateFactoryOneToMany.createSqlSub(codeParamEntityIn.getProjectName(), sub);
        }
    }

    private static void createSqlMain(CodeParamEntity codeParamEntityIn) {
        try {
            String tableName = codeParamEntityIn.getTableName();
            String className = codeParamEntityIn.getEntityName();
            String codeName = codeParamEntityIn.getFtlDescription();
            String bussiPackage = codeParamEntityIn.getEntityPackage();
            String projectName = codeParamEntityIn.getProjectName();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String sqlPackage = String.valueOf(basePackage) + "." + bussiPackage + ".sql";
            String sqlConditionPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_condition.sql";
            String sqlGetAllPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_getAll.sql";
            String sqlInsertPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_insert.sql";
            String sqlUpdatePath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_update.sql";
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("lowerName", lowerName);
            List<ColumnData> columnDatas = JeecgReadTable.readTableColumn(tableName);
            root.put("columnDatas", columnDatas);
            String tablesAsName = createBean.getTablesASName(tableName);
            root.put("tablesAsName", tablesAsName);
            FreemarkerEngine.createFileByFTL(cfg, root, "minidaoConditionSql.ftl", pathSrc, sqlConditionPath);
            FreemarkerEngine.createFileByFTL(cfg, root, "minidaoGetAllSql.ftl", pathSrc, sqlGetAllPath);
            FreemarkerEngine.createFileByFTL(cfg, root, "minidaoInsertSql.ftl", pathSrc, sqlInsertPath);
            FreemarkerEngine.createFileByFTL(cfg, root, "minidaoUpdateSql.ftl", pathSrc, sqlUpdatePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createSqlSub(String projectName, SubTableEntity subTabParamIn) {
        try {
            String tableName = subTabParamIn.getTableName();
            String className = subTabParamIn.getEntityName();
            String codeName = subTabParamIn.getFtlDescription();
            String bussiPackage = subTabParamIn.getEntityPackage();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String sqlPackage = String.valueOf(basePackage) + "." + bussiPackage + ".sql";
            String sqlConditionPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_condition.sql";
            String sqlGetAllPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_getAll.sql";
            String sqlInsertPath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_insert.sql";
            String sqlUpdatePath = String.valueOf(sqlPackage.replace(".", File.separator)) + File.separator + className + "Dao_update.sql";
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("lowerName", lowerName);
            List<ColumnData> columnDatas = JeecgReadTable.readTableColumn(tableName);
            root.put("columnDatas", columnDatas);
            String tablesAsName = createBean.getTablesASName(tableName);
            root.put("tablesAsName", tablesAsName);
            FreemarkerEngine.createFileByFTL(cfg, root, "minidaoConditionSql.ftl", pathSrc, sqlConditionPath);
            FreemarkerEngine.createFileByFTL(cfg, root, "minidaoGetAllSql.ftl", pathSrc, sqlGetAllPath);
            FreemarkerEngine.createFileByFTL(cfg, root, "minidaoInsertSql.ftl", pathSrc, sqlInsertPath);
            FreemarkerEngine.createFileByFTL(cfg, root, "minidaoUpdateSql.ftl", pathSrc, sqlUpdatePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createDao(CodeParamEntity codeParamEntityIn, List<SubTableEntity> subTabParamIn) {
        CodeGenerateFactoryOneToMany.createDaoMain(codeParamEntityIn);
        for (SubTableEntity sub : subTabParamIn) {
            CodeGenerateFactoryOneToMany.createDaoSub(codeParamEntityIn.getProjectName(), sub);
        }
    }

    private static void createDaoMain(CodeParamEntity codeParamEntityIn) {
        try {
            String tableName = codeParamEntityIn.getTableName();
            String className = codeParamEntityIn.getEntityName();
            String codeName = codeParamEntityIn.getFtlDescription();
            String bussiPackage = codeParamEntityIn.getEntityPackage();
            String projectName = codeParamEntityIn.getProjectName();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String daoPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao";
            String daoPath = String.valueOf(daoPackage.replace(".", File.separator)) + File.separator + className + "Dao.java";
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("lowerName", lowerName);
            root.put("daoPackage", daoPackage);
            FreemarkerEngine.createFileByFTL(cfg, root, "daoMainClass.ftl", pathSrc, daoPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createDaoSub(String projectName, SubTableEntity subTabParamIn) {
        try {
            String tableName = subTabParamIn.getTableName();
            String className = subTabParamIn.getEntityName();
            String codeName = subTabParamIn.getFtlDescription();
            String bussiPackage = subTabParamIn.getEntityPackage();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String daoPackage = String.valueOf(basePackage) + "." + bussiPackage + ".dao";
            String daoPath = String.valueOf(daoPackage.replace(".", File.separator)) + File.separator + className + "Dao.java";
            String lowerName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1, className.length());
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("lowerName", lowerName);
            root.put("daoPackage", daoPackage);
            String foreignKeyTable = subTabParamIn.getForeignKey().toUpperCase();
            String foreignKeyUpper = createBean.getTablesNameToClassName(foreignKeyTable);
            root.put("foreignKeyTable", foreignKeyTable);
            root.put("foreignKeyUpper", foreignKeyUpper);
            String foreignKey = String.valueOf(foreignKeyUpper.substring(0, 1).toLowerCase()) + foreignKeyUpper.substring(1, foreignKeyUpper.length());
            root.put("foreignKey", foreignKey);
            FreemarkerEngine.createFileByFTL(cfg, root, "daoSubClass.ftl", pathSrc, daoPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createEntity(CodeParamEntity codeParamEntityIn, List<SubTableEntity> subTabParamIn) {
        CodeGenerateFactoryOneToMany.createEntityMain(codeParamEntityIn);
        for (SubTableEntity sub : subTabParamIn) {
            CodeGenerateFactoryOneToMany.createEntitySub(codeParamEntityIn.getProjectName(), sub);
        }
    }

    private static void createEntityMain(CodeParamEntity codeParamEntityIn) {
        try {
            String tableName = codeParamEntityIn.getTableName();
            String className = codeParamEntityIn.getEntityName();
            String codeName = codeParamEntityIn.getFtlDescription();
            String bussiPackage = codeParamEntityIn.getEntityPackage();
            String projectName = codeParamEntityIn.getProjectName();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String domainPath = String.valueOf(domainPackage.replace(".", File.separator)) + File.separator + className + "Entity.java";
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("feilds", createBean.getBeanFeilds(tableName, className));
            FreemarkerEngine.createFileByFTL(cfg, root, "domainClass.ftl", pathSrc, domainPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createEntitySub(String projectName, SubTableEntity subTabParamIn) {
        try {
            String tableName = subTabParamIn.getTableName();
            String className = subTabParamIn.getEntityName();
            String codeName = subTabParamIn.getFtlDescription();
            String bussiPackage = subTabParamIn.getEntityPackage();
            String basePackage = CodeResourceUtil.getConfigInfo("base_package");
            basePackage = String.valueOf(basePackage) + "." + projectName;
            String domainPackage = String.valueOf(basePackage) + "." + bussiPackage + ".entity";
            String domainPath = String.valueOf(domainPackage.replace(".", File.separator)) + File.separator + className + "Entity.java";
            root.put("className", className);
            root.put("codeName", codeName);
            root.put("tableName", tableName);
            root.put("domainPackage", domainPackage);
            root.put("feilds", createBean.getBeanFeilds(tableName, className));
            FreemarkerEngine.createFileByFTL(cfg, root, "domainClass.ftl", pathSrc, domainPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getProjectPath() {
        String path = String.valueOf(System.getProperty("user.dir").replace("\\", File.separator)) + File.separator;
        return path;
    }

    public static String getClassPath() {
        String path = new CodeGenerateFactoryOneToMany().getClass().getResource("/").getPath();
        return path;
    }
}

