/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.p3.cg.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.p3.cg.ColumnData;
import org.jeecgframework.p3.cg.def.CodeResourceUtil;
import org.jeecgframework.p3.cg.def.CodeStringUtils;
import org.jeecgframework.p3.cg.def.TableConvert;

public class JeecgReadTable {
    private static final Log log = LogFactory.getLog(JeecgReadTable.class);
    private static final long serialVersionUID = -5324160085184088010L;
    private static Connection conn;
    private static Statement stmt;
    private static String sql;
    private static ResultSet rs;

    public static void main(String[] args) throws SQLException {
        try {
            new JeecgReadTable();
            List<ColumnData> cls = JeecgReadTable.readTableColumn("person");
            for (ColumnData c : cls) {
                System.out.println(c.getDomainPropertyName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<ColumnData> readTableColumn(String tableName) throws Exception {
        ArrayList<ColumnData> columntList = new ArrayList<ColumnData>();
        try {
            try {
                int fieldNum;
                Class.forName(CodeResourceUtil.DIVER_NAME);
                conn = DriverManager.getConnection(CodeResourceUtil.URL, CodeResourceUtil.USERNAME, CodeResourceUtil.PASSWORD);
                stmt = conn.createStatement(1005, 1007);
                if (CodeResourceUtil.DATABASE_TYPE.equals("mysql")) {
                    sql = MessageFormat.format("select column_name,data_type,column_comment,numeric_precision,numeric_scale,character_maximum_length,is_nullable nullable from information_schema.columns ,COLUMN_KEY where table_name = {0} and table_schema = {1}", TableConvert.getV(tableName.toUpperCase()), TableConvert.getV(CodeResourceUtil.DATABASE_NAME));
                }
                if (CodeResourceUtil.DATABASE_TYPE.equals("oracle")) {
                    sql = MessageFormat.format(" select colstable.column_name column_name, colstable.data_type data_type, commentstable.comments column_comment, colstable.Data_Precision column_precision, colstable.Data_Scale column_scale,colstable.Char_Length,colstable.nullable from user_tab_cols colstable  inner join user_col_comments commentstable  on colstable.column_name = commentstable.column_name  where colstable.table_name = commentstable.table_name  and colstable.table_name = {0}", TableConvert.getV(tableName.toUpperCase()));
                }
                if (CodeResourceUtil.DATABASE_TYPE.equals("postgresql")) {
                    sql = MessageFormat.format("SELECT a.attname AS  field,t.typname AS type,col_description(a.attrelid,a.attnum) as comment,null as column_precision,null as column_scale,null as Char_Length,a.attnotnull  FROM pg_class c,pg_attribute  a,pg_type t  WHERE c.relname = {0} and a.attnum > 0  and a.attrelid = c.oid and a.atttypid = t.oid  ORDER BY a.attnum ", TableConvert.getV(tableName.toLowerCase()));
                }
                if (CodeResourceUtil.DATABASE_TYPE.equals("sqlserver")) {
                    sql = MessageFormat.format("select cast(a.name as varchar(50)) column_name,  cast(b.name as varchar(50)) data_type,  cast(e.value as varchar(200)) comment,  cast(ColumnProperty(a.object_id,a.Name,'''Precision''') as int) num_precision,  cast(ColumnProperty(a.object_id,a.Name,'''Scale''') as int) num_scale,  a.max_length,  (case when a.is_nullable=1 then '''y''' else '''n''' end) nullable   from sys.columns a left join sys.types b on a.user_type_id=b.user_type_id left join sys.objects c on a.object_id=c.object_id and c.type='''U''' left join sys.extended_properties e on e.major_id=c.object_id and e.minor_id=a.column_id and e.class=1 where c.name={0}", TableConvert.getV(tableName.toLowerCase()));
                }
                rs = stmt.executeQuery(sql);
                rs.last();
                int n = fieldNum = rs.getRow();
                if (n > 0) {
                    ColumnData columnt = new ColumnData();
                    if (CodeResourceUtil.JEECG_FILED_CONVERT) {
                        columnt.setDomainPropertyName(JeecgReadTable.formatField(rs.getString(1).toLowerCase()));
                    } else {
                        columnt.setDomainPropertyName(rs.getString(1).toLowerCase());
                    }
                    columnt.setColumnName(rs.getString(1).toUpperCase());
                    columnt.setColumnType(rs.getString(2).toLowerCase());
                    String dataType = JeecgReadTable.getType(columnt.getColumnType(), columnt.getPrecision(), columnt.getScale());
                    String jdbcType = JeecgReadTable.getJdbcType(columnt.getColumnType(), columnt.getPrecision(), columnt.getScale());
                    columnt.setDataType(dataType);
                    columnt.setJdbcType(jdbcType);
                    columnt.setPrecision(rs.getString(4));
                    columnt.setScale(rs.getString(5));
                    columnt.setCharmaxLength(rs.getString(6));
                    columnt.setNullable(TableConvert.getNullAble(rs.getString(7)));
                    if ("id".equalsIgnoreCase(columnt.getDomainPropertyName())) {
                        columnt.setColumnKey("PRI");
                    } else {
                        columnt.setColumnKey("");
                    }
                    JeecgReadTable.formatFieldClassType(columnt);
                    columnt.setColumnComment(StringUtils.isBlank((String)rs.getString(3)) ? columnt.getDomainPropertyName() : rs.getString(3));
                    log.debug((Object)("columnt.getDomainPropertyName() -------------" + columnt.getDomainPropertyName()));
                    String[] ui_filter_fields = new String[]{};
                    if (CodeResourceUtil.JEECG_GENERATE_UI_FILTER_FIELDS != null) {
                        ui_filter_fields = CodeResourceUtil.JEECG_GENERATE_UI_FILTER_FIELDS.toLowerCase().split(",");
                    }
                    if (!CodeResourceUtil.GENERATE_TABLE_ID.equals(columnt.getDomainPropertyName()) && !CodeStringUtils.isIn(columnt.getColumnName().toLowerCase(), ui_filter_fields)) {
                        columntList.add(columnt);
                    }
                    while (rs.previous()) {
                        ColumnData po = new ColumnData();
                        if (CodeResourceUtil.JEECG_FILED_CONVERT) {
                            po.setDomainPropertyName(JeecgReadTable.formatField(rs.getString(1).toLowerCase()));
                        } else {
                            po.setDomainPropertyName(rs.getString(1).toLowerCase());
                        }
                        po.setColumnName(rs.getString(1).toUpperCase());
                        log.debug((Object)("columnt.getDomainPropertyName() -------------" + po.getDomainPropertyName()));
                        if (CodeResourceUtil.GENERATE_TABLE_ID.equals(po.getDomainPropertyName()) || CodeStringUtils.isIn(po.getColumnName().toLowerCase(), ui_filter_fields)) continue;
                        po.setColumnType(rs.getString(2).toLowerCase());
                        dataType = JeecgReadTable.getType(po.getColumnType(), po.getPrecision(), po.getScale());
                        jdbcType = JeecgReadTable.getJdbcType(po.getColumnType(), po.getPrecision(), po.getScale());
                        po.setDataType(dataType);
                        po.setJdbcType(jdbcType);
                        log.debug((Object)("-----po.setDataType------------" + po.getDataType()));
                        po.setPrecision(rs.getString(4));
                        po.setScale(rs.getString(5));
                        po.setCharmaxLength(rs.getString(6));
                        po.setNullable(TableConvert.getNullAble(rs.getString(7)));
                        JeecgReadTable.formatFieldClassType(po);
                        po.setColumnComment(StringUtils.isBlank((String)rs.getString(3)) ? po.getDomainPropertyName() : rs.getString(3));
                        if ("id".equalsIgnoreCase(columnt.getDomainPropertyName())) {
                            po.setColumnKey("PRI");
                        } else {
                            po.setColumnKey("");
                        }
                        columntList.add(po);
                    }
                } else {
                    throw new Exception("\u8be5\u8868\u4e0d\u5b58\u5728\u6216\u8005\u8868\u4e2d\u6ca1\u6709\u5b57\u6bb5");
                }
                log.debug((Object)"\u8bfb\u53d6\u8868\u6210\u529f");
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (SQLException e) {
                throw e;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
                System.gc();
            }
            if (conn != null) {
                conn.close();
                conn = null;
                System.gc();
            }
        }
        ArrayList<ColumnData> rsList = new ArrayList<ColumnData>();
        int i = columntList.size() - 1;
        while (i >= 0) {
            ColumnData ch = (ColumnData)columntList.get(i);
            rsList.add(ch);
            --i;
        }
        return rsList;
    }

    private static String getType(String dataType, String precision, String scale) {
        dataType = (dataType = dataType.toLowerCase()).contains("char") ? "String" : (dataType.contains("text") ? "String" : (dataType.contains("bigint") ? "Long" : (dataType.contains("int") ? "Integer" : (dataType.contains("float") ? "Float" : (dataType.contains("double") ? "Double" : (dataType.contains("number") ? (StringUtils.isNotBlank((String)scale) && Integer.parseInt(scale) > 0 ? "BigDecimal" : (StringUtils.isNotBlank((String)precision) && Integer.parseInt(precision) > 6 ? "Long" : "Integer")) : (dataType.contains("decimal") ? "BigDecimal" : (dataType.contains("date") ? "Date" : (dataType.contains("time") ? "Date" : (dataType.contains("clob") ? "String" : "Object"))))))))));
        return dataType;
    }

    private static String getJdbcType(String dataType, String precision, String scale) {
        dataType = (dataType = dataType.toLowerCase()).contains("int") ? "INTEGER" : (dataType.contains("date") ? "TIMESTAMP" : (dataType.contains("time") ? "TIMESTAMP" : (dataType.contains("clob") ? "VARCHAR" : (dataType.contains("text") ? "VARCHAR" : dataType.toUpperCase()))));
        return dataType;
    }

    public List<ColumnData> readOriginalTableColumn(String tableName) throws Exception {
        ArrayList<ColumnData> columntList = new ArrayList<ColumnData>();
        try {
            try {
                int fieldNum;
                Class.forName(CodeResourceUtil.DIVER_NAME);
                conn = DriverManager.getConnection(CodeResourceUtil.URL, CodeResourceUtil.USERNAME, CodeResourceUtil.PASSWORD);
                stmt = conn.createStatement(1005, 1007);
                if (CodeResourceUtil.DATABASE_TYPE.equals("mysql")) {
                    sql = MessageFormat.format("select column_name,data_type,column_comment,numeric_precision,numeric_scale,character_maximum_length,is_nullable nullable from information_schema.columns ,COLUMN_KEY where table_name = {0} and table_schema = {1}", TableConvert.getV(tableName.toUpperCase()), TableConvert.getV(CodeResourceUtil.DATABASE_NAME));
                }
                if (CodeResourceUtil.DATABASE_TYPE.equals("oracle")) {
                    sql = MessageFormat.format(" select colstable.column_name column_name, colstable.data_type data_type, commentstable.comments column_comment, colstable.Data_Precision column_precision, colstable.Data_Scale column_scale,colstable.Char_Length,colstable.nullable from user_tab_cols colstable  inner join user_col_comments commentstable  on colstable.column_name = commentstable.column_name  where colstable.table_name = commentstable.table_name  and colstable.table_name = {0}", TableConvert.getV(tableName.toUpperCase()));
                }
                if (CodeResourceUtil.DATABASE_TYPE.equals("postgresql")) {
                    sql = MessageFormat.format("SELECT a.attname AS  field,t.typname AS type,col_description(a.attrelid,a.attnum) as comment,null as column_precision,null as column_scale,null as Char_Length,a.attnotnull  FROM pg_class c,pg_attribute  a,pg_type t  WHERE c.relname = {0} and a.attnum > 0  and a.attrelid = c.oid and a.atttypid = t.oid  ORDER BY a.attnum ", TableConvert.getV(tableName.toLowerCase()));
                }
                if (CodeResourceUtil.DATABASE_TYPE.equals("sqlserver")) {
                    sql = MessageFormat.format("select cast(a.name as varchar(50)) column_name,  cast(b.name as varchar(50)) data_type,  cast(e.value as varchar(200)) comment,  cast(ColumnProperty(a.object_id,a.Name,'''Precision''') as int) num_precision,  cast(ColumnProperty(a.object_id,a.Name,'''Scale''') as int) num_scale,  a.max_length,  (case when a.is_nullable=1 then '''y''' else '''n''' end) nullable   from sys.columns a left join sys.types b on a.user_type_id=b.user_type_id left join sys.objects c on a.object_id=c.object_id and c.type='''U''' left join sys.extended_properties e on e.major_id=c.object_id and e.minor_id=a.column_id and e.class=1 where c.name={0}", TableConvert.getV(tableName.toLowerCase()));
                }
                rs = stmt.executeQuery(sql);
                rs.last();
                int n = fieldNum = rs.getRow();
                if (n > 0) {
                    ColumnData columnt = new ColumnData();
                    if (CodeResourceUtil.JEECG_FILED_CONVERT) {
                        columnt.setDomainPropertyName(JeecgReadTable.formatField(rs.getString(1).toLowerCase()));
                    } else {
                        columnt.setDomainPropertyName(rs.getString(1).toLowerCase());
                    }
                    columnt.setColumnName(rs.getString(1).toUpperCase());
                    columnt.setPrecision(TableConvert.getNullString(rs.getString(4)));
                    columnt.setScale(TableConvert.getNullString(rs.getString(5)));
                    columnt.setCharmaxLength(TableConvert.getNullString(rs.getString(6)));
                    columnt.setNullable(TableConvert.getNullAble(rs.getString(7)));
                    columnt.setDataType(this.formatDataType(rs.getString(2).toLowerCase(), columnt.getPrecision(), columnt.getScale()));
                    JeecgReadTable.formatFieldClassType(columnt);
                    columnt.setColumnComment(StringUtils.isBlank((String)rs.getString(3)) ? columnt.getDomainPropertyName() : rs.getString(3));
                    log.debug((Object)("columnt.getDomainPropertyName() -------------" + columnt.getDomainPropertyName()));
                    columntList.add(columnt);
                    while (rs.previous()) {
                        ColumnData po = new ColumnData();
                        if (CodeResourceUtil.JEECG_FILED_CONVERT) {
                            po.setDomainPropertyName(JeecgReadTable.formatField(rs.getString(1).toLowerCase()));
                        } else {
                            po.setDomainPropertyName(rs.getString(1).toLowerCase());
                        }
                        po.setColumnName(rs.getString(1).toUpperCase());
                        po.setPrecision(TableConvert.getNullString(rs.getString(4)));
                        po.setScale(TableConvert.getNullString(rs.getString(5)));
                        po.setCharmaxLength(TableConvert.getNullString(rs.getString(6)));
                        po.setNullable(TableConvert.getNullAble(rs.getString(7)));
                        po.setDataType(this.formatDataType(rs.getString(2).toLowerCase(), po.getPrecision(), po.getScale()));
                        JeecgReadTable.formatFieldClassType(po);
                        po.setColumnComment(StringUtils.isBlank((String)rs.getString(3)) ? po.getDomainPropertyName() : rs.getString(3));
                        columntList.add(po);
                    }
                } else {
                    throw new Exception("\u8be5\u8868\u4e0d\u5b58\u5728\u6216\u8005\u8868\u4e2d\u6ca1\u6709\u5b57\u6bb5");
                }
                log.debug((Object)"\u8bfb\u53d6\u8868\u6210\u529f");
            }
            catch (ClassNotFoundException e) {
                throw e;
            }
            catch (SQLException e) {
                throw e;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
                stmt = null;
                System.gc();
            }
            if (conn != null) {
                conn.close();
                conn = null;
                System.gc();
            }
        }
        ArrayList<ColumnData> rsList = new ArrayList<ColumnData>();
        int i = columntList.size() - 1;
        while (i >= 0) {
            ColumnData ch = (ColumnData)columntList.get(i);
            rsList.add(ch);
            --i;
        }
        return rsList;
    }

    public static String formatField(String field) {
        String[] strs = field.split("_");
        field = "";
        int m = 0;
        int length = strs.length;
        while (m < length) {
            if (m > 0) {
                String tempStr = strs[m].toLowerCase();
                tempStr = String.valueOf(tempStr.substring(0, 1).toUpperCase()) + tempStr.substring(1, tempStr.length());
                field = String.valueOf(field) + tempStr;
            } else {
                field = String.valueOf(field) + strs[m].toLowerCase();
            }
            ++m;
        }
        return field;
    }

    public static String formatFieldCapital(String field) {
        String[] strs = field.split("_");
        field = "";
        int m = 0;
        int length = strs.length;
        while (m < length) {
            if (m > 0) {
                String tempStr = strs[m].toLowerCase();
                tempStr = String.valueOf(tempStr.substring(0, 1).toUpperCase()) + tempStr.substring(1, tempStr.length());
                field = String.valueOf(field) + tempStr;
            } else {
                field = String.valueOf(field) + strs[m].toLowerCase();
            }
            ++m;
        }
        field = String.valueOf(field.substring(0, 1).toUpperCase()) + field.substring(1);
        return field;
    }

    public boolean checkTableExist(String tableName) {
        try {
            log.info((Object)("\u6570\u636e\u5e93\u9a71\u52a8: " + CodeResourceUtil.DIVER_NAME));
            Class.forName(CodeResourceUtil.DIVER_NAME);
            conn = DriverManager.getConnection(CodeResourceUtil.URL, CodeResourceUtil.USERNAME, CodeResourceUtil.PASSWORD);
            stmt = conn.createStatement(1005, 1007);
            if (CodeResourceUtil.DATABASE_TYPE.equals("mysql")) {
                sql = "select column_name,data_type,column_comment,0,0 from information_schema.columns where table_name = '" + tableName.toUpperCase() + "'" + " and table_schema = '" + CodeResourceUtil.DATABASE_NAME + "'";
            }
            if (CodeResourceUtil.DATABASE_TYPE.equals("oracle")) {
                sql = "select colstable.column_name column_name, colstable.data_type data_type, commentstable.comments column_comment from user_tab_cols colstable  inner join user_col_comments commentstable  on colstable.column_name = commentstable.column_name  where colstable.table_name = commentstable.table_name  and colstable.table_name = '" + tableName.toUpperCase() + "'";
            }
            if (CodeResourceUtil.DATABASE_TYPE.equals("postgresql")) {
                sql = MessageFormat.format("SELECT a.attname AS  field,t.typname AS type,col_description(a.attrelid,a.attnum) as comment,null as column_precision,null as column_scale,null as Char_Length,a.attnotnull  FROM pg_class c,pg_attribute  a,pg_type t  WHERE c.relname = {0} and a.attnum > 0  and a.attrelid = c.oid and a.atttypid = t.oid  ORDER BY a.attnum ", TableConvert.getV(tableName.toLowerCase()));
            }
            if (CodeResourceUtil.DATABASE_TYPE.equals("sqlserver")) {
                sql = MessageFormat.format("select cast(a.name as varchar(50)) column_name,  cast(b.name as varchar(50)) data_type,  cast(e.value as varchar(200)) comment,  cast(ColumnProperty(a.object_id,a.Name,'''Precision''') as int) num_precision,  cast(ColumnProperty(a.object_id,a.Name,'''Scale''') as int) num_scale,  a.max_length,  (case when a.is_nullable=1 then '''y''' else '''n''' end) nullable   from sys.columns a left join sys.types b on a.user_type_id=b.user_type_id left join sys.objects c on a.object_id=c.object_id and c.type='''U''' left join sys.extended_properties e on e.major_id=c.object_id and e.minor_id=a.column_id and e.class=1 where c.name={0}", TableConvert.getV(tableName.toLowerCase()));
            }
            rs = stmt.executeQuery(sql);
            rs.last();
            int fieldNum = rs.getRow();
            return fieldNum > 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void formatFieldClassType(ColumnData columnt) {
        String fieldType = columnt.getDataType();
        String scale = columnt.getScale();
        columnt.setClassType("inputxt");
        if ("N".equals(columnt.getNullable())) {
            columnt.setOptionType("*");
        }
        if ("datetime".equals(fieldType) || fieldType.contains("time")) {
            columnt.setClassType("easyui-datetimebox");
        } else if ("date".equals(fieldType)) {
            columnt.setClassType("easyui-datebox");
        } else if (fieldType.contains("int")) {
            columnt.setOptionType("n");
        } else if ("number".equals(fieldType)) {
            if (StringUtils.isNotBlank((String)scale) && Integer.parseInt(scale) > 0) {
                columnt.setOptionType("d");
            }
        } else if ("float".equals(fieldType) || "double".equals(fieldType) || "decimal".equals(fieldType)) {
            columnt.setOptionType("d");
        } else if ("numeric".equals(fieldType)) {
            columnt.setOptionType("d");
        }
    }

    private String formatDataType(String dataType, String precision, String scale) {
        dataType = dataType.contains("char") ? "java.lang.String" : (dataType.contains("int") ? "java.lang.Integer" : (dataType.contains("float") ? "java.lang.Float" : (dataType.contains("double") ? "java.lang.Double" : (dataType.contains("number") ? (StringUtils.isNotBlank((String)scale) && Integer.parseInt(scale) > 0 ? "java.math.BigDecimal" : (StringUtils.isNotBlank((String)precision) && Integer.parseInt(precision) > 10 ? "java.lang.Long" : "java.lang.Integer")) : (dataType.contains("decimal") ? "BigDecimal" : (dataType.contains("date") ? "java.util.Date" : (dataType.contains("time") ? "java.util.Date" : (dataType.contains("blob") ? "byte[]" : (dataType.contains("clob") ? "java.sql.Clob" : (dataType.contains("numeric") ? "BigDecimal" : "java.lang.Object"))))))))));
        return dataType;
    }
}

