/*
 * Copyright 1999-2020 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.nacos.naming.constants;

import java.util.concurrent.TimeUnit;

/**
 * Constants for client.
 *
 * @author xiweng.yy
 */
public class ClientConstants {
    
    public static final String CONNECTION_TYPE = "connectionType";
    
    public static final String CONNECTION_METADATA = "connectionMetadata";
    
    public static final String DEFAULT_FACTORY = "default";
    
    public static final String EPHEMERAL_IP_PORT = "ephemeralIpPort";
    
    public static final String PERSISTENT_IP_PORT = "persistentIpPort";
    
    public static final String REVISION = "revision";
    
    public static final String PERSISTENT_SUFFIX = "false";
    
    public static final String CLIENT_EXPIRED_TIME_CONFIG_KEY = "nacos.naming.client.expired.time";
    
    public static final long DEFAULT_CLIENT_EXPIRED_TIME = TimeUnit.MINUTES.toMillis(3);
    
}
