/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.auto;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jeecgframework.minidao.aspect.EmptyInterceptor;
import org.jeecgframework.minidao.factory.MiniDaoBeanScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Repository;

@Configuration
public class MinidaoAutoConfiguration {
    private static final Log logger = LogFactory.getLog(MinidaoAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={MiniDaoBeanScannerConfigurer.class})
    public MiniDaoBeanScannerConfigurer miniDaoBeanScannerConfigurer(Environment env, ApplicationContext applicationContext) {
        logger.info((Object)" ******************* init miniDao config [ begin ] *********************** ");
        String empty_interceptor = env.getProperty("minidao.empty-interceptor");
        logger.info((Object)(" ------ minidao.base-package ------- " + env.getProperty("minidao.base-package", "*")));
        logger.info((Object)(" ------ minidao.db-type ------------ " + env.getProperty("minidao.db-type", "mysql")));
        logger.info((Object)(" ------ minidao.format-sql --------- " + env.getProperty("minidao.format-sql", "false")));
        logger.info((Object)(" ------ minidao.key-type ----------- " + env.getProperty("minidao.key-type", "origin")));
        logger.info((Object)(" ------ minidao.show-sql ----------- " + env.getProperty("minidao.show-sql", "false")));
        logger.info((Object)(" ------ minidao.empty-interceptor -- " + empty_interceptor));
        MiniDaoBeanScannerConfigurer miniDaoBeanScannerConfigurer = new MiniDaoBeanScannerConfigurer();
        miniDaoBeanScannerConfigurer.setBasePackage(env.getProperty("minidao.base-package", "*"));
        miniDaoBeanScannerConfigurer.setDbType(env.getProperty("minidao.db-type", "mysql"));
        if (empty_interceptor != null && applicationContext.containsBean(empty_interceptor)) {
            miniDaoBeanScannerConfigurer.setEmptyInterceptor((EmptyInterceptor)applicationContext.getBean(empty_interceptor));
        }
        miniDaoBeanScannerConfigurer.setFormatSql(((Boolean)env.getProperty("minidao.format-sql", Boolean.class, (Object)false)).booleanValue());
        miniDaoBeanScannerConfigurer.setKeyType(env.getProperty("minidao.key-type", "origin"));
        miniDaoBeanScannerConfigurer.setShowSql(((Boolean)env.getProperty("minidao.show-sql", Boolean.class, (Object)false)).booleanValue());
        miniDaoBeanScannerConfigurer.setAnnotation(Repository.class);
        logger.info((Object)" *******************  init miniDao config  [ end ] *********************** ");
        return miniDaoBeanScannerConfigurer;
    }
}

