/*
 * Decompiled with CFR 0.152.
 */
package weixin.util.redis;

import com.jeecg.p3.weixinInterface.entity.WeixinAccount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import weixin.util.redis.RedisConvertUtils;
import weixin.util.redis.SerializeUtil;

public class JedisPoolUtil {
    public static final String REDIS_WX_ACCOUNT_LIST_KEY = "RES_KEY_WX_ACCOUNT_MAP";
    public static final String REDIS_WX_SUCAI_LINK_PRE = "RES_KEY_SUCAI_LINK_PRE";
    public static final String REDIS_WX_USER_KEY_PRE = "RES_KEY_WX_USER_PRE";
    private static final Logger logger = Logger.getLogger(JedisPoolUtil.class);
    private static JedisPool pool;

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("redis");
        if (bundle == null) {
            throw new IllegalArgumentException("[redis.properties] is not found!");
        }
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxActive(Integer.valueOf(bundle.getString("redis.pool.maxActive")).intValue());
        config.setMaxIdle(Integer.valueOf(bundle.getString("redis.pool.maxIdle")).intValue());
        config.setMaxWait(Long.valueOf(bundle.getString("redis.pool.maxWait")).longValue());
        config.setTestOnBorrow(Boolean.valueOf(bundle.getString("redis.pool.testOnBorrow")).booleanValue());
        config.setTestOnReturn(Boolean.valueOf(bundle.getString("redis.pool.testOnReturn")).booleanValue());
        pool = bundle.containsKey("redis.password") && !"".equals(bundle.getString("redis.password").trim()) ? new JedisPool((GenericObjectPool.Config)config, bundle.getString("redis.ip"), Integer.valueOf(bundle.getString("redis.port")).intValue(), 100000, bundle.getString("redis.password").trim()) : new JedisPool((GenericObjectPool.Config)config, bundle.getString("redis.ip"), Integer.valueOf(bundle.getString("redis.port")).intValue(), 100000);
    }

    public static Jedis getJedis() {
        return (Jedis)pool.getResource();
    }

    public static void returnJedis(Jedis jedis) {
        pool.returnResource((Object)jedis);
    }

    public static void resetAllWxAccount(Map<String, WeixinAccount> newWxAccountMap) {
        Jedis jedis = (Jedis)pool.getResource();
        jedis.set(REDIS_WX_ACCOUNT_LIST_KEY.getBytes(), SerializeUtil.serialize(newWxAccountMap));
        pool.returnResource((Object)jedis);
    }

    public static void clearReis() {
        Jedis jedis = (Jedis)pool.getResource();
        jedis.del((byte[][])new byte[][]{REDIS_WX_ACCOUNT_LIST_KEY.getBytes()});
        Set s = jedis.keys("RES_KEY_SUCAI_LINK_PRE*");
        for (String key : s) {
            logger.info((Object)("---------------------redis-------------key-------------------" + key));
            jedis.del(new String[]{key});
        }
        pool.returnResource((Object)jedis);
    }

    public static void putWxUser(Map<String, String> userMap) {
        Jedis jedis = (Jedis)pool.getResource();
        String openid = userMap.get("openid");
        String key = REDIS_WX_USER_KEY_PRE + openid;
        jedis.set(key.getBytes(), SerializeUtil.serialize(userMap));
        pool.returnResource((Object)jedis);
    }

    public static Map<String, String> getWxUser(String openid) {
        Jedis jedis = (Jedis)pool.getResource();
        String key = REDIS_WX_USER_KEY_PRE + openid;
        Map returnMap = (Map)SerializeUtil.unserialize(jedis.get(key.getBytes()));
        pool.returnResource((Object)jedis);
        return returnMap;
    }

    public static void putWeixinLinkOutUrl(String outUrl, String id) {
        if (RedisConvertUtils.isNotEmpty(outUrl)) {
            Jedis jedis = (Jedis)pool.getResource();
            String key = REDIS_WX_SUCAI_LINK_PRE + id;
            jedis.set(key, outUrl);
            pool.returnResource((Object)jedis);
        }
    }

    public static String getWeixinLinkOutUrl(String id) {
        if (RedisConvertUtils.isNotEmpty(id)) {
            Jedis jedis = (Jedis)pool.getResource();
            String key = REDIS_WX_SUCAI_LINK_PRE + id;
            String outurl = jedis.get(key);
            pool.returnResource((Object)jedis);
            return outurl;
        }
        return null;
    }

    public static Map<String, WeixinAccount> getAllWxAccount() {
        Jedis jedis = (Jedis)pool.getResource();
        Map wxAccountMap = null;
        wxAccountMap = (Map)SerializeUtil.unserialize(jedis.get(REDIS_WX_ACCOUNT_LIST_KEY.getBytes()));
        pool.returnResource((Object)jedis);
        return wxAccountMap;
    }

    public static void putWxAccount(WeixinAccount po) {
        Jedis jedis = (Jedis)pool.getResource();
        HashMap<String, WeixinAccount> wxAccountMap = (HashMap<String, WeixinAccount>)SerializeUtil.unserialize(jedis.get(REDIS_WX_ACCOUNT_LIST_KEY.getBytes()));
        if (wxAccountMap == null) {
            wxAccountMap = new HashMap<String, WeixinAccount>();
        }
        wxAccountMap.put(po.getWeixinAccountid(), po);
        jedis.set(REDIS_WX_ACCOUNT_LIST_KEY.getBytes(), SerializeUtil.serialize(wxAccountMap));
        pool.returnResource((Object)jedis);
    }

    public static void batchPutWxAccount(List<WeixinAccount> accountList) {
        Jedis jedis = (Jedis)pool.getResource();
        HashMap<String, WeixinAccount> wxAccountMap = (HashMap<String, WeixinAccount>)SerializeUtil.unserialize(jedis.get(REDIS_WX_ACCOUNT_LIST_KEY.getBytes()));
        if (wxAccountMap == null) {
            wxAccountMap = new HashMap<String, WeixinAccount>();
        }
        for (WeixinAccount po : accountList) {
            wxAccountMap.put(po.getWeixinAccountid(), po);
        }
        jedis.set(REDIS_WX_ACCOUNT_LIST_KEY.getBytes(), SerializeUtil.serialize(wxAccountMap));
        pool.returnResource((Object)jedis);
    }

    public static WeixinAccount getWxAccount(String jwid) {
        WeixinAccount po = null;
        try {
            Jedis jedis = (Jedis)pool.getResource();
            Map wxAccountMap = (Map)SerializeUtil.unserialize(jedis.get(REDIS_WX_ACCOUNT_LIST_KEY.getBytes()));
            if (wxAccountMap != null) {
                po = (WeixinAccount)wxAccountMap.get(jwid);
            }
            pool.returnResource((Object)jedis);
        }
        catch (Exception e) {
            logger.error((Object)("--JedisPoolUtil--getWxAccount--error--" + e.toString()));
        }
        return po;
    }

    public static void setList(String key, String ... values) {
        Jedis jedis = (Jedis)pool.getResource();
        jedis.sadd(key, values);
        pool.returnResource((Object)jedis);
    }

    public static boolean exitInList(String key, String value) {
        Jedis jedis = (Jedis)pool.getResource();
        boolean b = jedis.sismember(key, value);
        pool.returnResource((Object)jedis);
        return b;
    }

    public static Object getList(String key) {
        Jedis jedis = (Jedis)pool.getResource();
        Set smembers = jedis.smembers(key);
        pool.returnResource((Object)jedis);
        return smembers;
    }

    public static Long clearList(String key) {
        Jedis jedis = (Jedis)pool.getResource();
        Long i = jedis.del(new String[]{key});
        pool.returnResource((Object)jedis);
        return i;
    }

    public static void main(String[] args) {
        JedisPoolUtil.clearList("ip_list");
        JedisPoolUtil.setList("ip_list", "192.168.0.115", "192.168.0.116", "192.168.0.116");
        System.out.println(JedisPoolUtil.getList("ip_list"));
        JedisPoolUtil.setList("ip_list", "192.168.0.200");
        System.out.println(JedisPoolUtil.getList("ip_list"));
        System.out.println(JedisPoolUtil.exitInList("ip_list", "192.168.0.116"));
    }

    public static void maintest(String[] args) {
        Jedis jedis = (Jedis)pool.getResource();
        WeixinAccount po = new WeixinAccount();
        po.setId("sdfsdf-sdfsdfsdf");
        po.setAccountaccesstoken("100");
        po.setAccountappsecret("200");
        String keys = "name";
        jedis.set(po.getId().getBytes(), SerializeUtil.serialize(po));
        WeixinAccount tt = (WeixinAccount)SerializeUtil.unserialize(jedis.get(po.getId().getBytes()));
        System.out.println(tt.getAccountaccesstoken());
        pool.returnResource((Object)jedis);
    }
}

