/*
 * Decompiled with CFR 0.152.
 */
package org.jeewx.api.report.datastatistics.useranalysis;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.core.req.WeiXinReqService;
import org.jeewx.api.core.req.model.dataCube.WxDataCubeStreamUserCumulateParam;
import org.jeewx.api.core.req.model.dataCube.WxDataCubeStreamUserSummaryParam;
import org.jeewx.api.report.datastatistics.useranalysis.model.UserAnalysisRtnInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwUserAnalysisAPI {
    private static Logger logger = LoggerFactory.getLogger(JwUserAnalysisAPI.class);

    private static Long getDays(String Date1, String Date2) {
        return Date.valueOf(Date1).getTime() / 86400000L - Date.valueOf(Date2).getTime() / 86400000L;
    }

    public static List<UserAnalysisRtnInfo> getUserSummary(String accesstoken, String begin_date, String end_date) throws WexinReqException {
        if (accesstoken != null) {
            if (JwUserAnalysisAPI.getDays(end_date, begin_date) >= 7L) {
                logger.error("\u4f20\u5165\u7684\u65e5\u671f\u95f4\u9694\u5927\u4e8e7\u5929");
                return null;
            }
            WxDataCubeStreamUserSummaryParam userAnalysis = new WxDataCubeStreamUserSummaryParam();
            userAnalysis.setAccess_token(accesstoken);
            userAnalysis.setBegin_date(begin_date);
            userAnalysis.setEnd_date(end_date);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(userAnalysis);
            ArrayList<UserAnalysisRtnInfo> userAnalysisRtnInfoList = new ArrayList<UserAnalysisRtnInfo>();
            Object error = result.get("errcode");
            JSONArray array = null;
            UserAnalysisRtnInfo userAnalysisRtnInfo = null;
            array = (JSONArray)result.get("list");
            for (Object object : array) {
                userAnalysisRtnInfo = (UserAnalysisRtnInfo)JSONObject.toBean((JSONObject)((JSONObject)object), UserAnalysisRtnInfo.class);
                userAnalysisRtnInfoList.add(userAnalysisRtnInfo);
            }
            return userAnalysisRtnInfoList;
        }
        return null;
    }

    public static List<UserAnalysisRtnInfo> getUserCumulate(String accesstoken, String begin_date, String end_date) throws WexinReqException {
        if (accesstoken != null) {
            if (JwUserAnalysisAPI.getDays(end_date, begin_date) >= 7L) {
                logger.error("\u4f20\u5165\u7684\u65e5\u671f\u95f4\u9694\u5927\u4e8e7\u5929");
                return null;
            }
            WxDataCubeStreamUserCumulateParam userCumulate = new WxDataCubeStreamUserCumulateParam();
            userCumulate.setAccess_token(accesstoken);
            userCumulate.setBegin_date(begin_date);
            userCumulate.setEnd_date(end_date);
            JSONObject result = WeiXinReqService.getInstance().doWeinxinReqJson(userCumulate);
            ArrayList<UserAnalysisRtnInfo> userAnalysisRtnInfoList = new ArrayList<UserAnalysisRtnInfo>();
            Object error = result.get("errcode");
            JSONArray array = null;
            UserAnalysisRtnInfo userAnalysisRtnInfo = null;
            array = (JSONArray)result.get("list");
            for (Object object : array) {
                userAnalysisRtnInfo = (UserAnalysisRtnInfo)JSONObject.toBean((JSONObject)((JSONObject)object), UserAnalysisRtnInfo.class);
                userAnalysisRtnInfoList.add(userAnalysisRtnInfo);
            }
            return userAnalysisRtnInfoList;
        }
        return null;
    }
}

