/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.imports;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelCollectionParams;
import org.jeecgframework.poi.excel.entity.params.ExcelImportEntity;
import org.jeecgframework.poi.excel.entity.result.ExcelImportResult;
import org.jeecgframework.poi.excel.entity.result.ExcelVerifyHanlderResult;
import org.jeecgframework.poi.excel.imports.CellValueServer;
import org.jeecgframework.poi.excel.imports.base.ImportBaseService;
import org.jeecgframework.poi.excel.imports.verifys.VerifyHandlerServer;
import org.jeecgframework.poi.exception.excel.ExcelImportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelImportEnum;
import org.jeecgframework.poi.util.ExcelUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportServer
extends ImportBaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportServer.class);
    private CellValueServer cellValueServer = new CellValueServer();
    private VerifyHandlerServer verifyHandlerServer = new VerifyHandlerServer();
    private boolean verfiyFail = false;
    private CellStyle errorCellStyle;

    private void addListContinue(Object object, ExcelCollectionParams param, Row row, Map<Integer, String> titlemap, String targetId, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        Collection collection = (Collection)PoiPublicUtil.getMethod(param.getName(), object.getClass()).invoke(object, new Object[0]);
        Object entity = PoiPublicUtil.createObject(param.getType(), targetId);
        boolean isUsed = false;
        for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            String titleString = titlemap.get(i);
            if (!param.getExcelParams().containsKey(titleString)) continue;
            if (param.getExcelParams().get(titleString).getType() == 2) {
                String picId = row.getRowNum() + "_" + i;
                this.saveImage(object, picId, param.getExcelParams(), titleString, pictures, params);
            } else {
                this.saveFieldValue(params, entity, cell, param.getExcelParams(), titleString, row);
            }
            isUsed = true;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private String getKeyValue(Cell cell) {
        Object obj = null;
        switch (cell.getCellType()) {
            case 1: {
                obj = cell.getStringCellValue();
                break;
            }
            case 4: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case 0: {
                obj = cell.getNumericCellValue();
                break;
            }
            case 2: {
                obj = cell.getCellFormula();
            }
        }
        return obj == null ? null : obj.toString().trim();
    }

    private String getSaveUrl(ExcelImportEntity excelImportEntity, Object object) throws Exception {
        String url = "";
        if (excelImportEntity.getSaveUrl().equals("upload")) {
            if (excelImportEntity.getMethods() != null && excelImportEntity.getMethods().size() > 0) {
                object = this.getFieldBySomeMethod(excelImportEntity.getMethods(), object);
            }
            url = object.getClass().getName().split("\\.")[object.getClass().getName().split("\\.").length - 1];
            return excelImportEntity.getSaveUrl() + "/" + url.substring(0, url.lastIndexOf("Entity"));
        }
        return excelImportEntity.getSaveUrl();
    }

    private <T> List<T> importExcel(Collection<T> result, Sheet sheet, Class<?> pojoClass, ImportParams params, Map<String, PictureData> pictures) throws Exception {
        ArrayList<Object> collection = new ArrayList<Object>();
        HashMap<String, ExcelImportEntity> excelParams = new HashMap<String, ExcelImportEntity>();
        ArrayList<ExcelCollectionParams> excelCollection = new ArrayList<ExcelCollectionParams>();
        String targetId = null;
        if (!Map.class.equals(pojoClass)) {
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            if (etarget != null) {
                targetId = etarget.value();
            }
            this.getAllExcelField(targetId, fileds, excelParams, excelCollection, pojoClass, null);
        }
        Iterator rows = sheet.rowIterator();
        Map<Integer, String> titlemap = this.getTitleMap(sheet, rows, params, excelCollection);
        Row row = null;
        for (int j = 0; j < params.getTitleRows() + params.getHeadRows(); ++j) {
            row = (Row)rows.next();
        }
        Object object = null;
        while (rows.hasNext() && (row == null || sheet.getLastRowNum() - row.getRowNum() > params.getLastOfInvalidRow())) {
            row = (Row)rows.next();
            if ((row.getCell(params.getKeyIndex()) == null || StringUtils.isEmpty((CharSequence)this.getKeyValue(row.getCell(params.getKeyIndex())))) && object != null && !Map.class.equals(pojoClass)) {
                for (ExcelCollectionParams param : excelCollection) {
                    this.addListContinue(object, param, row, titlemap, targetId, pictures, params);
                }
                continue;
            }
            object = PoiPublicUtil.createObject(pojoClass, targetId);
            try {
                short le = row.getLastCellNum();
                for (int i = row.getFirstCellNum(); i < le; ++i) {
                    Cell cell = row.getCell(i);
                    String titleString = titlemap.get(i);
                    if (!excelParams.containsKey(titleString) && !Map.class.equals(pojoClass)) continue;
                    if (excelParams.get(titleString) != null && ((ExcelImportEntity)excelParams.get(titleString)).getType() == 2) {
                        String picId = row.getRowNum() + "_" + i;
                        this.saveImage(object, picId, excelParams, titleString, pictures, params);
                        continue;
                    }
                    this.saveFieldValue(params, object, cell, excelParams, titleString, row);
                }
                for (ExcelCollectionParams param : excelCollection) {
                    this.addListContinue(object, param, row, titlemap, targetId, pictures, params);
                }
                collection.add(object);
            }
            catch (ExcelImportException e) {
                if (e.getType().equals((Object)ExcelImportEnum.VERIFY_ERROR)) continue;
                throw new ExcelImportException(e.getType(), (Throwable)e);
            }
        }
        return collection;
    }

    private Map<Integer, String> getTitleMap(Sheet sheet, Iterator<Row> rows, ImportParams params, List<ExcelCollectionParams> excelCollection) {
        HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
        Iterator cellTitle = null;
        String collectionName = null;
        Object collectionParams = null;
        Row headRow = null;
        int headBegin = params.getTitleRows();
        while (headRow == null) {
            headRow = sheet.getRow(headBegin++);
        }
        if (ExcelUtil.isMergedRegion(sheet, headRow.getRowNum(), 0)) {
            params.setHeadRows(2);
        } else {
            params.setHeadRows(1);
        }
        cellTitle = headRow.cellIterator();
        while (cellTitle.hasNext()) {
            Cell cell = (Cell)cellTitle.next();
            String value = this.getKeyValue(cell);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            titlemap.put(cell.getColumnIndex(), value);
        }
        for (int j = headBegin; j < headBegin + params.getHeadRows() - 1; ++j) {
            headRow = sheet.getRow(j);
            cellTitle = headRow.cellIterator();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = this.getKeyValue(cell);
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                int columnIndex = cell.getColumnIndex();
                if (ExcelUtil.isMergedRegion(sheet, cell.getRowIndex() - 1, columnIndex)) {
                    collectionName = ExcelUtil.getMergedRegionValue(sheet, cell.getRowIndex() - 1, columnIndex);
                    titlemap.put(cell.getColumnIndex(), collectionName + "_" + value);
                    continue;
                }
                titlemap.put(cell.getColumnIndex(), value);
            }
        }
        return titlemap;
    }

    private ExcelCollectionParams getCollectionParams(List<ExcelCollectionParams> excelCollection, String collectionName) {
        for (ExcelCollectionParams excelCollectionParams : excelCollection) {
            if (!collectionName.equals(excelCollectionParams.getExcelName())) continue;
            return excelCollectionParams;
        }
        return null;
    }

    public ExcelImportResult importExcelByIs(InputStream inputstream, Class<?> pojoClass, ImportParams params) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel import start ,class is {}", pojoClass);
        }
        ArrayList result = new ArrayList();
        HSSFWorkbook book = null;
        boolean isXSSFWorkbook = true;
        if (!inputstream.markSupported()) {
            inputstream = new PushbackInputStream(inputstream, 8);
        }
        if (POIFSFileSystem.hasPOIFSHeader((InputStream)inputstream)) {
            book = new HSSFWorkbook(inputstream);
            isXSSFWorkbook = false;
        } else if (POIXMLDocument.hasOOXMLHeader((InputStream)inputstream)) {
            book = new XSSFWorkbook(OPCPackage.open((InputStream)inputstream));
        }
        this.createErrorCellStyle((Workbook)book);
        for (int i = 0; i < params.getSheetNum(); ++i) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" start to read excel by is ,startTime is {}", (Object)new Date().getTime());
            }
            Map<String, PictureData> pictures = isXSSFWorkbook ? PoiPublicUtil.getSheetPictrues07((XSSFSheet)book.getSheetAt(i), (XSSFWorkbook)book) : PoiPublicUtil.getSheetPictrues03((HSSFSheet)book.getSheetAt(i), book);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" end to read excel by is ,endTime is {}", (Object)new Date().getTime());
            }
            result.addAll(this.importExcel(result, book.getSheetAt(i), pojoClass, params, pictures));
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(" end to read excel list by pos ,endTime is {}", (Object)new Date().getTime());
        }
        if (params.isNeedSave()) {
            this.saveThisExcel(params, pojoClass, isXSSFWorkbook, (Workbook)book);
        }
        return new ExcelImportResult(result, this.verfiyFail, (Workbook)book);
    }

    private void saveFieldValue(ImportParams params, Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString, Row row) throws Exception {
        Object value = this.cellValueServer.getValue(params.getDataHanlder(), object, cell, excelParams, titleString);
        if (object instanceof Map) {
            if (params.getDataHanlder() != null) {
                params.getDataHanlder().setMapValue((Map)object, titleString, value);
            } else {
                ((Map)object).put(titleString, value);
            }
        } else {
            ExcelVerifyHanlderResult verifyResult = this.verifyHandlerServer.verifyData(object, value, titleString, excelParams.get(titleString).getVerify(), params.getVerifyHanlder());
            if (verifyResult.isSuccess()) {
                this.setValues(excelParams.get(titleString), object, value);
            } else {
                Cell errorCell = row.createCell((int)row.getLastCellNum());
                errorCell.setCellValue(verifyResult.getMsg());
                errorCell.setCellStyle(this.errorCellStyle);
                this.verfiyFail = true;
                throw new ExcelImportException(ExcelImportEnum.VERIFY_ERROR);
            }
        }
    }

    private void saveImage(Object object, String picId, Map<String, ExcelImportEntity> excelParams, String titleString, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        if (pictures == null) {
            return;
        }
        PictureData image = pictures.get(picId);
        if (image == null) {
            return;
        }
        byte[] data = image.getData();
        String fileName = "pic" + Math.round(Math.random() * 1.0E11);
        fileName = fileName + "." + PoiPublicUtil.getFileExtendName(data);
        if (excelParams.get(titleString).getSaveType() == 1) {
            String path = PoiPublicUtil.getWebRootPath(this.getSaveUrl(excelParams.get(titleString), object));
            File savefile = new File(path);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            savefile = new File(path + "/" + fileName);
            FileOutputStream fos = new FileOutputStream(savefile);
            fos.write(data);
            fos.close();
            this.setValues(excelParams.get(titleString), object, this.getSaveUrl(excelParams.get(titleString), object) + "/" + fileName);
        } else {
            this.setValues(excelParams.get(titleString), object, data);
        }
    }

    private void createErrorCellStyle(Workbook workbook) {
        this.errorCellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setColor((short)10);
        this.errorCellStyle.setFont(font);
    }
}

