/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.aop;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.jeecgframework.core.annotation.Ehcache;
import org.jeecgframework.core.aop.LOCALMAC;
import org.jeecgframework.core.aop.pp;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import weixin.guanjia.core.util.MyX509TrustManager;

public class JavaMUtil {
    private static final String domain = "http://www.jeewx.com/jeewx";
    private static String netLic;
    private static String local_mac;
    public static boolean lic_flag;

    static {
        lic_flag = Boolean.FALSE;
    }

    public static void insertMsg() {
        try {
            String osname = JavaMUtil.getOSName();
            String ip = oConvertUtils.getRealIp();
            String mac = JavaMUtil.getMa();
            String url = "http://www.jeewx.com/jeewx/licController.do?saveJeecgServer&ip=" + ip + "&mac=" + mac + "&osname=" + osname;
            JavaMUtil.httpCommonRequest(url, "GET", "");
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        System.out.println(JavaMUtil.getssss());
    }

    @Ehcache
    public static String getssss() {
        String ss = "";
        if (oConvertUtils.isEmpty((Object)JavaMUtil.getMa())) {
            return null;
        }
        ss = String.valueOf(JavaMUtil.getMa()) + JavaMUtil.getLicTime() + JavaMUtil.getNetLic();
        return pp.getMD5Str(ss);
    }

    private static String getLicTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy");
        String year = df.format(new Date());
        return year;
    }

    private static String getNetLic() {
        String net_licence_key = "20150402";
        try {
            net_licence_key = ResourceUtil.getConfigByName((String)"net.licence.key");
            if (oConvertUtils.isNotEmpty((Object)netLic)) {
                return netLic;
            }
            String url = "http://www.jeewx.com/jeewx/licController.do?getLicKey";
            String jsonObj = JavaMUtil.httpCommonRequest(url, "GET", "");
            if (oConvertUtils.isNotEmpty((Object)jsonObj) && jsonObj.indexOf("licenseKey") > 0) {
                Gson gson = new Gson();
                Map mp = (Map)gson.fromJson(jsonObj, Map.class);
                net_licence_key = (String)mp.get("licenseKey");
            }
            netLic = net_licence_key;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return net_licence_key;
    }

    private static String getMa() {
        return LOCALMAC.getMacAddress();
    }

    private static String getMaOld() {
        if (oConvertUtils.isNotEmpty((Object)local_mac)) {
            return local_mac;
        }
        String os = JavaMUtil.getOSName();
        String execStr = String.valueOf(JavaMUtil.getSystemRoot()) + "/system32/ipconfig /all";
        String mac = null;
        mac = os.startsWith("windows") ? (os.equals("windows xp") ? JavaMUtil.getWindowXPMa(execStr) : (os.equals("windows 2003") ? JavaMUtil.getWindowXPMa(execStr) : JavaMUtil.getWindow7Ma())) : (os.startsWith("linux") ? JavaMUtil.getLinuxMa() : JavaMUtil.getUnixMa());
        local_mac = mac;
        return mac;
    }

    private static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    private static String getWindowXPMa(String execStr) {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec(execStr);
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                int index = -1;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.indexOf("\u672c\u5730\u8fde\u63a5") != -1 || (index = line.toLowerCase().indexOf("physical address")) == -1) continue;
                    index = line.indexOf(":");
                    if (index != -1) {
                        mac = line.substring(index + 1).trim();
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                bufferedReader = null;
                process = null;
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    private static String getWindow7Ma() {
        InetAddress ia = null;
        try {
            ia = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        byte[] mac = null;
        try {
            mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < mac.length) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? String.valueOf(0) + s : s);
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    private static String getLinuxMa() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec("ifconfig eth0");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                int index = -1;
                while ((line = bufferedReader.readLine()) != null) {
                    index = line.toLowerCase().indexOf("\u786c\u4ef6\u5730\u5740");
                    if (index == -1) continue;
                    mac = line.substring(index + 4).trim();
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                bufferedReader = null;
                process = null;
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    private static String getUnixMa() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec("ifconfig eth0");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                int index = -1;
                while ((line = bufferedReader.readLine()) != null) {
                    index = line.toLowerCase().indexOf("hwaddr");
                    if (index == -1) continue;
                    mac = line.substring(index + "hwaddr".length() + 1).trim();
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                bufferedReader = null;
                process = null;
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    private static String getSystemRoot() {
        String cmd = null;
        String os = null;
        String result = null;
        String envName = "windir";
        os = System.getProperty("os.name").toLowerCase();
        cmd = os.startsWith("windows") ? "cmd /c SET" : "env";
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader commandResult = new BufferedReader(isr);
            String line = null;
            while ((line = commandResult.readLine()) != null) {
                if ((line = line.toLowerCase()).indexOf(envName) <= -1) continue;
                result = line.substring(line.indexOf(envName) + envName.length() + 1);
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String httpCommonRequest(String requestUrl, String requestMethod, String outputStr) {
        Object jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setConnectTimeout(4500);
            httpUrlConn.setReadTimeout(4500);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (outputStr != null) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
        }
        catch (ConnectException connectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer.toString();
    }
}

