/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.aop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jeecgframework.core.aop.JavaMUtil;
import org.jeecgframework.core.aop.ResMime;
import org.jeecgframework.core.aop.Wrapper;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.springframework.util.FileCopyUtils;

public class GZipFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(GZipFilter.class);
    private static final String STATIC_SOURCE_ROOT = "/";
    private static final String DIAN = ".";
    private static final String NO_FILTER = ".do";

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)res;
        HttpServletRequest req = (HttpServletRequest)request;
        String url = req.getRequestURI();
        String path = req.getContextPath();
        String basePath = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + path;
        try {
            if (!JavaMUtil.lic_flag) {
                if (GZipFilter.compareNowDate()) {
                    String licence = ResourceUtil.getConfigByName((String)"licence");
                    if (url.indexOf("licence") == -1 && url.indexOf("licController.do") == -1 && JavaMUtil.getssss() != null && !StringUtil.contains((String[])licence.split(","), (String)JavaMUtil.getssss())) {
                        HttpSession session = req.getSession(true);
                        try {
                            response.setContentType("text/html;charset=UTF-8");
                            response.setHeader("Cache-Control", "no-store");
                            PrintWriter pw = response.getWriter();
                            pw.write(new FreemarkerHelper().parseTemplate("org/jeecgframework/core/aop/licence.ftl", null));
                            pw.flush();
                            return;
                        }
                        catch (IOException e) {
                        }
                    } else if (url.indexOf("licence") == -1 && url.indexOf("licController.do") == -1 && StringUtil.contains((String[])licence.split(","), (String)JavaMUtil.getssss())) {
                        JavaMUtil.lic_flag = Boolean.TRUE;
                    }
                } else {
                    JavaMUtil.lic_flag = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            try {
                response.setContentType("text/html;charset=UTF-8");
                response.setHeader("Cache-Control", "no-store");
                PrintWriter pw = response.getWriter();
                pw.write(new FreemarkerHelper().parseTemplate("org/jeecgframework/core/aop/licence.ftl", null));
                pw.flush();
                return;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (req.getRequestURI().indexOf(STATIC_SOURCE_ROOT) != -1 && req.getRequestURI().indexOf(DIAN) != -1 && req.getRequestURI().indexOf(NO_FILTER) == -1) {
            url = url.replaceFirst(req.getContextPath(), "");
            response.reset();
            String s = ResMime.get(url.substring(url.lastIndexOf(DIAN)).replace(DIAN, ""));
            if (s != null) {
                response.setContentType(s);
            }
            OutputStream os = null;
            InputStream is = null;
            try {
                url = url.replaceFirst(req.getContextPath(), "");
                is = this.getClass().getResourceAsStream(url);
                if (is != null) {
                    os = response.getOutputStream();
                    FileCopyUtils.copy((InputStream)is, (OutputStream)os);
                }
                chain.doFilter(request, (ServletResponse)response);
            }
            catch (IOException e) {
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else if (req.getRequestURI().indexOf("ReportServer") != -1) {
            chain.doFilter(request, (ServletResponse)response);
        } else if (GZipFilter.isGZipEncoding(req)) {
            Wrapper wrapper = new Wrapper(response);
            chain.doFilter(request, (ServletResponse)wrapper);
            byte[] gzipData = this.gzip(wrapper.getResponseData());
            response.addHeader("Content-Encoding", "gzip");
            response.setContentLength(gzipData.length);
            ServletOutputStream output = response.getOutputStream();
            output.write(gzipData);
            output.flush();
        } else {
            chain.doFilter(request, (ServletResponse)response);
        }
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void CacheResource(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String uri = req.getRequestURI();
        uri = uri.substring(uri.lastIndexOf(DIAN) + 1);
        LogUtil.info((Object)uri);
        long date = 0L;
        if (uri.equalsIgnoreCase("jpg")) {
            date = System.currentTimeMillis() + 18000000L;
        }
        if (uri.equalsIgnoreCase("gif")) {
            date = System.currentTimeMillis() + 18000000L;
        }
        if (uri.equalsIgnoreCase("css")) {
            date = System.currentTimeMillis() + 18000000L;
        }
        if (uri.equalsIgnoreCase("js")) {
            date = System.currentTimeMillis() + 18000000L;
        }
        res.setDateHeader("Expires", date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] gzip(byte[] data) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(10240);
        GZIPOutputStream output = null;
        try {
            output = new GZIPOutputStream(byteOutput);
            output.write(data);
        }
        catch (IOException e) {
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {}
        }
        return byteOutput.toByteArray();
    }

    private static boolean isGZipEncoding(HttpServletRequest request) {
        boolean flag = false;
        String encoding = request.getHeader("Accept-Encoding");
        if (encoding != null && encoding.indexOf("gzip") != -1) {
            flag = true;
        }
        return flag;
    }

    private static boolean compareNowDate() {
        Date nowdate = new Date();
        String myString = "2015-04-18";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        Date d = null;
        try {
            d = sdf.parse(myString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean flag = d.before(nowdate);
        return flag;
    }

    public static void main(String[] args) {
        System.out.println(GZipFilter.compareNowDate());
    }
}

