/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.core.aop;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecgframework.core.annotation.Ehcache;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class EhcacheAspect {
    private static Cache dictCache;
    private static Cache eternalCache;

    @Pointcut(value="@annotation(org.jeecgframework.core.annotation.Ehcache)")
    public void simplePointcut() {
    }

    @AfterReturning(pointcut="simplePointcut()")
    public void simpleAdvice() {
    }

    @Around(value="simplePointcut()")
    public Object aroundLogCalls(ProceedingJoinPoint joinPoint) throws Throwable {
        String targetName = joinPoint.getTarget().getClass().toString();
        String methodName = joinPoint.getSignature().getName();
        Object[] arguments = joinPoint.getArgs();
        Method[] methods = joinPoint.getTarget().getClass().getMethods();
        Ehcache flag = null;
        for (Method m : methods) {
            Class<?>[] tmpCs;
            if (!m.getName().equals(methodName) || (tmpCs = m.getParameterTypes()).length != arguments.length) continue;
            flag = m.getAnnotation(Ehcache.class);
            break;
        }
        if (flag == null) {
            return null;
        }
        String cacheKey = this.getCacheKey(targetName, methodName, arguments);
        Element element = null;
        element = flag.eternal() ? dictCache.get((Serializable)((Object)cacheKey)) : eternalCache.get((Serializable)((Object)cacheKey));
        if (element == null) {
            Object result = arguments != null && arguments.length != 0 ? joinPoint.proceed(arguments) : joinPoint.proceed();
            element = new Element((Serializable)((Object)cacheKey), (Serializable)result);
            if (flag.eternal()) {
                dictCache.put(element);
            } else {
                eternalCache.put(element);
            }
        }
        return element.getValue();
    }

    private String getCacheKey(String targetName, String methodName, Object[] arguments) {
        StringBuffer sb = new StringBuffer();
        sb.append(targetName).append(".").append(methodName);
        if (arguments != null && arguments.length != 0) {
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(".").append(JSON.toJSONString((Object)arguments[i]));
            }
        }
        return sb.toString();
    }

    static {
        if (eternalCache == null) {
            eternalCache = CacheManager.getInstance().getCache("eternalCache");
        }
        if (dictCache == null) {
            dictCache = CacheManager.getInstance().getCache("dictCache");
        }
    }
}

