/**
 * Copyright 2013-2015 JueYue (qrb.jueyue@gmail.com)
 *   
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jeecgframework.poi.excel.entity.params;

import java.util.List;

/**
 * 合并单元格使用对象
 *
 * Created by jue on 14-6-11.
 */
public class MergeEntity {
    /**
     * 合并开始行
     */
    private int          startRow;
    /**
     * 合并结束行
     */
    private int          endRow;
    /**
     * 文字
     */
    private String       text;
    /**
     * 依赖关系文本
     */
    private List<String> relyList;

    public MergeEntity() {

    }

    public MergeEntity(String text, int startRow, int endRow) {
        this.text = text;
        this.endRow = endRow;
        this.startRow = startRow;
    }

    public int getEndRow() {
        return endRow;
    }

    public List<String> getRelyList() {
        return relyList;
    }

    public int getStartRow() {
        return startRow;
    }

    public String getText() {
        return text;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public void setRelyList(List<String> relyList) {
        this.relyList = relyList;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setText(String text) {
        this.text = text;
    }
}
