/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.airag.flow.c;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yomahub.liteflow.core.FlowExecutor;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.springboot.LiteflowProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.AssertUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.config.shiro.IgnoreAuth;
import org.jeecg.modules.airag.flow.entity.AiragFlow;
import org.jeecg.modules.airag.flow.service.IAiragFlowAiGenService;
import org.jeecg.modules.airag.flow.service.IAiragFlowExportService;
import org.jeecg.modules.airag.flow.service.IAiragFlowService;
import org.jeecg.modules.airag.flow.vo.api.AigcTestDataParams;
import org.jeecg.modules.airag.flow.vo.api.FlowDebugParams;
import org.jeecg.modules.airag.flow.vo.api.FlowDesignParams;
import org.jeecg.modules.airag.flow.vo.api.FlowRunParams;
import org.jeecg.modules.airag.flow.vo.api.SubFlowResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="AiRag\u6d41\u7a0b")
@RestController(value="airagFlowController")
@RequestMapping(value={"/airag/flow"})
public class a
extends JeecgController<AiragFlow, IAiragFlowService> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    private IAiragFlowService airagFlowService;
    @Autowired
    private IAiragFlowAiGenService airagFlowAiGenService;
    @Autowired
    LiteflowProperty liteflowProperty;
    @Autowired
    FlowExecutor flowExecutor;
    @Autowired
    IAiragFlowExportService airagFlowExportService;

    @GetMapping(value={"/list"})
    public Result<IPage<AiragFlow>> a(AiragFlow airagFlow, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)airagFlow, (Map)req.getParameterMap());
        queryWrapper.select((Object[])new String[]{"id", "application_name", "name", "descr", "icon", "status", "metadata", "create_time", "update_time"});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.airagFlowService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"airag:flow:add"})
    public Result<String> a(@RequestBody AiragFlow airagFlow) {
        Map ruleSourceExtDataMap = this.liteflowProperty.getRuleSourceExtDataMap();
        String appName = "jeecg";
        if (null != ruleSourceExtDataMap) {
            appName = oConvertUtils.getString((String)((String)ruleSourceExtDataMap.get("applicationName")), (String)"jeecg");
        }
        airagFlow.setApplicationName(appName);
        airagFlow.setStatus("enable");
        this.airagFlowService.save(airagFlow);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)airagFlow.getId());
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    @RequiresPermissions(value={"airag:flow:edit"})
    public Result<String> b(@RequestBody AiragFlow airagFlow) {
        AiragFlow existsFlow = (AiragFlow)this.airagFlowService.getById((Serializable)((Object)airagFlow.getId()));
        AssertUtils.assertNotEmpty((String)"\u6d41\u7a0b\u4e0d\u5b58\u5728", (Object)existsFlow);
        airagFlow.setChain(null);
        airagFlow.setDesign(null);
        airagFlow.setApplicationName(null);
        this.airagFlowService.updateById(airagFlow);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @RequestMapping(value={"/design/save"}, method={RequestMethod.PUT, RequestMethod.POST})
    @RequiresPermissions(value={"airag:flow:designSave"})
    public Result<String> a(@RequestBody FlowDesignParams flowDesignParams) {
        return this.airagFlowService.saveDesign(flowDesignParams);
    }

    @DeleteMapping(value={"/delete"})
    @RequiresPermissions(value={"airag:flow:delete"})
    public Result<String> a(HttpServletRequest request, @RequestParam(name="id", required=true) String id) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            AiragFlow flow = (AiragFlow)this.airagFlowService.getById((Serializable)((Object)id));
            String currentTenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)request);
            if (null == flow || !flow.getTenantId().equals(currentTenantId)) {
                return Result.error((String)"\u5220\u9664AI\u6d41\u7a0b\u5931\u8d25\uff0c\u4e0d\u80fd\u5220\u9664\u5176\u4ed6\u79df\u6237\u7684AI\u6d41\u7a0b\uff01");
            }
        }
        FlowBus.removeChain((String)id);
        this.airagFlowService.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @GetMapping(value={"/queryById"})
    public Result<AiragFlow> a(@RequestParam(name="id", required=true) String id) {
        AiragFlow airagFlow = (AiragFlow)this.airagFlowService.getById((Serializable)((Object)id));
        if (airagFlow == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)airagFlow);
    }

    @GetMapping(value={"/subflowList"})
    public Result<IPage<SubFlowResult>> a(@RequestParam(name="id", required=false) String id, @RequestParam(name="keywords", required=false) String keywords, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SubFlowResult> result = this.airagFlowService.subflowPage((IPage<AiragFlow>)page, id, keywords);
        return Result.OK(result);
    }

    @GetMapping(value={"/querySubflowById"})
    public Result<SubFlowResult> b(@RequestParam(name="subflowId") String subflowId) {
        SubFlowResult result = this.airagFlowService.querySubflowById(subflowId);
        return Result.OK((Object)result);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView a(HttpServletRequest request, AiragFlow airagFlow) {
        return super.exportXls(request, (Object)airagFlow, AiragFlow.class, "AiRag\u6d41\u7a0b");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> a(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, AiragFlow.class);
    }

    @PostMapping(value={"/debug"})
    public Object a(@RequestBody FlowDebugParams flowDebugParams) {
        return this.airagFlowService.debugFlow(flowDebugParams);
    }

    @IgnoreAuth
    @PostMapping(value={"/run"})
    public Object a(@RequestBody FlowRunParams flowRunParams) {
        return this.airagFlowService.runFlow(flowRunParams);
    }

    @IgnoreAuth
    @GetMapping(value={"/run/{flowId}"})
    public Object a(@PathVariable(name="flowId") String flowId, HttpServletRequest request) {
        FlowRunParams flowRunParams = new FlowRunParams();
        flowRunParams.setFlowId(flowId);
        flowRunParams.setResponseMode("blocking");
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values.length == 1) {
                inputParams.put(key, values[0]);
                continue;
            }
            inputParams.put(key, values);
        }
        flowRunParams.setInputParams(inputParams);
        return this.airagFlowService.runFlow(flowRunParams);
    }

    @PostMapping(value={"/aigc/test-data"})
    public Result<?> a(@RequestBody AigcTestDataParams params) {
        return this.airagFlowAiGenService.genTestData(params);
    }

    @GetMapping(value={"/exportFlow/{flowId}/{izExportAppKey}"})
    public Result<String> a(@PathVariable(name="flowId") String flowId, @PathVariable(name="izExportAppKey") Integer izExportAppKey, HttpServletRequest request) {
        String flowData = this.airagFlowExportService.exportFlow(flowId, izExportAppKey);
        return Result.ok((String)flowData);
    }

    @PostMapping(value={"/importFlow"})
    public Result<String> a(@RequestParam(value="file") MultipartFile file, HttpServletRequest request) {
        this.airagFlowExportService.importFlow(file);
        return Result.ok((String)"\u5bfc\u5165\u6210\u529f");
    }
}

