/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.shardingsphere.config;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.provider.AbstractDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

@Configuration
@AutoConfigureBefore(value={DynamicDataSourceAutoConfiguration.class, SpringBootConfiguration.class})
public class DataSourceConfiguration {
    public static final String SHARDING_DATA_SOURCE_NAME = "sharding";
    @Resource
    private DynamicDataSourceProperties dynamicDataSourceProperties;
    @Lazy
    @Resource
    DataSource shardingDataSource;
    @Lazy
    @Resource
    DefaultDataSourceCreator dataSourceCreator;

    @Bean
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        final Map datasourceMap = this.dynamicDataSourceProperties.getDatasource();
        return new AbstractDataSourceProvider(this.dataSourceCreator){

            public Map<String, DataSource> loadDataSources() {
                Map dataSourceMap = this.createDataSourceMap(datasourceMap);
                dataSourceMap.put(DataSourceConfiguration.SHARDING_DATA_SOURCE_NAME, DataSourceConfiguration.this.shardingDataSource);
                return dataSourceMap;
            }
        };
    }

    @Primary
    @Bean
    public DataSource dataSource(DynamicDataSourceProvider dynamicDataSourceProvider) {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(this.dynamicDataSourceProperties.getPrimary());
        dataSource.setStrict(this.dynamicDataSourceProperties.getStrict());
        dataSource.setStrategy(this.dynamicDataSourceProperties.getStrategy());
        dataSource.setP6spy(this.dynamicDataSourceProperties.getP6spy());
        dataSource.setSeata(this.dynamicDataSourceProperties.getSeata());
        return dataSource;
    }
}

