/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.boot.starter.lock.aspect;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.boot.starter.lock.annotation.JRepeat;
import org.jeecg.boot.starter.lock.aspect.BaseAspect;
import org.jeecg.boot.starter.lock.client.RedissonLockClient;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RepeatSubmitAspect
extends BaseAspect {
    @Resource
    private RedissonLockClient redissonLockClient;

    @Pointcut(value="@annotation(jRepeat)")
    public void pointCut(JRepeat jRepeat) {
    }

    @Around(value="pointCut(jRepeat)")
    public Object repeatSubmit(ProceedingJoinPoint joinPoint, JRepeat jRepeat) throws Throwable {
        String[] parameterNames = new LocalVariableTableParameterNameDiscoverer().getParameterNames(((MethodSignature)joinPoint.getSignature()).getMethod());
        if (Objects.nonNull(jRepeat)) {
            Object[] args = joinPoint.getArgs();
            StringBuffer lockKeyBuffer = new StringBuffer();
            String key = this.getValueBySpEL(jRepeat.lockKey(), parameterNames, args, "RepeatSubmit").get(0);
            boolean isLocked = false;
            try {
                isLocked = this.redissonLockClient.fairLock(key, TimeUnit.SECONDS, jRepeat.lockTime());
                if (isLocked) {
                    Object object = joinPoint.proceed();
                    return object;
                }
                throw new Exception("\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
            }
            finally {
                if (isLocked) {
                    this.redissonLockClient.unlock(key);
                }
            }
        }
        return joinPoint.proceed();
    }
}

