/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.jeecg.p3.system.entity.JwWebJwid;
import com.jeecg.p3.system.service.JwWebJwidService;
import com.jeecg.p3.system.util.SystemUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/system/back/jwWebJwid"})
public class JwWebJwidController
extends BaseController {
    @Autowired
    private JwWebJwidService jwWebJwidService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwWebJwid query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setPageNo(pageNo);
        pageQuery.setPageSize(pageSize);
        VelocityContext velocityContext = new VelocityContext();
        String jwid = request.getSession().getAttribute("jwid").toString();
        pageQuery.setQuery((Object)query);
        velocityContext.put("jwid", (Object)jwid);
        velocityContext.put("jwWebJwid", (Object)query);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwWebJwidService.queryPageList((PageQuery<JwWebJwid>)pageQuery)));
        String viewName = "system/back/jwWebJwid-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwWebJwidDetail(@RequestParam(required=true, value="id") String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwWebJwid-detail.vm";
        JwWebJwid jwWebJwid = this.jwWebJwidService.queryById(id);
        velocityContext.put("jwWebJwid", (Object)jwWebJwid);
        String jwid = request.getSession().getAttribute("jwid").toString();
        velocityContext.put("jwid", (Object)jwid);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwWebJwid-add.vm";
        String jwid = request.getSession().getAttribute("jwid").toString();
        velocityContext.put("jwid", (Object)jwid);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwWebJwid jwWebJwid) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwWebJwidService.doAdd(jwWebJwid);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwWebJwid jwWebJwid = this.jwWebJwidService.queryById(id);
        velocityContext.put("jwWebJwid", (Object)jwWebJwid);
        String viewName = "system/back/jwWebJwid-edit.vm";
        String jwid = request.getSession().getAttribute("jwid").toString();
        velocityContext.put("jwid", (Object)jwid);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwWebJwid jwWebJwid) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwWebJwidService.doEdit(jwWebJwid);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwWebJwidService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"/initJwid"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String initJwid(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="userId", required=true) String userId) {
        log.info("\u521d\u59cb\u5316\u516c\u4f17\u53f7");
        String tree = "";
        try {
            List<JwWebJwid> allJwidList = this.jwWebJwidService.queryJwids();
            List<JwWebJwid> userJwidList = this.jwWebJwidService.queryJwWebJwidByUserId(userId);
            tree = SystemUtil.list2TreeWithCheckToJwid(allJwidList, userJwidList);
            log.info("\u521d\u59cb\u5316\u516c\u4f17\u53f7: " + tree);
        }
        catch (Exception e) {
            log.info(e.getMessage());
        }
        return tree;
    }

    @RequestMapping(value={"/editUserJwid"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson editUserJwid(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="checkedNodes", required=true) String checkedNodes, @RequestParam(value="userId", required=true) String userId) {
        AjaxJson j = new AjaxJson();
        log.info("\u7f16\u8f91\u7528\u6237\u516c\u4f17\u53f7");
        try {
            ArrayList<String> jwids = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)checkedNodes)) {
                String[] stringArray = checkedNodes.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String jwid = stringArray[n2];
                    jwids.add(jwid);
                    ++n2;
                }
            }
            this.jwWebJwidService.modifyOperateUserJwidRel(userId, jwids);
            j.setSuccess(true);
            j.setMsg("\u5206\u914d\u6210\u529f");
            log.info("\u7f16\u8f91\u7528\u6237\u516c\u4f17\u53f7\u5b8c\u6210 ");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5206\u914d\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"/doUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson doUpload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            MultipartFile uploadify = request.getFile("file");
            byte[] bytes = uploadify.getBytes();
            String realFilename = uploadify.getOriginalFilename();
            String fileExtension = realFilename.substring(realFilename.lastIndexOf("."));
            String fileNoExtension = realFilename.substring(0, realFilename.lastIndexOf("."));
            String filename = String.valueOf(UUID.randomUUID().toString().replace("-", "")) + fileExtension;
            String uploadDir = request.getSession().getServletContext().getRealPath("upload/img/commonweixin");
            File dirPath = new File(uploadDir);
            if (!dirPath.exists()) {
                dirPath.mkdirs();
            }
            String sep = System.getProperty("file.separator");
            File uploadedFile = new File(String.valueOf(uploadDir) + sep + filename);
            FileCopyUtils.copy((byte[])bytes, (File)uploadedFile);
            j.setObj((Object)filename);
            j.setSuccess(true);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }
}

