/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.jeecg.p3.system.entity.JwSystemUserJwid;
import com.jeecg.p3.system.entity.JwWebJwid;
import com.jeecg.p3.system.service.JwSystemUserJwidService;
import com.jeecg.p3.system.service.JwWebJwidService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/back/jwSystemUserJwid"})
public class JwSystemUserJwidController
extends BaseController {
    @Autowired
    private JwSystemUserJwidService jwSystemUserJwidService;
    @Autowired
    private JwWebJwidService jwWebJwidService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemUserJwid query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        String userId = query.getUserId();
        VelocityContext velocityContext = new VelocityContext();
        if (StringUtils.isNotEmpty((String)userId)) {
            PageQuery pageQuery = new PageQuery();
            pageQuery.setPageNo(pageNo);
            pageQuery.setPageSize(pageSize);
            pageQuery.setQuery((Object)query);
            velocityContext.put("jwSystemUserJwid", (Object)query);
            velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemUserJwidService.queryPageList((PageQuery<JwSystemUserJwid>)pageQuery)));
        }
        String viewName = "system/back/jwSystemUserJwid-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemUserJwidDetail(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemUserJwid-detail.vm";
        JwSystemUserJwid jwSystemUserJwid = this.jwSystemUserJwidService.queryById(id);
        velocityContext.put("jwSystemUserJwid", (Object)jwSystemUserJwid);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(String userId, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("userId", (Object)userId);
        List<JwWebJwid> jwidList = this.jwWebJwidService.queryJwidsNotInUser(userId);
        velocityContext.put("jwids", jwidList);
        String viewName = "system/back/jwSystemUserJwid-add.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemUserJwid jwSystemUserJwid) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isEmpty((String)jwSystemUserJwid.getUserId())) {
                throw new Exception("\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.jwSystemUserJwidService.doAdd(jwSystemUserJwid);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemUserJwid jwSystemUserJwid = this.jwSystemUserJwidService.queryById(id);
        velocityContext.put("jwSystemUserJwid", (Object)jwSystemUserJwid);
        String viewName = "system/back/jwSystemUserJwid-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemUserJwid jwSystemUserJwid) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemUserJwidService.doEdit(jwSystemUserJwid);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemUserJwidService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }
}

