/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.jeecg.p3.system.entity.JwSystemAuthMutex;
import com.jeecg.p3.system.entity.JwSystemRole;
import com.jeecg.p3.system.entity.JwSystemUser;
import com.jeecg.p3.system.entity.Menu;
import com.jeecg.p3.system.entity.MenuMutex;
import com.jeecg.p3.system.service.JwSystemAuthMutexService;
import com.jeecg.p3.system.service.JwSystemRoleService;
import com.jeecg.p3.system.service.JwSystemUserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.common.utils.StringUtil;
import org.jeecgframework.p3.core.util.MD5Util;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/back/jwSystemUser"})
public class JwSystemUserController
extends BaseController {
    @Autowired
    private JwSystemUserService jwSystemUserService;
    @Autowired
    private JwSystemRoleService jwSystemRoleService;
    @Autowired
    private JwSystemAuthMutexService jwSystemAuthMutexService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemUser query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setPageNo(pageNo);
        pageQuery.setPageSize(pageSize);
        VelocityContext velocityContext = new VelocityContext();
        pageQuery.setQuery((Object)query);
        velocityContext.put("jwSystemUser", (Object)query);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemUserService.queryPageList((PageQuery<JwSystemUser>)pageQuery)));
        String viewName = "system/back/jwSystemUser-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemUserDetail(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemUser-detail.vm";
        JwSystemUser jwSystemUser = this.jwSystemUserService.queryById(id);
        velocityContext.put("jwSystemUser", (Object)jwSystemUser);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemUser-add.vm";
        List<JwSystemRole> roleList = this.jwSystemRoleService.queryAllRoleList();
        velocityContext.put("roleList", roleList);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemUser jwSystemUser, @RequestParam(required=false, value="roleIds") List<String> roleIds) {
        AjaxJson j = new AjaxJson();
        try {
            MenuMutex menuMutex = this.checkAuthMutex(roleIds);
            if (menuMutex != null) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u8d4b\u89d2\u8272\u5931\u8d25\uff1a\u89d2\u8272\u3010" + menuMutex.getMenu().getRoleName() + "\u3011:\u3010" + menuMutex.getMenu().getAuthName() + "\u3011\n \u4e0e \u89d2\u8272\u3010" + menuMutex.getMutexMenu().getRoleName() + "\u3011:\u3010" + menuMutex.getMutexMenu().getAuthName() + "\u3011\u6743\u9650\u51b2\u7a81\uff01");
                j.setObj((Object)menuMutex);
                return j;
            }
            Date date = new Date();
            jwSystemUser.setCreateDt(date);
            if (!StringUtil.isEmpty((String)jwSystemUser.getPassword())) {
                String passwordEncode = MD5Util.MD5Encode((String)jwSystemUser.getPassword(), (String)"utf-8");
                jwSystemUser.setPassword(passwordEncode);
            }
            this.jwSystemUserService.doAdd(jwSystemUser, roleIds);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemUser jwSystemUser = this.jwSystemUserService.queryById(id);
        List<String> roleIds = this.jwSystemUserService.queryUserRoles(jwSystemUser.getUserId());
        List<JwSystemRole> allRolelist = this.jwSystemRoleService.queryAllRoleList();
        ArrayList<JwSystemRole> checkedRoleList = new ArrayList<JwSystemRole>();
        if (allRolelist != null && allRolelist.size() > 0) {
            for (JwSystemRole role : allRolelist) {
                if (roleIds.contains(role.getRoleId())) {
                    role.setIsChecked(true);
                }
                checkedRoleList.add(role);
            }
        }
        velocityContext.put("roleList", checkedRoleList);
        velocityContext.put("jwSystemUser", (Object)jwSystemUser);
        String viewName = "system/back/jwSystemUser-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemUser jwSystemUser, @RequestParam(required=false, value="roleIds") List<String> roleIds) {
        AjaxJson j = new AjaxJson();
        try {
            MenuMutex menuMutex = this.checkAuthMutex(roleIds);
            if (menuMutex != null) {
                j.setSuccess(false);
                j.setMsg("\u7528\u6237\u8d4b\u89d2\u8272\u5931\u8d25\uff1a\u89d2\u8272\u3010" + menuMutex.getMenu().getRoleName() + "\u3011:\u3010" + menuMutex.getMenu().getAuthName() + "\u3011\n \u4e0e \u89d2\u8272\u3010" + menuMutex.getMutexMenu().getRoleName() + "\u3011:\u3010" + menuMutex.getMutexMenu().getAuthName() + "\u3011\u6743\u9650\u51b2\u7a81\uff01");
                j.setObj((Object)menuMutex);
                return j;
            }
            if (!StringUtil.isEmpty((String)jwSystemUser.getPassword())) {
                jwSystemUser.setPassword(null);
            }
            this.jwSystemUserService.doEdit(jwSystemUser, roleIds);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"/toChangePassword"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toChangePassword(@RequestParam(required=true, value="id") Long id, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemUser-changepassword.vm";
        velocityContext.put("id", (Object)id);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doChangePassword"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doChangePassword(@ModelAttribute JwSystemUser jwSystemUser, @RequestParam(required=false, value="roleIds") List<String> roleIds) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtil.isEmpty((String)jwSystemUser.getPassword())) {
                j.setSuccess(false);
                j.setMsg("\u5bc6\u7801\u4e3a\u7a7a");
                return j;
            }
            String passwordEncode = MD5Util.MD5Encode((String)jwSystemUser.getPassword(), (String)"utf-8");
            jwSystemUser.setPassword(passwordEncode);
            this.jwSystemUserService.doChangePassword(jwSystemUser);
            j.setMsg("\u4fee\u6539\u5bc6\u7801\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fee\u6539\u5bc6\u7801\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") Long id) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemUserService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return j;
    }

    private MenuMutex checkAuthMutex(List<String> roleIds) {
        if (roleIds == null || roleIds.size() <= 0) {
            return null;
        }
        List<JwSystemAuthMutex> authMutexList = this.jwSystemAuthMutexService.queryAllAuthMutex();
        List<Menu> menuList = this.jwSystemUserService.queryUserMenuAuth(roleIds);
        HashMap<String, Menu> map = new HashMap<String, Menu>();
        MenuMutex result = new MenuMutex();
        if (menuList != null && menuList.size() > 0) {
            for (Menu vo : menuList) {
                map.put(vo.getAuthId(), vo);
            }
            for (JwSystemAuthMutex authMutex : authMutexList) {
                if (!map.containsKey(authMutex.getAuthId()) || !map.containsKey(authMutex.getMutexAuthId())) continue;
                Menu menu = (Menu)map.get(authMutex.getAuthId());
                Menu menuMutex = (Menu)map.get(authMutex.getMutexAuthId());
                result.setMenu(menu);
                result.setMutexMenu(menuMutex);
                return result;
            }
        }
        return null;
    }

    @RequestMapping(value={"toJwidTree"}, method={RequestMethod.GET})
    public void toPrivilegeTree(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemUser jwSystemuser = this.jwSystemUserService.queryById(id);
        velocityContext.put("jwSystemuser", (Object)jwSystemuser);
        String viewName = "system/back/jwSystemUser-jwidtree.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }
}

