/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.jeecg.p3.system.entity.JwSystemRole;
import com.jeecg.p3.system.service.JwSystemRoleService;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/back/jwSystemRole"})
public class JwSystemRoleController
extends BaseController {
    @Autowired
    private JwSystemRoleService jwSystemRoleService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemRole query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setPageNo(pageNo);
        pageQuery.setPageSize(pageSize);
        VelocityContext velocityContext = new VelocityContext();
        pageQuery.setQuery((Object)query);
        velocityContext.put("jwSystemRole", (Object)query);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemRoleService.queryPageList((PageQuery<JwSystemRole>)pageQuery)));
        String viewName = "system/back/jwSystemRole-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemRoleDetail(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemRole-detail.vm";
        JwSystemRole jwSystemRole = this.jwSystemRoleService.queryById(id);
        velocityContext.put("jwSystemRole", (Object)jwSystemRole);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemRole-add.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemRole jwSystemRole) {
        AjaxJson j = new AjaxJson();
        try {
            jwSystemRole.setDelStat("0");
            jwSystemRole.setCreateDt(new Date());
            this.jwSystemRoleService.doAdd(jwSystemRole);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemRole jwSystemRole = this.jwSystemRoleService.queryById(id);
        velocityContext.put("jwSystemRole", (Object)jwSystemRole);
        String viewName = "system/back/jwSystemRole-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemRole jwSystemRole) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemRoleService.doEdit(jwSystemRole);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") Long id) {
        AjaxJson j = new AjaxJson();
        try {
            JwSystemRole jwSystemRole = this.jwSystemRoleService.queryById(id);
            if ("00".equals(jwSystemRole.getRoleId())) {
                j.setSuccess(false);
                j.setMsg("\u7cfb\u7edf\u7ba1\u7406\u5458\u89d2\u8272\u4e0d\u80fd\u5220\u9664");
            }
            this.jwSystemRoleService.doDelete(id, jwSystemRole.getRoleId());
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.info(e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toPrivilegeTree"}, method={RequestMethod.GET})
    public void toPrivilegeTree(@RequestParam(required=true, value="id") Long id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemRole jwSystemRole = this.jwSystemRoleService.queryById(id);
        velocityContext.put("jwSystemRole", (Object)jwSystemRole);
        String viewName = "system/back/jwSystemRole-privilegetree.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }
}

