/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.jeecg.p3.system.entity.JwSystemProject;
import com.jeecg.p3.system.entity.JwSystemProjectClassify;
import com.jeecg.p3.system.service.JwSystemProjectClassifyService;
import com.jeecg.p3.system.service.JwSystemProjectService;
import com.jeecg.p3.system.util.ContextHolderUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.PropertiesUtil;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageList;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/system/back/jwSystemProject"})
public class JwSystemProjectController
extends BaseController {
    @Autowired
    private JwSystemProjectService jwSystemProjectService;
    @Autowired
    private JwSystemProjectClassifyService jwSystemProjectClassifyService;
    private static String domain = "";

    static {
        PropertiesUtil oAuth = new PropertiesUtil("p3-web-sysconfig.properties");
        domain = oAuth.readProperty("oAuthDomain");
    }

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemProject query, HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        PageQuery pageQuery = new PageQuery();
        List<JwSystemProjectClassify> jwSystemProjectClassifys = this.jwSystemProjectClassifyService.queryListByAll();
        pageQuery.setPageNo(pageNo);
        pageQuery.setPageSize(pageSize);
        VelocityContext velocityContext = new VelocityContext();
        pageQuery.setQuery((Object)query);
        velocityContext.put("jwSystemProject", (Object)query);
        velocityContext.put("jwSystemProjectClassifys", jwSystemProjectClassifys);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemProjectService.queryPageList((PageQuery<JwSystemProject>)pageQuery)));
        String viewName = "system/back/jwSystemProject-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemProjectDetail(@RequestParam(required=true, value="id") String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemProject-detail.vm";
        JwSystemProject jwSystemProject = this.jwSystemProjectService.queryById(id);
        velocityContext.put("jwSystemProject", (Object)jwSystemProject);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemProject-add.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemProject jwSystemProject) {
        AjaxJson j = new AjaxJson();
        try {
            Boolean repeat = this.jwSystemProjectService.validReat(jwSystemProject.getCode(), jwSystemProject.getId());
            if (repeat.booleanValue()) {
                j.setSuccess(false);
                j.setMsg("\u9879\u76ee\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
            } else {
                jwSystemProject.setId(UUID.randomUUID().toString().replace("-", ""));
                if (jwSystemProject.getScType() != null && 2 == jwSystemProject.getScType()) {
                    jwSystemProject.setHdurl(String.valueOf(domain) + "/linksucai/link.do?linkid=" + jwSystemProject.getId());
                }
                this.jwSystemProjectService.doAdd(jwSystemProject);
                j.setMsg("\u4fdd\u5b58\u6210\u529f");
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemProject jwSystemProject = this.jwSystemProjectService.queryById(id);
        if (StringUtils.isNotEmpty((String)jwSystemProject.getProjectClassifyId())) {
            JwSystemProjectClassify jwSystemProjectClassify = this.jwSystemProjectClassifyService.queryById(jwSystemProject.getProjectClassifyId());
            velocityContext.put("jwSystemProjectClassify", (Object)jwSystemProjectClassify);
        }
        velocityContext.put("jwSystemProject", (Object)jwSystemProject);
        String viewName = "system/back/jwSystemProject-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemProject jwSystemProject) {
        AjaxJson j = new AjaxJson();
        try {
            Boolean repeat = this.jwSystemProjectService.validReat(jwSystemProject.getCode(), jwSystemProject.getId());
            if (repeat.booleanValue()) {
                j.setSuccess(false);
                j.setMsg("\u9879\u76ee\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
            } else {
                if (jwSystemProject.getScType() != null && 2 == jwSystemProject.getScType()) {
                    jwSystemProject.setHdurl(String.valueOf(domain) + "/linksucai/link.do?linkid=" + jwSystemProject.getId());
                }
                this.jwSystemProjectService.doEdit(jwSystemProject);
                j.setMsg("\u7f16\u8f91\u6210\u529f");
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemProjectService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"/doUpload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson doUpload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            MultipartFile uploadify = request.getFile("file");
            byte[] bytes = uploadify.getBytes();
            System.out.println(uploadify.getOriginalFilename());
            String uploadDir = ContextHolderUtils.getRequest().getSession().getServletContext().getRealPath("upload/img/system");
            File dirPath = new File(uploadDir);
            if (!dirPath.exists()) {
                dirPath.mkdirs();
            }
            String sep = System.getProperty("file.separator");
            File uploadedFile = new File(String.valueOf(uploadDir) + sep + uploadify.getOriginalFilename());
            FileCopyUtils.copy((byte[])bytes, (File)uploadedFile);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"/getProjList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson recieveState(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            PageQuery pageQuery = new PageQuery();
            JwSystemProject query = new JwSystemProject();
            pageQuery.setPageNo(1);
            pageQuery.setPageSize(100);
            pageQuery.setQuery((Object)query);
            PageList<JwSystemProject> projectList = this.jwSystemProjectService.queryPageList((PageQuery<JwSystemProject>)pageQuery);
            JSONArray result = new JSONArray();
            if (projectList != null && projectList.getValues() != null && projectList.getValues().size() > 0) {
                List pList = projectList.getValues();
                int i = 0;
                while (i < pList.size()) {
                    JSONObject jsonParts = new JSONObject();
                    jsonParts.put((Object)"name", (Object)((JwSystemProject)pList.get(i)).getName());
                    jsonParts.put((Object)"bjurl", (Object)((JwSystemProject)pList.get(i)).getBjurl());
                    jsonParts.put((Object)"img", (Object)((JwSystemProject)pList.get(i)).getImg());
                    result.add((Object)jsonParts);
                    ++i;
                }
            }
            HashMap<String, JSONArray> attrs = new HashMap<String, JSONArray>();
            attrs.put("projectList", result);
            j.setAttributes(attrs);
            j.setSuccess(true);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u8bbf\u95ee\u5f02\u5e38\uff01");
            this.LOG.error("recieveState error:{}", e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"toIndex"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toIndex(HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        List<JwSystemProjectClassify> jwSystemProjectClassifys = this.jwSystemProjectClassifyService.queryAllByType("1");
        velocityContext.put("jwSystemProjectClassifys", jwSystemProjectClassifys);
        velocityContext.put("jwSystemProjectRecommend", this.jwSystemProjectService.queryListByType("1"));
        velocityContext.put("jwSystemProject", this.jwSystemProjectService.queryListByType("2"));
        String viewName = "system/back/newhome.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"getRecommendDetail"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson getRecommendDetail(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            j.setSuccess(true);
            String projectClassifyId = request.getParameter("id");
            List<JwSystemProjectClassify> jwSystemProjectClassifys = this.jwSystemProjectClassifyService.queryAllByBaseId(projectClassifyId);
            HashMap<String, List<JwSystemProjectClassify>> param = new HashMap<String, List<JwSystemProjectClassify>>();
            if (jwSystemProjectClassifys == null || jwSystemProjectClassifys.size() <= 0) {
                List<JwSystemProject> jwSystemProjects = this.jwSystemProjectService.queryListByProjectClassifyId(projectClassifyId);
                if (jwSystemProjects == null || jwSystemProjects.size() <= 0) {
                    j.setObj(null);
                } else {
                    j.setObj(jwSystemProjects);
                }
                param.put("classify", null);
            } else {
                List<JwSystemProject> jwSystemProjects = this.jwSystemProjectService.queryListByProjectClassifyId(jwSystemProjectClassifys.get(0).getId());
                if (jwSystemProjects == null || jwSystemProjects.size() <= 0) {
                    j.setObj(null);
                } else {
                    j.setObj(jwSystemProjects);
                }
                param.put("classify", jwSystemProjectClassifys);
            }
            j.setAttributes(param);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setObj(null);
        }
        return j;
    }

    @RequestMapping(value={"toClassifyDetail"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson toClassifyDetail(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String projectClassifyId = request.getParameter("id");
            List<JwSystemProject> jwSystemProjects = this.jwSystemProjectService.queryListByProjectClassifyId(projectClassifyId);
            if (jwSystemProjects == null || jwSystemProjects.size() <= 0) {
                j.setObj(null);
            } else {
                j.setObj(jwSystemProjects);
            }
            j.setSuccess(true);
        }
        catch (Exception e) {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"actDetail"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson actDetail(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            JwSystemProjectClassify jwSystemProjectClassify;
            JwSystemProject jwSystemProject = this.jwSystemProjectService.queryById(request.getParameter("id"));
            String projectClassifyId = jwSystemProject.getProjectClassifyId();
            if (StringUtils.isNotEmpty((String)projectClassifyId) && (jwSystemProjectClassify = this.jwSystemProjectClassifyService.queryById(projectClassifyId)) != null) {
                jwSystemProject.setProjectClassifyId(jwSystemProjectClassify.getName());
            }
            j.setObj((Object)jwSystemProject);
        }
        catch (Exception e) {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"/getClassifyTree"})
    @ResponseBody
    public AjaxJson getClassifyTree(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            List<JwSystemProjectClassify> jwSystemProjectClassifys = this.jwSystemProjectClassifyService.queryListByAll();
            ArrayList list = new ArrayList();
            for (JwSystemProjectClassify jwSystemProjectClassify : jwSystemProjectClassifys) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", jwSystemProjectClassify.getId());
                if (StringUtils.isEmpty((String)jwSystemProjectClassify.getBaseId())) {
                    map.put("pId", null);
                    map.put("open", "true");
                } else {
                    map.put("pId", jwSystemProjectClassify.getBaseId());
                    map.put("open", "false");
                }
                map.put("name", jwSystemProjectClassify.getName());
                list.add(map);
            }
            j.setObj(list);
            j.setSuccess(true);
        }
        catch (Exception e) {
            j.setSuccess(false);
        }
        return j;
    }
}

