/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.jeecg.p3.system.entity.JwSystemActTxt;
import com.jeecg.p3.system.service.JwSystemActTxtService;
import com.jeecg.p3.system.util.ContextHolderUtils;
import com.jeecg.p3.system.web.dto.JwSystemActTxtDto;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/back/jwSystemActTxt"})
public class JwSystemActTxtController
extends BaseController {
    @Autowired
    private JwSystemActTxtService jwSystemActTxtService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemActTxt query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setPageNo(pageNo);
        pageQuery.setPageSize(pageSize);
        VelocityContext velocityContext = new VelocityContext();
        String backurl = ContextHolderUtils.getRequest().getParameter("backurl");
        pageQuery.setQuery((Object)query);
        velocityContext.put("jwSystemActTxt", (Object)query);
        velocityContext.put("backurl", (Object)backurl);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemActTxtService.queryPageList((PageQuery<JwSystemActTxt>)pageQuery)));
        String viewName = "system/back/jwSystemActTxt-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemActTxtDetail(@RequestParam(required=true, value="id") String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemActTxt-detail.vm";
        JwSystemActTxt jwSystemActTxt = this.jwSystemActTxtService.queryById(id);
        velocityContext.put("jwSystemActTxt", (Object)jwSystemActTxt);
        String backurl = ContextHolderUtils.getRequest().getParameter("backurl");
        velocityContext.put("backurl", (Object)backurl);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(@ModelAttribute JwSystemActTxt query, HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemActTxt-add.vm";
        velocityContext.put("jwSystemActTxt", (Object)query);
        String backurl = ContextHolderUtils.getRequest().getParameter("backurl");
        velocityContext.put("backurl", (Object)backurl);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemActTxt jwSystemActTxt) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemActTxtService.doAdd(jwSystemActTxt);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemActTxt jwSystemActTxt = this.jwSystemActTxtService.queryById(id);
        velocityContext.put("jwSystemActTxt", (Object)jwSystemActTxt);
        String backurl = ContextHolderUtils.getRequest().getParameter("backurl");
        velocityContext.put("backurl", (Object)backurl);
        String viewName = "system/back/jwSystemActTxt-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemActTxt jwSystemActTxt) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemActTxtService.doEdit(jwSystemActTxt);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25:" + e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemActTxtService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return j;
    }

    @RequestMapping(value={"seniorActText"}, method={RequestMethod.GET, RequestMethod.POST})
    public void seniorList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewName = "";
        VelocityContext velocityContext = new VelocityContext();
        String backurl = ContextHolderUtils.getRequest().getParameter("backurl");
        String actCode = request.getParameter("actCode");
        List<JwSystemActTxt> jwSystemActTxts = this.jwSystemActTxtService.queryListByActCode(actCode);
        velocityContext.put("backurl", (Object)backurl);
        velocityContext.put("jwSystemActTxts", jwSystemActTxts);
        viewName = "system/back/jwSystemSeniorActTxt.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"doAddSeniorActText"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAddSeniorActText(@ModelAttribute JwSystemActTxtDto JwSystemActTxtDto2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxJson j = new AjaxJson();
        try {
            List<JwSystemActTxt> jwSystemActTxts = JwSystemActTxtDto2.getJwSystemActTxts();
            if (jwSystemActTxts != null && jwSystemActTxts.size() > 0) {
                for (JwSystemActTxt jwSystemActTxt : jwSystemActTxts) {
                    this.jwSystemActTxtService.doEdit(jwSystemActTxt);
                }
            }
            j.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
            j.setSuccess(false);
        }
        return j;
    }
}

