/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web.back;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.jeecg.p3.system.entity.JwSystemAct;
import com.jeecg.p3.system.entity.JwSystemActAnalysis;
import com.jeecg.p3.system.exception.BusinessException;
import com.jeecg.p3.system.service.JwSystemActAnalysisService;
import com.jeecg.p3.system.service.JwSystemActService;
import com.jeecg.p3.system.service.JwSystemProjectService;
import com.jeecg.p3.util.MatrixToImageWriter;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.util.SystemTools;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.PageQuery;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/back/jwSystemAct"})
public class JwSystemActController
extends BaseController {
    @Autowired
    private JwSystemActService jwSystemActService;
    @Autowired
    private JwSystemActAnalysisService jwSystemActAnalysisService;
    @Autowired
    private JwSystemProjectService jwSystemProjectService;

    @RequestMapping(value={"list"}, method={RequestMethod.GET, RequestMethod.POST})
    public void list(@ModelAttribute JwSystemAct query, HttpServletResponse response, HttpServletRequest request, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        PageQuery pageQuery = new PageQuery();
        pageQuery.setPageNo(pageNo);
        pageQuery.setPageSize(pageSize);
        VelocityContext velocityContext = new VelocityContext();
        pageQuery.setQuery((Object)query);
        velocityContext.put("jwSystemAct", (Object)query);
        velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemActService.queryPageList((PageQuery<JwSystemAct>)pageQuery)));
        String viewName = "system/back/jwSystemAct-list.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"toDetail"}, method={RequestMethod.GET})
    public void jwSystemActDetail(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemAct-detail.vm";
        JwSystemAct jwSystemAct = this.jwSystemActService.queryById(id);
        velocityContext.put("jwSystemAct", (Object)jwSystemAct);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toAddDialog(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemAct-add.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doAdd"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doAdd(@ModelAttribute JwSystemAct jwSystemAct) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemActService.doAdd(jwSystemAct);
            j.setMsg("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toEdit"}, method={RequestMethod.GET})
    public void toEdit(@RequestParam(required=true, value="id") String id, HttpServletResponse response, HttpServletRequest request) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        JwSystemAct jwSystemAct = this.jwSystemActService.queryById(id);
        velocityContext.put("jwSystemAct", (Object)jwSystemAct);
        String viewName = "system/back/jwSystemAct-edit.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/doEdit"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doEdit(@ModelAttribute JwSystemAct jwSystemAct) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemActService.doEdit(jwSystemAct);
            j.setMsg("\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u7f16\u8f91\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"doDelete"}, method={RequestMethod.GET})
    @ResponseBody
    public AjaxJson doDelete(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            this.jwSystemActService.doDelete(id);
            j.setMsg("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"toAnalysisList"})
    public void toAnalysisList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemActAnalysis-list.vm";
        String actId = request.getParameter("actId");
        this.validateParam(actId, "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        String startDate = request.getParameter("startDate");
        String endDate = request.getParameter("endDate");
        List<JwSystemActAnalysis> actAnalysis = this.jwSystemActAnalysisService.queryByActIdAndDate(actId, startDate, endDate);
        StringBuffer dataName = new StringBuffer();
        dataName.append("[");
        StringBuffer dataNum = new StringBuffer();
        dataNum.append("[");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int i = 0;
        while (i < actAnalysis.size()) {
            dataName.append("'");
            dataName.append(sdf.format(actAnalysis.get(i).getRefDate()));
            dataName.append("'");
            dataName.append(",");
            dataNum.append(actAnalysis.get(i).getJoinNum());
            dataNum.append(",");
            ++i;
        }
        dataName.append("]");
        dataNum.append("]");
        velocityContext.put("dataName", (Object)dataName.toString());
        velocityContext.put("dataNum", (Object)dataNum.toString());
        velocityContext.put("actAnalysis", actAnalysis);
        velocityContext.put("actId", (Object)actId);
        velocityContext.put("startDate", (Object)startDate);
        velocityContext.put("endDate", (Object)endDate);
        velocityContext.put("showFlag", (Object)request.getParameter("showFlag"));
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    private void validateParam(String param, String exMsg) {
        if (StringUtils.isEmpty((String)param)) {
            throw new BusinessException(exMsg);
        }
    }

    @RequestMapping(value={"/toIndividual"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toIndividual(@ModelAttribute JwSystemAct query, HttpServletRequest request, HttpServletResponse response, @RequestParam(required=false, value="pageNo", defaultValue="1") int pageNo, @RequestParam(required=false, value="pageSize", defaultValue="10") int pageSize) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "system/back/jwSystemAct-individual.vm";
        try {
            String userId = (String)request.getSession().getAttribute("system_userid");
            if (StringUtils.isEmpty((String)userId)) {
                throw new BusinessException("\u7528\u6237\u672a\u767b\u5f55");
            }
            PageQuery pageQuery = new PageQuery();
            query.setCreateName(userId);
            pageQuery.setPageNo(pageNo);
            pageQuery.setPageSize(pageSize);
            pageQuery.setQuery((Object)query);
            List<Object> JwSystemProject2 = new ArrayList();
            JwSystemProject2 = this.jwSystemProjectService.queryProjectCode();
            velocityContext.put("JwSystemProject", JwSystemProject2);
            velocityContext.put("jwSystemAct", (Object)query);
            velocityContext.put("pageInfos", (Object)SystemTools.convertPaginatedList(this.jwSystemActService.queryPageList((PageQuery<JwSystemAct>)pageQuery)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"getShortUrl"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson getShortUrl(@RequestParam(required=true, value="id") String id) {
        AjaxJson j = new AjaxJson();
        try {
            JwSystemAct jwSystemAct = this.jwSystemActService.queryById(id);
            String shortUrl = jwSystemAct.getShortUrl();
            if (StringUtils.isEmpty((String)shortUrl)) {
                shortUrl = jwSystemAct.getHdurl();
            }
            if (StringUtils.isEmpty((String)shortUrl)) {
                j.setMsg("\u83b7\u53d6\u5730\u5740\u5931\u8d25\uff01");
                j.setSuccess(false);
            } else {
                j.setObj((Object)shortUrl);
                j.setSuccess(true);
                j.setMsg("\u83b7\u53d6\u5730\u5740\u6210\u529f\uff01");
            }
        }
        catch (Exception e) {
            j.setMsg("\u83b7\u53d6\u5730\u5740\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"downMatrix"}, method={RequestMethod.GET, RequestMethod.POST})
    public void downMatrix(@RequestParam(required=true, value="qrCodeName") String qrCodeName, @RequestParam(required=true, value="url") String url, HttpServletResponse response, HttpServletRequest request) throws Exception {
        String text = url;
        int width = 500;
        int height = 500;
        String format = "jpg";
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        String fileName = "";
        fileName = qrCodeName != null ? String.valueOf(qrCodeName) + ".jpg" : "\u6d3b\u52a8\u4e8c\u7ef4\u7801.jpg";
        response.setHeader("content-disposition", "attachment;fileName=" + URLEncoder.encode(fileName, "UTF-8"));
        ServletOutputStream out = response.getOutputStream();
        try {
            try {
                MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)format, (OutputStream)out);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

