/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web;

import com.jeecg.p3.site.authorized.service.SystemUserAuthService;
import com.jeecg.p3.system.entity.JwSystemLogoTitle;
import com.jeecg.p3.system.entity.JwSystemQrcodeRecord;
import com.jeecg.p3.system.entity.JwSystemRegister;
import com.jeecg.p3.system.entity.JwSystemUser;
import com.jeecg.p3.system.entity.JwSystemUserJwid;
import com.jeecg.p3.system.entity.JwWebJwid;
import com.jeecg.p3.system.entity.Menu;
import com.jeecg.p3.system.service.JwSystemAuthService;
import com.jeecg.p3.system.service.JwSystemLogoTitleService;
import com.jeecg.p3.system.service.JwSystemQrcodeRecordService;
import com.jeecg.p3.system.service.JwSystemRegisterService;
import com.jeecg.p3.system.service.JwSystemUserJwidService;
import com.jeecg.p3.system.service.JwSystemUserService;
import com.jeecg.p3.system.service.JwWebJwidService;
import com.jeecg.p3.system.util.JwHttpUtil;
import com.jeecg.p3.system.util.SendMailUtil;
import com.jeecg.p3.system.util.WeiXinQrcodeUtil;
import com.jeecg.p3.system.vo.LoginUser;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.VelocityContext;
import org.jeecgframework.p3.core.common.utils.AjaxJson;
import org.jeecgframework.p3.core.common.utils.StringUtil;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.MD5Util;
import org.jeecgframework.p3.core.util.PropertiesUtil;
import org.jeecgframework.p3.core.util.plugin.ViewVelocity;
import org.jeecgframework.p3.core.utils.common.StringUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system"})
public class SystemController
extends BaseController {
    public static final Logger LOG = LoggerFactory.getLogger(SystemController.class);
    @Autowired
    private JwWebJwidService jwidService;
    @Autowired
    private JwSystemAuthService jwSystemAuthService;
    @Autowired
    private JwSystemLogoTitleService jwSystemLogoTitleService;
    @Autowired
    private JwSystemUserService jwSystemUserService;
    @Autowired
    private JwSystemRegisterService jwSystemRegisterService;
    @Autowired
    private JwSystemUserJwidService jwSystemUserJwidService;
    @Autowired
    private JwSystemQrcodeRecordService jwSystemQrcodeRecordService;
    @Autowired(required=false)
    private SystemUserAuthService systemUserAuthService;
    public static final String indexPath = "base/back/hplus/index.vm";
    @Value(value="#{sysconfig['sys.jwsso.flg']}")
    private String sysJwssoFlag;
    @Value(value="#{sysconfig['sys.jwsso.select.default.jwid.flg']}")
    private String selectDefaultJwidFlag;
    @Value(value="#{sysconfig['sys.jwsso.select.default.jwid']}")
    private String defaultJwid;
    private static String interceptCharge = "0";

    static {
        PropertiesUtil system = new PropertiesUtil("system.properties");
        interceptCharge = system.readProperty("intercept.charge");
    }

    @RequestMapping(value={"/noAuth"}, method={RequestMethod.GET, RequestMethod.POST})
    public void noAuth(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewName = "base/back/common/error.vm";
        VelocityContext velocityContext = new VelocityContext();
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/toLogin"}, method={RequestMethod.GET, RequestMethod.POST})
    public void toLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        LoginUser user = (LoginUser)request.getSession().getAttribute("OPERATE_WEB_LOGIN_USER");
        JwSystemLogoTitle logoTitle = this.jwSystemLogoTitleService.queryLogoTitle().get(0);
        velocityContext.put("logoTitle", (Object)logoTitle);
        String referer = request.getRequestURL().toString();
        if (referer != null && referer.trim().startsWith("http://h5huodong.com")) {
            response.sendRedirect("http://www.h5huodong.com" + request.getRequestURI());
            return;
        }
        if (user != null) {
            velocityContext.put("jwidname", (Object)((String)request.getSession().getAttribute("jwidname")));
            velocityContext.put("userid", (Object)user.getUserId());
            try {
                List<Menu> menuTree = this.jwSystemAuthService.getMenuTree(user.getUserId());
                this.chargeAuthInterceptor(user, menuTree);
                LOG.info("menuTree---->" + menuTree);
                velocityContext.put("OPERATE_WEB_MENU_TREE", menuTree);
                String viewName = indexPath;
                ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        String viewName = "base/back/common/login.vm";
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/checkUser"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson checkUser(String username, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxJson j = new AjaxJson();
        try {
            String randCode = request.getParameter("randCode");
            HttpSession session = request.getSession();
            Object yzm = session.getAttribute("randCode");
            if (StringUtils.isEmpty((String)randCode) || yzm == null || !randCode.equals(yzm.toString())) {
                LOG.info("\u9a8c\u8bc1\u7801\u9519\u8bef\uff1a" + randCode);
                j.setSuccess(false);
                j.setMsg("\u9a8c\u8bc1\u7801\u9519\u8bef,\u8bf7\u91cd\u8bd5\uff01");
                return j;
            }
            LoginUser user = this.jwSystemUserService.queryUserByUserId(username);
            boolean isAuth = false;
            String passwordEncode = MD5Util.MD5Encode((String)password, (String)"utf-8");
            if (user != null) {
                if (passwordEncode != null && passwordEncode.equals(user.getPassword()) && "NORMAL".equals(user.getUserStat())) {
                    isAuth = true;
                } else {
                    LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u767b\u5f55\u4fe1\u606f\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                }
            } else if ("Y".equals(this.sysJwssoFlag)) {
                user = this.jwSSO(username, password);
                if (user != null) {
                    JwSystemUser jwSystemUser = new JwSystemUser();
                    jwSystemUser.setUserId(username);
                    jwSystemUser.setUserName(user.getUserName());
                    jwSystemUser.setPassword(passwordEncode);
                    jwSystemUser.setCreateDt(new Date());
                    jwSystemUser.setUserStat("NORMAL");
                    ArrayList<String> roleIds = new ArrayList<String>();
                    roleIds.add("01");
                    this.jwSystemUserService.doAdd(jwSystemUser, roleIds);
                    isAuth = true;
                } else {
                    LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u6377\u5fae\u5e73\u53f0\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                }
            } else {
                LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u4e0d\u5b58\u5728");
            }
            if (isAuth) {
                LOG.info("\u767b\u5f55\u9a8c\u8bc1\u6210\u529f\uff1a\u7528\u6237\u3010" + username + "\u3011\u6743\u9650\u9a8c\u8bc1\u901a\u8fc7");
                j.setSuccess(true);
                j.setMsg("\u767b\u5f55\u9a8c\u8bc1\u6210\u529f");
                j.setObj((Object)"");
                if ("Y".equals(this.selectDefaultJwidFlag)) {
                    List<JwWebJwid> jwids = this.jwidService.queryJwWebJwidByUserId(username);
                    if (jwids == null || jwids.size() <= 0) {
                        j.setObj((Object)this.defaultJwid);
                    } else if (jwids.size() == 1) {
                        j.setObj((Object)jwids.get(0).getJwid());
                    }
                }
                return j;
            }
            LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            j.setSuccess(false);
            j.setMsg("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25");
        }
        catch (Exception e) {
            LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
            j.setSuccess(false);
            j.setMsg("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"/preLogin"}, method={RequestMethod.GET, RequestMethod.POST})
    public void preLogin(String username, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "base/back/common/prelogin.vm";
        try {
            LoginUser user = this.jwSystemUserService.queryUserByUserId(username);
            boolean isAuth = false;
            String passwordEncode = MD5Util.MD5Encode((String)password, (String)"utf-8");
            if (user != null) {
                if (passwordEncode != null && passwordEncode.equals(user.getPassword()) && "NORMAL".equals(user.getUserStat())) {
                    isAuth = true;
                } else {
                    LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u767b\u5f55\u4fe1\u606f\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                }
            }
            List<Object> jwids = new ArrayList();
            if (isAuth) {
                jwids = this.jwidService.queryJwWebJwidByUserId(username);
            } else {
                LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            }
            velocityContext.put("jwids", jwids);
            velocityContext.put("sysJwssoFlag", (Object)this.sysJwssoFlag);
        }
        catch (Exception e) {
            LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/chooseWeixinId"}, method={RequestMethod.GET, RequestMethod.POST})
    public void chooseWeixinId(HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "base/back/common/prelogin.vm";
        try {
            String openid = request.getSession().getAttribute("openid").toString();
            LoginUser user = this.jwSystemUserService.queryUserByOpenid(openid);
            boolean isAuth = false;
            if (user != null && "NORMAL".equals(user.getUserStat())) {
                isAuth = true;
            }
            List<Object> jwids = new ArrayList();
            if (isAuth) {
                jwids = this.jwidService.queryJwWebJwidByUserId(user.getUserId());
            }
            velocityContext.put("jwids", jwids);
            velocityContext.put("sysJwssoFlag", (Object)this.sysJwssoFlag);
        }
        catch (Exception e) {
            LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25" + e.getMessage());
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    private LoginUser jwSSO(String username, String password) {
        return JwHttpUtil.jwSSO(username, password);
    }

    private void syncUserJwid(String username) {
        List<JwWebJwid> jwidList = JwHttpUtil.getJwids(username);
        this.jwidService.syncJwid(username, jwidList);
    }

    @RequestMapping(value={"/syncJwid"}, method={RequestMethod.GET, RequestMethod.POST})
    public void syncJwid(String username, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "base/back/common/prelogin.vm";
        try {
            this.syncUserJwid(username);
            List<JwWebJwid> jwids = this.jwidService.queryJwWebJwidByUserId(username);
            if (jwids != null && jwids.size() > 0) {
                velocityContext.put("jwid_select_flag", (Object)"jwid_select_flag_success");
            } else {
                velocityContext.put("jwid_select_flag", (Object)"jwid_select_flag_fail");
            }
            velocityContext.put("jwids", jwids);
        }
        catch (Exception e) {
            LOG.info("\u540c\u6b65\u5fae\u4fe1\u516c\u4f17\u53f7\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET, RequestMethod.POST})
    public void login(String jwid, String username, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext;
        String viewName;
        block16: {
            viewName = "base/back/common/login.vm";
            velocityContext = new VelocityContext();
            try {
                String referer = request.getRequestURL().toString();
                if (referer != null && referer.trim().startsWith("http://h5huodong.com")) {
                    response.sendRedirect("http://www.h5huodong.com" + request.getRequestURI());
                    return;
                }
                LoginUser user = (LoginUser)request.getSession().getAttribute("OPERATE_WEB_LOGIN_USER");
                JwSystemLogoTitle logoTitle = this.jwSystemLogoTitleService.queryLogoTitle().get(0);
                velocityContext.put("logoTitle", (Object)logoTitle);
                if (user != null) {
                    viewName = indexPath;
                    velocityContext.put("jwidname", (Object)((String)request.getSession().getAttribute("jwidname")));
                    velocityContext.put("userid", (Object)user.getUserId());
                    try {
                        List<Menu> menuTree = this.jwSystemAuthService.getMenuTree(user.getUserId());
                        this.chargeAuthInterceptor(user, menuTree);
                        LOG.info("menuTree---->" + menuTree);
                        velocityContext.put("OPERATE_WEB_MENU_TREE", menuTree);
                        String userId = user.getUserId();
                        if (this.systemUserAuthService != null && !this.systemUserAuthService.checkUser(userId)) {
                            String basePath = request.getContextPath();
                            LOG.info("\u7528\u6237\u3010" + username + "\u3011\u6ca1\u6709\u7b7e\u8ba2\u534f\u8bae");
                            response.sendRedirect(String.valueOf(basePath) + "/system/toProtocol.do");
                        }
                        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                String randCode = request.getParameter("randCode");
                HttpSession session = request.getSession();
                Object yzm = session.getAttribute("randCode");
                if (StringUtils.isEmpty((String)randCode) || yzm == null || !randCode.equals(yzm.toString())) {
                    throw new RuntimeException("\u9a8c\u8bc1\u7801\u9519\u8bef");
                }
                session.removeAttribute("randCode");
                this.validateLoginParam(jwid, username, password);
                user = this.jwSystemUserService.queryUserByUserId(username);
                if (user != null) {
                    String passwordEncode = MD5Util.MD5Encode((String)password, (String)"utf-8");
                    if (passwordEncode == null || !passwordEncode.equals(user.getPassword()) || !"NORMAL".equals(user.getUserStat())) break block16;
                    JwWebJwid jw = null;
                    List<JwWebJwid> jwids = this.jwidService.queryJwWebJwidByUserId(username);
                    if (jwids != null && jwids.size() > 0) {
                        jw = this.jwidService.queryJwidByJwidAndUserId(jwid, username);
                    } else if ("Y".equals(this.selectDefaultJwidFlag) && this.defaultJwid.equals(jwid)) {
                        jw = this.jwidService.queryJwidNameByJwid(jwid);
                    }
                    if (jw != null) {
                        request.getSession().setAttribute("jwid", (Object)jwid);
                        request.getSession().setAttribute("jwidname", (Object)jw.getName());
                        request.getSession().setAttribute("system_userid", (Object)username);
                        request.getSession().setAttribute("OPERATE_WEB_LOGIN_USER", (Object)user);
                        velocityContext.put("jwidname", (Object)jw.getName());
                        velocityContext.put("userid", (Object)user.getUserId());
                        try {
                            List<Menu> menuTree = this.jwSystemAuthService.getMenuTree(user.getUserId());
                            this.chargeAuthInterceptor(user, menuTree);
                            LOG.info("menuTree---->" + menuTree);
                            velocityContext.put("OPERATE_WEB_MENU_TREE", menuTree);
                            viewName = indexPath;
                            String userId = user.getUserId();
                            if (this.systemUserAuthService != null && !this.systemUserAuthService.checkUser(userId)) {
                                String basePath = request.getContextPath();
                                LOG.info("\u7528\u6237\u3010" + username + "\u3011\u6ca1\u6709\u7b7e\u8ba2\u534f\u8bae");
                                response.sendRedirect(String.valueOf(basePath) + "/system/toProtocol.do");
                            }
                            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    LOG.info("\u767b\u5f55\u5931\u8d25\uff1ajwid\u3010" + jwid + "\u3011\u4e0d\u5c5e\u4e8e\u7528\u6237\u3010" + username + "\u3011");
                    break block16;
                }
                LOG.info("\u767b\u5f55\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u4e0d\u5b58\u5728");
            }
            catch (Exception e) {
                LOG.info("\u767b\u5f55\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
            }
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    private void validateLoginParam(String jwid, String username, String password) {
        if (StringUtils.isEmpty((String)username)) {
            throw new RuntimeException("\u767b\u5f55\u7528\u6237\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)password)) {
            throw new RuntimeException("\u7528\u6237\u5bc6\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)jwid)) {
            throw new RuntimeException("\u5fae\u4fe1\u516c\u4f17\u53f7\u4e3a\u7a7a");
        }
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.GET, RequestMethod.POST})
    public void logout(String jwid, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String referer = request.getRequestURL().toString();
        if (referer != null && referer.trim().startsWith("http://h5huodong.com")) {
            response.sendRedirect("http://www.h5huodong.com" + request.getRequestURI());
            return;
        }
        String viewName = "base/back/common/login.vm";
        VelocityContext velocityContext = new VelocityContext();
        JwSystemLogoTitle logoTitle = this.jwSystemLogoTitleService.queryLogoTitle().get(0);
        velocityContext.put("logoTitle", (Object)logoTitle);
        request.getSession().removeAttribute("jwid");
        request.getSession().removeAttribute("jwidname");
        request.getSession().removeAttribute("system_userid");
        request.getSession().removeAttribute("OPERATE_WEB_LOGIN_USER");
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.GET, RequestMethod.POST})
    public void register(HttpServletRequest request, HttpServletResponse response, String mode, String email) throws Exception {
        String viewName = "base/back/common/register.vm";
        VelocityContext velocityContext = new VelocityContext();
        if (StringUtil.isEmpty((String)mode)) {
            mode = "1";
        } else if ("2".equalsIgnoreCase(mode)) {
            velocityContext.put("email", (Object)email);
        }
        velocityContext.put("mode", (Object)mode);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/queryHeadAndFooter"})
    @ResponseBody
    public AjaxJson queryHeadAndFooter() {
        AjaxJson ajson = new AjaxJson();
        JwSystemLogoTitle jwSystemLogoTitle = this.jwSystemLogoTitleService.queryByProp(null);
        ajson.setObj((Object)jwSystemLogoTitle);
        return ajson;
    }

    @RequestMapping(value={"/doRegister"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doRegister(JwSystemRegister register, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxJson j = new AjaxJson();
        String message = "";
        try {
            String regEx = "^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z0-9]{2,6}$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(register.getEmail());
            if (!matcher.matches()) {
                message = "\u7528\u6237: " + register.getEmail() + "\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff01";
                j.setSuccess(false);
                j.setMsg(message);
                return j;
            }
            LoginUser user = this.jwSystemUserService.queryUserByUserId(register.getEmail());
            if (user != null) {
                message = "\u7528\u6237: " + register.getEmail() + "\u5df2\u7ecf\u5b58\u5728\u3002\u8bf7\u76f4\u63a5\u767b\u5f55\u3002";
                j.setSuccess(false);
                j.setMsg(message);
            } else {
                JwSystemRegister property = new JwSystemRegister();
                property.setEmail(register.getEmail());
                List<JwSystemRegister> registerList = this.jwSystemRegisterService.queryByProperty(property);
                if (registerList != null && registerList.size() > 0) {
                    JwSystemRegister r = registerList.get(0);
                    Date thisDate = new Date();
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(r.getRegistertime());
                    ca.add(11, 1);
                    Date updateDate = ca.getTime();
                    if (thisDate.after(updateDate)) {
                        Date addDate = new Date();
                        register.setRegistertime(addDate);
                        register.setChecksign(0);
                        register.setAuthstring(UUID.randomUUID().toString());
                        register.setPassword(MD5Util.MD5Encode((String)register.getPassword(), (String)"utf-8"));
                        this.jwSystemRegisterService.doAdd(register);
                        j.setObj((Object)register.getId());
                        j.setSuccess(true);
                    } else {
                        r.setPassword(MD5Util.MD5Encode((String)register.getPassword(), (String)"utf-8"));
                        this.jwSystemRegisterService.doEdit(r);
                        j.setObj((Object)r.getId());
                        j.setSuccess(true);
                    }
                } else {
                    Date addDate = new Date();
                    register.setRegistertime(addDate);
                    register.setChecksign(0);
                    register.setAuthstring(UUID.randomUUID().toString());
                    register.setPassword(MD5Util.MD5Encode((String)register.getPassword(), (String)"utf-8"));
                    this.jwSystemRegisterService.doAdd(register);
                    j.setObj((Object)register.getId());
                    j.setSuccess(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            message = "\u6ce8\u518c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6ce8\u518c\u3002";
            j.setMsg(message);
        }
        return j;
    }

    @RequestMapping(value={"/doSendMail"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson doSendMail(String registerId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxJson j = new AjaxJson();
        try {
            JwSystemRegister register = this.jwSystemRegisterService.queryById(registerId);
            if (register != null) {
                if (register.getLastresendtime() == null) {
                    if (this.sendEmail(register)) {
                        register.setLastresendtime(new Date());
                        this.jwSystemRegisterService.doEdit(register);
                    }
                } else {
                    Date thisDate = new Date();
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(register.getLastresendtime());
                    ca.add(12, 2);
                    Date updateDate = ca.getTime();
                    if (thisDate.after(updateDate) && this.sendEmail(register)) {
                        register.setLastresendtime(new Date());
                        this.jwSystemRegisterService.doEdit(register);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return j;
    }

    private boolean sendEmail(JwSystemRegister register) {
        String content;
        String subject = "H5\u6d3b\u52a8\u4e4b\u5bb6\u6ce8\u518c\u9a8c\u8bc1";
        String baseurl = "http://www.h5huodong.com/system/check.do";
        String text = content = "\u7528\u6237 " + register.getEmail() + ",\u60a8\u597d\uff01<br/><br/>\u60a8\u6b63\u5728\u6ce8\u518cH5\u6d3b\u52a8\u4e4b\u5bb6\u767b\u5f55\u5e10\u53f7\uff0c\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u5ffd\u7565\u6b64\u90ae\u4ef6.<br/><br/>" + "<br/><a href='" + baseurl + "?authstring=" + register.getAuthstring() + "' target='_blank'>" + baseurl + "?authstring=" + register.getAuthstring() + "</a>" + "<br/><br/>" + "\u70b9\u51fb\u94fe\u63a5\u6fc0\u6d3b\u90ae\u7bb1\uff0c\u9a8c\u8bc1\u4fe1\u606f24\u5c0f\u65f6\u5185\u6709\u6548\uff01\u6fc0\u6d3b\u6210\u529f\u540e\u8bf7\u4f7f\u7528\u6ce8\u518c\u90ae\u7bb1\u767b\u5f55\u5e73\u53f0\u3002<br/><br/>" + "\u672c\u90ae\u4ef6\u662f\u7cfb\u7edf\u81ea\u52a8\u53d1\u9001\u7684\uff0c\u8bf7\u52ff\u76f4\u63a5\u56de\u590d\uff01\u611f\u8c22\u60a8\u7684\u8bbf\u95ee\uff0c\u795d\u60a8\u4f7f\u7528\u6109\u5feb\uff01<br/><br/>H5\u6d3b\u52a8\u4e4b\u5bb6\u56e2\u961f<br/><br/>";
        return SendMailUtil.sendCommonMail(register.getEmail(), subject, text);
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET, RequestMethod.POST})
    public void doCheck(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewName = "base/back/common/register.vm";
        VelocityContext velocityContext = new VelocityContext();
        String mode = "3";
        try {
            String authString = request.getParameter("authstring");
            if (!StringUtil.isEmpty((String)authString)) {
                JwSystemRegister property = new JwSystemRegister();
                property.setAuthstring(authString);
                List<JwSystemRegister> registerList = this.jwSystemRegisterService.queryByProperty(property);
                if (registerList != null && registerList.size() > 0) {
                    JwSystemRegister register = registerList.get(0);
                    Date thisDate = new Date();
                    Calendar ca = Calendar.getInstance();
                    ca.setTime(register.getRegistertime());
                    ca.add(11, 24);
                    Date updateDate = ca.getTime();
                    if (thisDate.after(updateDate)) {
                        velocityContext.put("msg", (Object)"\u9a8c\u8bc1\u4fe1\u606f\u8d85\u8fc724\u4e2a\u5c0f\u65f6\uff0c\u8bf7\u91cd\u65b0\u6ce8\u518c\uff01");
                        mode = "1";
                    } else {
                        LoginUser loginUser = this.jwSystemUserService.queryUserByUserId(register.getEmail());
                        if (loginUser != null) {
                            mode = "3";
                        } else {
                            JwSystemUser user = new JwSystemUser();
                            user.setUserId(register.getEmail());
                            user.setPassword(register.getPassword());
                            user.setEmail(register.getEmail());
                            user.setCreateDt(new Date());
                            user.setUserStat("NORMAL");
                            ArrayList<String> roleIds = new ArrayList<String>();
                            roleIds.add("01");
                            this.jwSystemUserService.doAdd(user, roleIds);
                            mode = "3";
                        }
                    }
                } else {
                    velocityContext.put("msg", (Object)"\u9a8c\u8bc1\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u6ce8\u518c\uff01");
                    mode = "1";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            velocityContext.put("msg", (Object)"\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u6ce8\u518c\uff01");
            mode = "1";
        }
        velocityContext.put("mode", (Object)mode);
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/getDefaultJwid"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson getDefaultJwid(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        try {
            LoginUser user = this.jwSystemUserService.queryUserByUserId(username);
            boolean isAuth = false;
            String passwordEncode = MD5Util.MD5Encode((String)password, (String)"utf-8");
            if (user != null) {
                if (passwordEncode != null && passwordEncode.equals(user.getPassword()) && "NORMAL".equals(user.getUserStat())) {
                    isAuth = true;
                } else {
                    LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u767b\u5f55\u4fe1\u606f\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
                }
            }
            JwSystemUserJwid jwSystemUserJwid = null;
            if (isAuth) {
                jwSystemUserJwid = this.jwSystemUserJwidService.queryOneByUserIdAndDefaultFlag(username, "1");
                if (jwSystemUserJwid == null) {
                    j.setObj((Object)this.defaultJwid);
                } else {
                    j.setObj((Object)jwSystemUserJwid.getJwid());
                }
            } else {
                LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            }
            j.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"/validateLogin"}, method={RequestMethod.GET, RequestMethod.POST})
    public AjaxJson validateLogin(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String sceneId = request.getParameter("sceneId");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String openid = WeiXinQrcodeUtil.getScanCodeRecord(this.defaultJwid, sceneId, "h5", sdf.format(new Date(new Date().getTime() - 300000L)), sdf.format(new Date()));
        try {
            if (StringUtils.isNotEmpty((String)openid)) {
                LoginUser loginUser = this.jwSystemUserService.queryUserByOpenid(openid);
                if (loginUser == null) {
                    JwSystemUser user = new JwSystemUser();
                    user.setUserId("wxuser_" + WeiXinQrcodeUtil.getUserId(10));
                    LoginUser loginUser2 = this.jwSystemUserService.queryUserByUserId(user.getUserId());
                    if (loginUser2 != null) {
                        user.setUserId("wxuser_" + WeiXinQrcodeUtil.getUserId(10));
                    }
                    user.setPassword(MD5Util.MD5Encode((String)WeiXinQrcodeUtil.getUserId(10), (String)"utf-8"));
                    user.setCreateDt(new Date());
                    user.setOpenid(openid);
                    user.setUserStat("NORMAL");
                    ArrayList<String> roleIds = new ArrayList<String>();
                    roleIds.add("01");
                    this.jwSystemUserService.doAdd(user, roleIds);
                    loginUser = this.jwSystemUserService.queryUserByOpenid(openid);
                    j.setObj((Object)"1");
                    request.getSession().setAttribute("system_userid", (Object)loginUser.getUserId());
                    request.getSession().setAttribute("OPERATE_WEB_LOGIN_USER", (Object)loginUser);
                    JwWebJwid jwWebJwid = this.jwidService.queryJwidNameByJwid(this.defaultJwid);
                    request.getSession().setAttribute("jwid", (Object)this.defaultJwid);
                    request.getSession().setAttribute("jwidname", (Object)jwWebJwid.getName());
                } else {
                    List<JwWebJwid> jwids = this.jwidService.queryJwWebJwidByUserId(loginUser.getUserId());
                    if (jwids == null || jwids.size() <= 0) {
                        j.setObj((Object)"1");
                        request.getSession().setAttribute("system_userid", (Object)loginUser.getUserId());
                        request.getSession().setAttribute("OPERATE_WEB_LOGIN_USER", (Object)loginUser);
                        JwWebJwid jwWebJwid = this.jwidService.queryJwidNameByJwid(this.defaultJwid);
                        request.getSession().setAttribute("jwid", (Object)this.defaultJwid);
                        request.getSession().setAttribute("jwidname", (Object)jwWebJwid.getName());
                    } else if (jwids.size() == 1) {
                        j.setObj((Object)"1");
                        request.getSession().setAttribute("system_userid", (Object)loginUser.getUserId());
                        request.getSession().setAttribute("OPERATE_WEB_LOGIN_USER", (Object)loginUser);
                        request.getSession().setAttribute("jwid", (Object)jwids.get(0).getJwid());
                        request.getSession().setAttribute("jwidname", (Object)jwids.get(0).getName());
                    } else {
                        request.getSession().setAttribute("openid", (Object)openid);
                    }
                }
            } else {
                j.setSuccess(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"/wxLogin"}, method={RequestMethod.GET, RequestMethod.POST})
    public AjaxJson wxLogin(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String openid = request.getSession().getAttribute("openid").toString();
        String jwid = request.getParameter("jwid");
        try {
            LoginUser loginUser = this.jwSystemUserService.queryUserByOpenid(openid);
            if (loginUser != null) {
                request.getSession().setAttribute("system_userid", (Object)loginUser.getUserId());
                request.getSession().setAttribute("OPERATE_WEB_LOGIN_USER", (Object)loginUser);
                JwWebJwid jwWebJwid = this.jwidService.queryJwidNameByJwid(jwid);
                request.getSession().setAttribute("jwid", (Object)jwid);
                request.getSession().setAttribute("jwidname", (Object)jwWebJwid.getName());
                request.getSession().removeAttribute("openid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setObj((Object)"\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25");
        }
        return j;
    }

    private String doAddQrcodeRecord(String jwid, String sceneId) {
        String qrcodeUrl = WeiXinQrcodeUtil.getTemporaryQrcode(jwid, sceneId, 300);
        if (StringUtils.isNotEmpty((String)qrcodeUrl)) {
            JwSystemQrcodeRecord jwSystemQrcodeRecord = new JwSystemQrcodeRecord();
            jwSystemQrcodeRecord.setExpireSeconds(300);
            jwSystemQrcodeRecord.setCreateTime(new Date());
            jwSystemQrcodeRecord.setJwid(jwid);
            jwSystemQrcodeRecord.setQrcodeUrl(qrcodeUrl);
            jwSystemQrcodeRecord.setSceneId(sceneId);
            this.jwSystemQrcodeRecordService.doAdd(jwSystemQrcodeRecord);
            return qrcodeUrl;
        }
        return null;
    }

    @RequestMapping(value={"/getQrcodeUrl"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson getQrcodeUrl(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String sceneId = WeiXinQrcodeUtil.getSceneId();
        try {
            String qrcodeUrl = this.doAddQrcodeRecord(this.defaultJwid, sceneId);
            if (StringUtils.isNotEmpty((String)qrcodeUrl)) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("sceneId", sceneId);
                param.put("qrcodeUrl", qrcodeUrl);
                j.setAttributes(param);
            } else {
                j.setSuccess(false);
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"/login2"}, method={RequestMethod.GET, RequestMethod.POST})
    public void login2(String jwid, String username, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext;
        String viewName;
        block16: {
            viewName = "base/back/common/login2.vm";
            velocityContext = new VelocityContext();
            try {
                String referer = request.getRequestURL().toString();
                if (referer != null && referer.trim().startsWith("http://h5huodong.com")) {
                    response.sendRedirect("http://www.h5huodong.com" + request.getRequestURI());
                    return;
                }
                LoginUser user = (LoginUser)request.getSession().getAttribute("OPERATE_WEB_LOGIN_USER");
                JwSystemLogoTitle logoTitle = this.jwSystemLogoTitleService.queryLogoTitle().get(0);
                velocityContext.put("logoTitle", (Object)logoTitle);
                if (user != null) {
                    viewName = indexPath;
                    velocityContext.put("jwidname", (Object)((String)request.getSession().getAttribute("jwidname")));
                    velocityContext.put("userid", (Object)user.getUserId());
                    try {
                        List<Menu> menuTree = this.jwSystemAuthService.getMenuTree(user.getUserId());
                        this.chargeAuthInterceptor(user, menuTree);
                        LOG.info("menuTree---->" + menuTree);
                        velocityContext.put("OPERATE_WEB_MENU_TREE", menuTree);
                        String userId = user.getUserId();
                        if (this.systemUserAuthService != null && !this.systemUserAuthService.checkUser(userId)) {
                            String basePath = request.getContextPath();
                            LOG.info("\u7528\u6237\u3010" + username + "\u3011\u6ca1\u6709\u7b7e\u8ba2\u534f\u8bae");
                            response.sendRedirect(String.valueOf(basePath) + "/system/toProtocol.do");
                        }
                        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                String randCode = request.getParameter("randCode");
                HttpSession session = request.getSession();
                Object yzm = session.getAttribute("randCode");
                if (StringUtils.isEmpty((String)randCode) || yzm == null || !randCode.equals(yzm.toString())) {
                    throw new RuntimeException("\u9a8c\u8bc1\u7801\u9519\u8bef");
                }
                session.removeAttribute("randCode");
                this.validateLoginParam(jwid, username, password);
                user = this.jwSystemUserService.queryUserByUserId(username);
                if (user != null) {
                    String passwordEncode = MD5Util.MD5Encode((String)password, (String)"utf-8");
                    if (passwordEncode == null || !passwordEncode.equals(user.getPassword()) || !"NORMAL".equals(user.getUserStat())) break block16;
                    JwWebJwid jw = null;
                    List<JwWebJwid> jwids = this.jwidService.queryJwWebJwidByUserId(username);
                    if (jwids != null && jwids.size() > 0) {
                        jw = this.jwidService.queryJwidByJwidAndUserId(jwid, username);
                    } else if ("Y".equals(this.selectDefaultJwidFlag) && this.defaultJwid.equals(jwid)) {
                        jw = this.jwidService.queryJwidNameByJwid(jwid);
                    }
                    if (jw != null) {
                        request.getSession().setAttribute("jwid", (Object)jwid);
                        request.getSession().setAttribute("jwidname", (Object)jw.getName());
                        request.getSession().setAttribute("system_userid", (Object)username);
                        request.getSession().setAttribute("OPERATE_WEB_LOGIN_USER", (Object)user);
                        velocityContext.put("jwidname", (Object)jw.getName());
                        velocityContext.put("userid", (Object)user.getUserId());
                        try {
                            List<Menu> menuTree = this.jwSystemAuthService.getMenuTree(user.getUserId());
                            this.chargeAuthInterceptor(user, menuTree);
                            LOG.info("menuTree---->" + menuTree);
                            velocityContext.put("OPERATE_WEB_MENU_TREE", menuTree);
                            viewName = indexPath;
                            String userId = user.getUserId();
                            if (this.systemUserAuthService != null && !this.systemUserAuthService.checkUser(userId)) {
                                String basePath = request.getContextPath();
                                LOG.info("\u7528\u6237\u3010" + username + "\u3011\u6ca1\u6709\u7b7e\u8ba2\u534f\u8bae");
                                response.sendRedirect(String.valueOf(basePath) + "/system/toProtocol.do");
                            }
                            ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    LOG.info("\u767b\u5f55\u5931\u8d25\uff1ajwid\u3010" + jwid + "\u3011\u4e0d\u5c5e\u4e8e\u7528\u6237\u3010" + username + "\u3011");
                    break block16;
                }
                LOG.info("\u767b\u5f55\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011\u4e0d\u5b58\u5728");
            }
            catch (Exception e) {
                LOG.info("\u767b\u5f55\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
            }
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    public void chargeAuthInterceptor(LoginUser user, List<Menu> menuTree) {
        if ("OFF".equals(interceptCharge)) {
            return;
        }
        if (!"1".equals(user.getChargeState())) {
            return;
        }
        for (Menu menu : menuTree) {
            if (!menu.getAuthContr().contains("/system/back/jwSystemAccount/toIndividual.do")) {
                menu.setAuthContr("/system/back/jwSystemAccount/toIndividual.do");
            }
            for (Menu cmenu : menu.getChildMenu()) {
                if (!cmenu.getAuthContr().contains("/system/back/jwSystemAccount/toIndividual.do")) {
                    cmenu.setAuthContr("/system/back/jwSystemAccount/toIndividual.do");
                }
                for (Menu ccmenu : cmenu.getChildMenu()) {
                    if (ccmenu.getAuthContr().contains("/system/back/jwSystemAccount/toIndividual.do")) continue;
                    ccmenu.setAuthContr("/system/back/jwSystemAccount/toIndividual.do");
                }
            }
        }
    }

    @RequestMapping(value={"/chargelogin"}, method={RequestMethod.GET, RequestMethod.POST})
    public void chargelogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String userId = (String)request.getSession().getAttribute("system_userid");
        LoginUser user = this.jwSystemUserService.queryUserByUserId(userId);
        request.getSession().setAttribute("OPERATE_WEB_LOGIN_USER", (Object)user);
        response.sendRedirect("login.do");
    }

    @RequestMapping(value={"/preSelectJwid"}, method={RequestMethod.GET, RequestMethod.POST})
    public void preSelectJwid(String username, HttpServletRequest request, HttpServletResponse response) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        String viewName = "base/back/common/preSelectJwid.vm";
        try {
            List<Object> jwids = new ArrayList();
            jwids = this.jwidService.queryJwWebJwidByUserId(username);
            velocityContext.put("jwids", jwids);
            velocityContext.put("sysJwssoFlag", (Object)this.sysJwssoFlag);
        }
        catch (Exception e) {
            LOG.info("\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff1a\u7528\u6237\u3010" + username + "\u3011" + e.getMessage());
        }
        ViewVelocity.view((HttpServletRequest)request, (HttpServletResponse)response, (String)viewName, (VelocityContext)velocityContext);
    }

    @RequestMapping(value={"/switchDefaultOfficialAcco"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson switchDefaultOfficialAcco(HttpServletRequest request) {
        AjaxJson ajson = new AjaxJson();
        try {
            String jwid = request.getParameter("jwid");
            if (StringUtils.isEmpty((String)jwid)) {
                jwid = this.defaultJwid;
            }
            request.getSession().setAttribute("jwid", (Object)jwid);
            JwWebJwid myJwWebJwid = this.jwidService.queryJwidNameByJwid(jwid);
            if (myJwWebJwid != null) {
                request.getSession().setAttribute("jwidname", (Object)myJwWebJwid.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ajson.setSuccess(false);
        }
        return ajson;
    }
}

