/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web;

import com.alibaba.fastjson.JSONObject;
import com.jeecg.p3.system.service.JwSystemProjectService;
import com.jeecg.p3.weixinInterface.entity.WeixinAccount;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.p3.core.util.PropertiesUtil;
import org.jeecgframework.p3.core.util.SignatureUtil;
import org.jeecgframework.p3.core.util.oConvertUtils;
import org.jeecgframework.p3.core.web.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import weixin.util.redis.JedisPoolUtil;

@Controller
@RequestMapping(value={"/linksucai"})
public class LinksucaiController
extends BaseController {
    @Autowired
    private JwSystemProjectService jwSystemProjectService;
    private static String SIGN_KEY = "";
    private static final String SCOPE = "snsapi_base";
    private static String domain = "";
    private static final Logger logger;

    static {
        PropertiesUtil oAuth = new PropertiesUtil("p3-web-sysconfig.properties");
        SIGN_KEY = oAuth.readProperty("oAuthSignKey");
        domain = oAuth.readProperty("oAuthDomain");
        logger = Logger.getLogger(LinksucaiController.class);
    }

    @RequestMapping(value={"link"}, method={RequestMethod.GET, RequestMethod.POST})
    public void link(HttpServletRequest request, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        logger.info((Object)("-------[LINKSTARTIME]--------------\u5f00\u59cb\u65f6\u95f4\u6233------------>" + start));
        try {
            String linkid = request.getParameter("linkid");
            String jwid = request.getParameter("jwid");
            String state = request.getParameter("state");
            WeixinAccount weixinAccount = JedisPoolUtil.getWxAccount((String)jwid);
            if (weixinAccount == null) {
                logger.error((Object)("------[\u5f02\u5e38]----------OpenWX----------\u5fae\u4fe1\u539f\u59cbID\u53c2\u6570\u5f02\u5e38,\u67e5\u8be2\u516c\u4f17\u53f7\u5931\u8d25\uff0c\u539f\u59cbID: ------" + jwid));
                return;
            }
            String code = request.getParameter("code");
            String APPID = weixinAccount.getAccountappid();
            String APPSECRET = weixinAccount.getAccountappsecret();
            if (code == null || code.length() == 0) {
                logger.info((Object)("-------[LINKWXSTEP1_START]-----------\u8ddd\u79bb\u5f00\u59cb\u65f6\u95f4\u6233\u8017\u65f6--------------->" + (System.currentTimeMillis() - start) + "ms"));
                String web_oauth_url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect";
                String REDIRECT_URI = request.getRequestURI();
                if (REDIRECT_URI.indexOf(domain) == -1) {
                    REDIRECT_URI = String.valueOf(domain.replace(request.getContextPath(), "")) + REDIRECT_URI;
                }
                logger.info((Object)("------------------REDIRECT_URI--------1---------" + REDIRECT_URI));
                REDIRECT_URI = String.valueOf(REDIRECT_URI) + "?" + request.getQueryString();
                logger.info((Object)("------------------REDIRECT_URI--------2---------" + REDIRECT_URI));
                REDIRECT_URI = URLEncoder.encode(REDIRECT_URI, "UTF-8");
                String weixinOauthURL = web_oauth_url.replace("APPID", APPID).replace("REDIRECT_URI", REDIRECT_URI).replace("SCOPE", SCOPE);
                if (oConvertUtils.isNotEmpty((Object)state)) {
                    weixinOauthURL = weixinOauthURL.replace("STATE", state);
                }
                logger.info((Object)("------------------weixinOauthURL-----------------" + weixinOauthURL));
                logger.info((Object)("-------[LINKWXSTEP1_END]--------------\u8ddd\u79bb\u5f00\u59cb\u65f6\u95f4\u6233\u8017\u65f6------------>" + (System.currentTimeMillis() - start) + "ms"));
                response.sendRedirect(weixinOauthURL);
            } else {
                logger.info((Object)("-------[LINKWXSTEP2_START]------------\u8ddd\u79bb\u5f00\u59cb\u65f6\u95f4\u6233\u8017\u65f6-------------->" + (System.currentTimeMillis() - start)));
                String requestUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code";
                requestUrl = requestUrl.replace("APPID", APPID);
                requestUrl = requestUrl.replace("SECRET", APPSECRET);
                requestUrl = requestUrl.replace("CODE", code);
                logger.info((Object)("------------------code-----------------" + code));
                logger.info((Object)("-------[LINKWXSTEP2_REQUEST]\u8c03\u7528\u5fae\u4fe1oauth2\u63a5\u53e3\u83b7\u53d6openid\u8bf7\u6c42-------------------------->" + (System.currentTimeMillis() - start) + "ms"));
                JSONObject json2 = this.httpRequest(requestUrl, "POST", null);
                logger.info((Object)("-------[LINKWXSTEP2_RESPONSE]\u8c03\u7528\u5fae\u4fe1oauth2\u63a5\u53e3\u83b7\u53d6openid\u54cd\u5e94-------------------------->" + (System.currentTimeMillis() - start) + "ms"));
                String openid = (String)json2.get((Object)"openid");
                logger.info((Object)("----------------get--openid-----------------" + openid));
                String jeewxUrl = String.valueOf(domain) + "/" + this.jwSystemProjectService.queryById(linkid).getHdzsUrl();
                if (oConvertUtils.isEmpty((Object)jeewxUrl)) {
                    logger.error((Object)("------[\u5f02\u5e38]----------OpenWX----------\u94fe\u63a5\u7d20\u6750ID\u53c2\u6570\u5f02\u5e38,\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0cLink ID: ------" + linkid));
                    return;
                }
                logger.info((Object)("----------------outerLink------1-----------" + jeewxUrl));
                if (oConvertUtils.isNotEmpty((Object)jeewxUrl)) {
                    jeewxUrl = jeewxUrl.replace("${openid}", openid);
                    jeewxUrl = jeewxUrl.replace("${wxid}", weixinAccount.getWeixinAccountid());
                    jeewxUrl = jeewxUrl.replace("${wxcode}", weixinAccount.getAccountnumber());
                    jeewxUrl = jeewxUrl.replace("${appid}", weixinAccount.getAccountappid());
                    jeewxUrl = jeewxUrl.replace("${appsecret}", weixinAccount.getAccountappsecret());
                    jeewxUrl = jeewxUrl.replace("${accesstoken}", weixinAccount.getAccountaccesstoken());
                }
                logger.info((Object)("----------------request.getQueryString()-------2----------" + request.getQueryString()));
                String queryParam = request.getQueryString();
                if (oConvertUtils.isNotEmpty((Object)queryParam)) {
                    jeewxUrl = String.valueOf(jeewxUrl) + "&" + queryParam;
                }
                logger.info((Object)("----------------outerLink-------3----------" + jeewxUrl));
                String sign = SignatureUtil.sign(this.getSignMap(jeewxUrl), (String)SIGN_KEY);
                logger.info((Object)("-------[LINKWXSTEP2_END]--------------\u8ddd\u79bb\u5f00\u59cb\u65f6\u95f4\u6233\u8017\u65f6------------>" + (System.currentTimeMillis() - start) + "ms"));
                response.sendRedirect(String.valueOf(jeewxUrl) + "&sign=" + sign);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        HttpURLConnection httpUrlConn = null;
        try {
            try {
                URL url = new URL(requestUrl);
                httpUrlConn = (HttpURLConnection)url.openConnection();
                httpUrlConn.setDoOutput(true);
                httpUrlConn.setDoInput(true);
                httpUrlConn.setUseCaches(false);
                httpUrlConn.setConnectTimeout(4500);
                httpUrlConn.setReadTimeout(4500);
                httpUrlConn.setRequestMethod(requestMethod);
                if ("GET".equalsIgnoreCase(requestMethod)) {
                    httpUrlConn.connect();
                }
                if (outputStr != null) {
                    OutputStream outputStream = httpUrlConn.getOutputStream();
                    outputStream.write(outputStr.getBytes("UTF-8"));
                    outputStream.close();
                }
                InputStream inputStream = httpUrlConn.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String str = null;
                while ((str = bufferedReader.readLine()) != null) {
                    buffer.append(str);
                }
                bufferedReader.close();
                inputStreamReader.close();
                inputStream.close();
                inputStream = null;
                httpUrlConn.disconnect();
                jsonObject = JSONObject.parseObject((String)buffer.toString());
            }
            catch (ConnectException connectException) {
                try {
                    httpUrlConn.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception exception) {
                try {
                    httpUrlConn.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                httpUrlConn.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    private Map<String, String> getSignMap(String url) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        url = url.substring(url.indexOf("?") + 1);
        String[] params = url.split("&");
        int i = 0;
        while (i < params.length) {
            String[] values;
            String param = params[i];
            if (param.indexOf("=") != -1 && (values = param.split("=")) != null && values.length == 2) {
                if ("nickname".equals(values[0])) {
                    paramMap.put(values[0], URLDecoder.decode(values[1]));
                } else {
                    paramMap.put(values[0], values[1]);
                }
            }
            ++i;
        }
        return paramMap;
    }
}

