/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.web;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.jeecg.p3.util.MatrixToImageWriter;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/CommonController"})
@Controller
public class CommonController {
    @RequestMapping(value={"downloadQRCode"}, method={RequestMethod.GET, RequestMethod.POST})
    public void downloadQRCode(@RequestParam(required=true, value="url") String url, @RequestParam(required=true, value="fileName") String fileName, HttpServletResponse response, HttpServletRequest request) throws Exception {
        String text = url;
        int width = 500;
        int height = 500;
        String format = "jpg";
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        fileName = String.valueOf(fileName) + ".jpg";
        response.setHeader("content-disposition", "attachment;fileName=" + URLEncoder.encode(fileName, "UTF-8"));
        ServletOutputStream out = response.getOutputStream();
        try {
            try {
                MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)format, (OutputStream)out);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

