/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jeecg.p3.system.util.HttpUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.MD5Util;
import org.jeecgframework.p3.core.util.WeiXinHttpUtil;
import org.jeecgframework.p3.core.utils.common.StringUtils;

public class WeiXinQrcodeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WeiXinQrcodeUtil.class);

    public static String getTemporaryQrcode(String jwid, String sceneId, Integer expireSeconds) {
        String accessToken = WeiXinHttpUtil.getRedisWeixinToken((String)jwid);
        try {
            JSONObject jsonObject;
            LOG.info("\u751f\u6210\u5e26\u53c2\u6570\u4e8c\u7ef4\u7801\u8bf7\u6c42\u53c2\u6570\uff1ajwid={},sceneId={},expireSeconds={}.", new Object[]{jwid, sceneId, expireSeconds});
            StringBuffer requestStr = new StringBuffer();
            requestStr.append("{\"action_info\":{\"scene\":{\"scene_id\":").append(sceneId).append("}},\"action_name\":\"QR_SCENE\",\"expire_seconds\":").append(expireSeconds).append("}");
            LOG.info("\u751f\u6210\u5e26\u53c2\u6570\u4e8c\u7ef4\u7801\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}.", new Object[]{requestStr.toString()});
            String jsonStr = HttpUtils.doPostJson("https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + accessToken, requestStr.toString());
            LOG.info("\u751f\u6210\u5e26\u53c2\u6570\u4e8c\u7ef4\u7801\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}.", new Object[]{jsonStr});
            if (jsonStr != null && (jsonObject = JSONObject.parseObject((String)jsonStr)).containsKey((Object)"ticket")) {
                String ticket = jsonObject.getString("ticket");
                String encode = URLEncoder.encode(ticket);
                return "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + encode;
            }
        }
        catch (Exception e) {
            LOG.info("\u751f\u6210\u5e26\u53c2\u6570\u4e8c\u7ef4\u7801\u63a5\u53e3\u9519\u8bef:{}.", new Object[]{e});
            return null;
        }
        return null;
    }

    public static String getScanCodeRecord(String jwid, String sceneId, String channel, String fromDate, String endDate) {
        String url = WeiXinHttpUtil.getLocalValue((String)"system", (String)"getScanRecordUrl");
        String key = WeiXinHttpUtil.getLocalValue((String)"system", (String)"scanRecordKey");
        Long st = new Date().getTime() + 1L;
        String opneid = null;
        try {
            JSONObject jsonObject;
            ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("weixinId", jwid));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("sceneId", sceneId));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("channel", channel));
            if (StringUtils.isNotEmpty((String)fromDate)) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("fromDate", fromDate));
            }
            if (StringUtils.isNotEmpty((String)endDate)) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair("endDate", endDate));
            }
            String str = "channel=" + channel;
            if (StringUtils.isNotEmpty((String)endDate)) {
                str = String.valueOf(str) + "&endDate=" + endDate;
            }
            if (StringUtils.isNotEmpty((String)fromDate)) {
                str = String.valueOf(str) + "&fromDate=" + fromDate;
            }
            str = String.valueOf(str) + "&sceneId=" + sceneId + "&weixinId=" + jwid + "&key=" + key;
            String md5Encode = MD5Util.MD5Encode((String)str, (String)"utf-8").toUpperCase();
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("signature", md5Encode));
            LOG.info("\u83b7\u53d6\u626b\u7801\u8bb0\u5f55\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", new Object[]{str});
            String jsonStr = HttpUtils.postForm(url, nameValuePairs);
            LOG.info("\u83b7\u53d6\u626b\u7801\u8bb0\u5f55\u63a5\u53e3\u8fd4\u56deJSONSTR={}", new Object[]{jsonStr});
            if (jsonStr != null && (jsonObject = JSONObject.parseObject((String)jsonStr)).containsKey((Object)"scanRecordList")) {
                JSONArray jsonArray = JSONArray.parseArray((String)jsonObject.getString("scanRecordList"));
                for (Object obj : jsonArray) {
                    JSONObject jsonObj = (JSONObject)obj;
                    if (!jsonObj.containsKey((Object)"scantime")) continue;
                    Long scantime = jsonObj.getLong("scantime");
                    if (!jsonObj.containsKey((Object)"openid") || scantime > st) continue;
                    st = scantime;
                    opneid = jsonObj.getString("openid");
                }
            }
        }
        catch (Exception e) {
            LOG.info("\u83b7\u53d6\u626b\u7801\u8bb0\u5f55\u63a5\u53e3\u5f02\u5e38{}", new Object[]{e});
        }
        return opneid;
    }

    public static String getSceneId() {
        int temp = 0;
        Random rd = new Random();
        StringBuffer sb = new StringBuffer();
        temp = rd.nextInt(4294) + 1;
        sb.append(temp);
        if (temp == 4294) {
            temp = rd.nextInt(967295);
            int i = 0;
            while (i < 6 - String.valueOf(temp).length()) {
                sb.append("0");
                ++i;
            }
            sb.append(temp);
        } else {
            temp = rd.nextInt(1000000);
            int i = 0;
            while (i < 6 - String.valueOf(temp).length()) {
                sb.append("0");
                ++i;
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    public static String getUserId(int k) {
        Random rd = new Random();
        StringBuffer sb = new StringBuffer();
        sb.append(rd.nextInt(9) + 1);
        int i = 0;
        while (i < k - 1) {
            sb.append(rd.nextInt(10));
            ++i;
        }
        return sb.toString();
    }
}

