/*
 * Decompiled with CFR 0.152.
 */
package com.jeecg.p3.system.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.mail.HtmlEmail;
import org.jeecgframework.p3.core.logger.Logger;
import org.jeecgframework.p3.core.logger.LoggerFactory;
import org.jeecgframework.p3.core.util.WeiXinHttpUtil;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

public class SendMailUtil {
    public static final Logger log = LoggerFactory.getLogger(SendMailUtil.class);
    private static final String from = WeiXinHttpUtil.getLocalValue((String)"system", (String)"mail.sender");
    private static final String smtpHost = WeiXinHttpUtil.getLocalValue((String)"system", (String)"mail.smtpHost");
    private static final String fromName = "H5\u6d3b\u52a8\u4e4b\u5bb6";
    private static final String charSet = "utf-8";
    private static final String username = WeiXinHttpUtil.getLocalValue((String)"system", (String)"mail.user");
    private static final String password = WeiXinHttpUtil.getLocalValue((String)"system", (String)"mail.pwd");
    private static Map<String, String> hostMap = new HashMap<String, String>();

    static {
        hostMap.put("smtp.126", "smtp.126.com");
        hostMap.put("smtp.qq", "smtp.qq.com");
        hostMap.put("smtp.163", "smtp.163.com");
        hostMap.put("smtp.sina", "smtp.sina.com.cn");
        hostMap.put("smtp.tom", "smtp.tom.com");
        hostMap.put("smtp.263", "smtp.263.net");
        hostMap.put("smtp.yahoo", "smtp.mail.yahoo.com");
        hostMap.put("smtp.hotmail", "smtp.live.com");
        hostMap.put("smtp.gmail", "smtp.gmail.com");
        hostMap.put("smtp.port.gmail", "465");
        hostMap.put("smtp.jeecg", "smtp.exmail.qq.com");
    }

    public static String getHost(String email) throws Exception {
        Pattern pattern = Pattern.compile("\\w+@(\\w+)(\\.\\w+){1,2}");
        Matcher matcher = pattern.matcher(email);
        String key = "unSupportEmail";
        if (matcher.find()) {
            key = "smtp." + matcher.group(1);
        }
        if (hostMap.containsKey(key)) {
            return hostMap.get(key);
        }
        throw new Exception("unSupportEmail");
    }

    public static int getSmtpPort(String email) throws Exception {
        Pattern pattern = Pattern.compile("\\w+@(\\w+)(\\.\\w+){1,2}");
        Matcher matcher = pattern.matcher(email);
        String key = "unSupportEmail";
        if (matcher.find()) {
            key = "smtp.port." + matcher.group(1);
        }
        if (hostMap.containsKey(key)) {
            return Integer.parseInt(hostMap.get(key));
        }
        return 25;
    }

    public static void sendFtlMail(String toMailAddr, String subject, String templatePath, Map<String, Object> map) {
        Template template = null;
        Configuration freeMarkerConfig = null;
        HtmlEmail hemail = new HtmlEmail();
        try {
            hemail.setHostName(SendMailUtil.getHost(from));
            hemail.setSmtpPort(SendMailUtil.getSmtpPort(from));
            hemail.setCharset(charSet);
            hemail.addTo(toMailAddr);
            hemail.setFrom(from, fromName);
            hemail.setAuthentication(username, password);
            hemail.setSubject(subject);
            freeMarkerConfig = new Configuration();
            freeMarkerConfig.setDirectoryForTemplateLoading(new File(SendMailUtil.getFilePath()));
            template = freeMarkerConfig.getTemplate(SendMailUtil.getFileName(templatePath), new Locale("Zh_cn"), "UTF-8");
            String htmlText = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, map);
            log.info(htmlText);
            hemail.setMsg(htmlText);
            hemail.send();
            log.info("email send true!");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("email send error!");
        }
    }

    public static boolean sendCommonMail(String toMailAddr, String subject, String message) {
        HtmlEmail hemail = new HtmlEmail();
        try {
            hemail.setHostName(smtpHost);
            hemail.setSmtpPort(SendMailUtil.getSmtpPort(from));
            hemail.setCharset(charSet);
            hemail.addTo(toMailAddr);
            hemail.setFrom(from, fromName);
            hemail.setAuthentication(username, password);
            hemail.setSubject(subject);
            hemail.setMsg(message);
            hemail.send();
            log.info("send email to " + toMailAddr + " OK!");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("send email to " + toMailAddr + " error!" + e.toString());
            return false;
        }
    }

    public static String getHtmlText(String templatePath, Map<String, Object> map) {
        Template template = null;
        String htmlText = "";
        try {
            Configuration freeMarkerConfig = null;
            freeMarkerConfig = new Configuration();
            freeMarkerConfig.setDirectoryForTemplateLoading(new File(SendMailUtil.getFilePath()));
            template = freeMarkerConfig.getTemplate(SendMailUtil.getFileName(templatePath), new Locale("Zh_cn"), "UTF-8");
            htmlText = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, map);
            log.info(htmlText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return htmlText;
    }

    private static String getFilePath() {
        String path = SendMailUtil.getAppPath(SendMailUtil.class);
        path = String.valueOf(path) + File.separator + "mailtemplate" + File.separator;
        path = path.replace("\\", "/");
        log.info(path);
        return path;
    }

    private static String getFileName(String path) {
        path = path.replace("\\", "/");
        log.info(path);
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getAppPath(Class cls) {
        URL url;
        String realPath;
        int pos;
        if (cls == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ClassLoader loader = cls.getClassLoader();
        String clsName = String.valueOf(cls.getName()) + ".class";
        Package pack = cls.getPackage();
        String path = "";
        if (pack != null) {
            String packName = pack.getName();
            if (packName.startsWith("java.") || packName.startsWith("javax.")) {
                throw new IllegalArgumentException("\u4e0d\u8981\u4f20\u9001\u7cfb\u7edf\u7c7b\uff01");
            }
            clsName = clsName.substring(packName.length() + 1);
            if (packName.indexOf(".") < 0) {
                path = String.valueOf(packName) + "/";
            } else {
                int start = 0;
                int end = 0;
                end = packName.indexOf(".");
                while (end != -1) {
                    path = String.valueOf(path) + packName.substring(start, end) + "/";
                    start = end + 1;
                    end = packName.indexOf(".", start);
                }
                path = String.valueOf(path) + packName.substring(start) + "/";
            }
        }
        if ((pos = (realPath = (url = loader.getResource(String.valueOf(path) + clsName)).getPath()).indexOf("file:")) > -1) {
            realPath = realPath.substring(pos + 5);
        }
        if ((realPath = realPath.substring(0, (pos = realPath.indexOf(String.valueOf(path) + clsName)) - 1)).endsWith("!")) {
            realPath = realPath.substring(0, realPath.lastIndexOf("/"));
        }
        try {
            realPath = URLDecoder.decode(realPath, charSet);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        log.info("realPath----->" + realPath);
        return realPath;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("subject", "\u6d4b\u8bd5\u6807\u9898");
        map.put("content", "\u6d4b\u8bd5 \u5185\u5bb9");
        String templatePath = "mailtemplate/test.ftl";
        SendMailUtil.sendCommonMail("445654970@qq.com", "\u6377\u5faeH5\u6ce8\u518c\u9a8c\u8bc1", "sendemail test!");
    }
}

